/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.xml.XMLLocalParserFactory;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ButtonModelStateChangeListenerForProperty;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.IconListComponent;
import org.freeplane.core.ui.components.JAutoToggleButton;
import org.freeplane.core.ui.components.ObjectIcon;
import org.freeplane.core.ui.components.ToolbarLayout;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.menu.JUnitPanel;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.ApplyNoFilteringAction;
import org.freeplane.features.filter.ApplySelectedViewConditionAction;
import org.freeplane.features.filter.ApplyToVisibleAction;
import org.freeplane.features.filter.EditFilterAction;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterHistory;
import org.freeplane.features.filter.FilterMenuBuilder;
import org.freeplane.features.filter.FindAction;
import org.freeplane.features.filter.HideMatchingNodesAction;
import org.freeplane.features.filter.QuickAndFilterAction;
import org.freeplane.features.filter.QuickFilterAction;
import org.freeplane.features.filter.QuickFindAction;
import org.freeplane.features.filter.QuickFindAllAction;
import org.freeplane.features.filter.QuickHighlightAction;
import org.freeplane.features.filter.QuickOrFilterAction;
import org.freeplane.features.filter.ReapplyFilterAction;
import org.freeplane.features.filter.RedoFilterAction;
import org.freeplane.features.filter.SelectFilteredElementAction;
import org.freeplane.features.filter.SelectFilteredNodesAction;
import org.freeplane.features.filter.SelectSearchRootAction;
import org.freeplane.features.filter.ShowAncestorsAction;
import org.freeplane.features.filter.ShowDescendantsAction;
import org.freeplane.features.filter.UndoFilterAction;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ConditionSnapshotFactory;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.filter.condition.NoFilteringCondition;
import org.freeplane.features.filter.condition.SelectedViewCondition;
import org.freeplane.features.highlight.HighlightController;
import org.freeplane.features.highlight.NodeHighlighter;
import org.freeplane.features.map.CloneOfSelectedViewCondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapNavigationUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.ToggleToolbarAction;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLWriter;
import org.freeplane.view.swing.map.NodeTooltipManager;

public class FilterController
implements IExtension,
IMapViewChangeListener {
    public static final Color HIGHLIGHT_COLOR = Color.MAGENTA;
    public static int TOOLBAR_SIDE = 0;
    public static final String FREEPLANE_FILTER_EXTENSION_WITHOUT_DOT = "mmfilter";
    private static final ASelectableCondition NO_FILTERING = NoFilteringCondition.createCondition();
    private final ButtonModel applyToVisibleElementsOnly;
    private Filter.FilteredElement filteredElement;
    private final ButtonModel applyToNodes;
    private final ButtonModel applyToNodesAndConnectors;
    private final ButtonModel applyToConnectors;
    private ConditionFactory conditionFactory;
    private DefaultConditionRenderer conditionRenderer = null;
    private final FilterChangeListener filterChangeListener;
    private DefaultComboBoxModel filterConditions;
    private final FilterMenuBuilder filterMenuBuilder;
    private JComponent filterToolbar;
    private final FilterHistory history;
    private final String pathToFilterFile;
    private ASelectableCondition selectedViewCondition;
    private ASelectableCondition cloneOfSelectedViewCondition;
    private final ButtonModel hideMatchingNodes;
    private final ButtonModel showAncestors;
    private final ButtonModel approximateMatchingButtonModel;
    private final ButtonModel ignoreDiacriticsButtonModel;
    private final ButtonModel caseSensitiveButtonModel;
    private final ButtonModel showDescendants;
    private final ButtonModel highlightNodes;
    private ASelectableCondition highlightCondition;
    private ConditionalStyleModel highlightedConditionContext;
    private JComboBox activeFilterConditionComboBox;
    private final FilterConditionEditor quickEditor;
    static final int USER_DEFINED_CONDITION_START_INDEX = 3;
    private final QuickFilterAction quickFilterAction;
    private int mapChangeCounter;
    private boolean applyFilterRunning;

    public static FilterController getController(Controller controller) {
        return controller.getExtension(FilterController.class);
    }

    public static FilterController getCurrentFilterController() {
        return FilterController.getController(Controller.getCurrentController());
    }

    public static Filter getFilter(MapModel map) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null && selection.getMap() == map) {
            return selection.getFilter();
        }
        Filter fallbackFilter = map.getExtension(Filter.class);
        if (fallbackFilter == null) {
            fallbackFilter = Filter.createTransparentFilter();
            map.putExtension(Filter.class, fallbackFilter);
        }
        return fallbackFilter;
    }

    public static void setFilter(MapModel map, Filter filter) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null && selection.getMap() == map) {
            selection.setFilter(filter);
        } else {
            map.putExtension(Filter.class, filter);
        }
    }

    public static void install() {
        final Controller controller = Controller.getCurrentController();
        FilterController extension = new FilterController();
        controller.addExtension(FilterController.class, extension);
        controller.getExtension(HighlightController.class).addNodeHighlighter(new NodeHighlighter(){

            @Override
            public boolean isNodeHighlighted(NodeModel node, IMapSelection selection, boolean isPrinting) {
                if (isPrinting) {
                    return false;
                }
                NodeModel searchRoot = selection.getSearchRoot();
                if (searchRoot != null && node != searchRoot && !node.isDescendantOf(searchRoot)) {
                    return false;
                }
                return FilterController.getController(controller).isNodeHighlighted(node);
            }

            @Override
            public void configure(NodeModel node, Graphics2D g, boolean isPrinting) {
                g.setColor(HIGHLIGHT_COLOR);
            }
        });
    }

    public FilterController() {
        Controller controller = Controller.getCurrentController();
        this.filterMenuBuilder = new FilterMenuBuilder(controller, this);
        this.history = new FilterHistory();
        this.filterChangeListener = new FilterChangeListener();
        this.showAncestors = new JToggleButton.ToggleButtonModel();
        Filter transparentFilter = Filter.createTransparentFilter();
        this.hideMatchingNodes = new JToggleButton.ToggleButtonModel();
        this.hideMatchingNodes.setSelected(transparentFilter.areMatchingElementsHidden());
        this.hideMatchingNodes.addChangeListener(this.filterChangeListener);
        this.showAncestors.setSelected(transparentFilter.areAncestorsShown());
        this.showAncestors.addChangeListener(this.filterChangeListener);
        this.showAncestors.addChangeListener(new ButtonModelStateChangeListenerForProperty("filter.showAncestors"));
        this.showDescendants = new JToggleButton.ToggleButtonModel();
        this.showDescendants.setSelected(transparentFilter.areDescendantsShown());
        this.showDescendants.addChangeListener(this.filterChangeListener);
        this.showDescendants.addChangeListener(new ButtonModelStateChangeListenerForProperty("filter.showDescendants"));
        this.highlightNodes = new JToggleButton.ToggleButtonModel();
        this.highlightNodes.setSelected(false);
        this.applyToVisibleElementsOnly = new JToggleButton.ToggleButtonModel();
        this.applyToVisibleElementsOnly.setSelected(false);
        this.applyToNodes = new JToggleButton.ToggleButtonModel();
        this.filteredElement = transparentFilter.getFilteredElement();
        this.applyToNodes.setSelected(this.filteredElement == Filter.FilteredElement.NODE);
        this.applyToNodesAndConnectors = new JToggleButton.ToggleButtonModel();
        this.applyToNodesAndConnectors.setSelected(this.filteredElement == Filter.FilteredElement.NODE_AND_CONNECTOR);
        this.applyToConnectors = new JToggleButton.ToggleButtonModel();
        this.applyToConnectors.setSelected(this.filteredElement == Filter.FilteredElement.CONNECTOR);
        this.applyToNodes.addChangeListener(this.filterChangeListener);
        this.applyToNodesAndConnectors.addChangeListener(this.filterChangeListener);
        this.applyToConnectors.addChangeListener(this.filterChangeListener);
        this.approximateMatchingButtonModel = new JToggleButton.ToggleButtonModel();
        this.approximateMatchingButtonModel.setSelected(false);
        this.ignoreDiacriticsButtonModel = new JToggleButton.ToggleButtonModel();
        this.ignoreDiacriticsButtonModel.setSelected(false);
        this.caseSensitiveButtonModel = new JToggleButton.ToggleButtonModel();
        this.caseSensitiveButtonModel.setSelected(false);
        controller.getMapViewManager().addMapViewChangeListener(this);
        ToggleFilterToolbarAction showFilterToolbar = new ToggleFilterToolbarAction("ShowFilterToolbarAction", "/filter_toolbar");
        this.quickEditor = new FilterConditionEditor(this, 0, FilterConditionEditor.Variant.FILTER_TOOLBAR);
        this.quickEditor.setEnterKeyActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((QuickFindAction)Controller.getCurrentController().getAction("QuickFindAction.FORWARD")).executeAction(true);
                if (FilterController.this.getHighlightNodes().isSelected()) {
                    FilterController.this.setHighlightCondition(FilterController.this.quickEditor.getCondition(), null);
                }
            }
        });
        controller.addAction(showFilterToolbar);
        controller.addAction(new ApplyNoFilteringAction(this));
        controller.addAction(new ApplySelectedViewConditionAction(this));
        controller.addAction(new EditFilterAction(this));
        controller.addAction(new UndoFilterAction(this));
        controller.addAction(new RedoFilterAction(this));
        controller.addAction(new ReapplyFilterAction(this));
        controller.addAction(new SelectFilteredNodesAction(this));
        controller.addAction(new HideMatchingNodesAction(this));
        controller.addAction(new ShowAncestorsAction(this));
        controller.addAction(new ShowDescendantsAction(this));
        controller.addAction(new ApplyToVisibleAction(this));
        controller.addAction(new SelectFilteredElementAction(this.applyToNodes, Filter.FilteredElement.NODE));
        controller.addAction(new SelectFilteredElementAction(this.applyToNodesAndConnectors, Filter.FilteredElement.NODE_AND_CONNECTOR));
        controller.addAction(new SelectFilteredElementAction(this.applyToConnectors, Filter.FilteredElement.CONNECTOR));
        controller.addAction(new SelectSearchRootAction());
        this.quickFilterAction = new QuickFilterAction(this, this.quickEditor);
        controller.addAction(this.quickFilterAction);
        controller.addAction(new QuickAndFilterAction(this, this.quickEditor));
        controller.addAction(new QuickOrFilterAction(this, this.quickEditor));
        controller.addAction(new QuickFindAction(this, this.quickEditor, MapController.Direction.BACK_VISIBLE));
        controller.addAction(new QuickFindAction(this, this.quickEditor, MapController.Direction.BACK));
        controller.addAction(new QuickFindAction(this, this.quickEditor, MapController.Direction.BACK_REMOVE_FILTER));
        controller.addAction(new QuickFindAction(this, this.quickEditor, MapController.Direction.FORWARD_VISIBLE));
        controller.addAction(new QuickFindAction(this, this.quickEditor, MapController.Direction.FORWARD));
        controller.addAction(new QuickFindAction(this, this.quickEditor, MapController.Direction.FORWARD_REMOVE_FILTER));
        controller.addAction(new QuickFindAllAction(this, this.quickEditor));
        controller.addAction(new QuickHighlightAction(this, this.quickEditor));
        FindAction find = new FindAction();
        controller.addAction(find);
        controller.addAction(find.getFindNextAction());
        controller.addAction(find.getFindPreviousAction());
        this.pathToFilterFile = ResourceController.getResourceController().getFreeplaneUserDirectory() + File.separator + "auto." + FREEPLANE_FILTER_EXTENSION_WITHOUT_DOT;
    }

    private void addStandardConditions() {
        ASelectableCondition noFiltering = NO_FILTERING;
        this.filterConditions.insertElementAt(noFiltering, 0);
        if (this.selectedViewCondition == null) {
            this.selectedViewCondition = SelectedViewCondition.createCondition();
        }
        this.filterConditions.insertElementAt(this.selectedViewCondition, 1);
        if (this.filterConditions.getSelectedItem() == null) {
            this.filterConditions.setSelectedItem(noFiltering);
        }
        if (this.cloneOfSelectedViewCondition == null) {
            this.cloneOfSelectedViewCondition = CloneOfSelectedViewCondition.createCondition();
        }
        this.filterConditions.insertElementAt(this.cloneOfSelectedViewCondition, 2);
    }

    @Override
    public void afterViewChange(Component oldView, Component newView) {
        this.updateUILater();
    }

    private void updateUILater() {
        if (this.filterToolbar == null) {
            return;
        }
        ++this.mapChangeCounter;
        Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

            @Override
            public void run() {
                FilterController.this.mapChangeCounter--;
                if (0 == FilterController.this.mapChangeCounter) {
                    FilterController.this.updateUI();
                }
            }
        });
    }

    private void updateUI() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null) {
            this.filterToolbar.setEnabled(true);
            this.activeFilterConditionComboBox.setEnabled(true);
            this.quickEditor.setEnabled(true);
            Filter filter = selection.getFilter();
            this.quickEditor.filterChanged(filter);
            this.updateSettingsFromFilter(filter);
            this.quickFilterAction.setSelected(this.isFilterActive());
            this.history.clear();
            this.history.add(filter);
        } else {
            this.filterConditions.setSelectedItem(this.filterConditions.getElementAt(0));
            this.filterToolbar.setEnabled(false);
            this.quickEditor.setEnabled(false);
            this.activeFilterConditionComboBox.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyFilter(boolean force) {
        if (this.applyFilterRunning) {
            return;
        }
        this.applyFilterRunning = true;
        try {
            this.quickFilterAction.setSelected(this.isFilterActive());
            ASelectableCondition selectedCondition = this.getSelectedCondition();
            Filter filter = this.createFilter(selectedCondition);
            ICondition condition = this.condition(filter);
            if (condition != selectedCondition && condition instanceof ASelectableCondition) {
                this.getFilterConditions().setSelectedItem(condition);
            }
            this.applyFilter(force, filter);
            this.history.add(filter);
        }
        finally {
            this.applyFilterRunning = false;
        }
    }

    public void applyNoFiltering(MapModel map) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null && selection.getMap() == map) {
            this.getFilterConditions().setSelectedItem(NO_FILTERING);
        } else {
            Filter filter = new Filter(NO_FILTERING, this.hideMatchingNodes.isSelected(), this.showAncestors.isSelected(), this.showDescendants.isSelected(), false, this.filteredElement, null);
            map.putExtension(Filter.class, filter);
            filter.calculateFilterResults(map);
        }
    }

    public void applyFilter(MapModel map, boolean force, Filter filter) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null && selection.getMap() == map) {
            this.applyFilter(force, filter);
            this.updateSettingsFromFilter(filter);
            this.history.add(filter);
        } else {
            Filter oldFilter = (Filter)map.putExtension(Filter.class, filter);
            if (oldFilter == null || force || !filter.canUseFilterResultsFrom(oldFilter)) {
                filter.calculateFilterResults(map);
                NodeModel selectionRoot = selection.getSelectionRoot();
                if (!selectionRoot.isRoot()) {
                    filter.resetFilter(selectionRoot);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFilter(boolean force, Filter filter) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null) {
            try {
                filter.displayFilterStatus();
                Controller.getCurrentController().getViewController().setWaitingCursor(true);
                Filter oldFilter = selection.getFilter();
                selection.setFilter(filter);
                MapModel map = selection.getSelected().getMap();
                if (force || !filter.canUseFilterResultsFrom(oldFilter)) {
                    filter.calculateFilterResults(map);
                    NodeModel selectionRoot = selection.getSelectionRoot();
                    if (!selectionRoot.isRoot()) {
                        filter.resetFilter(selectionRoot);
                    }
                } else {
                    filter.useFilterResultsFrom(oldFilter);
                }
                this.refreshMap(this, map);
                this.selectVisibleNodes(selection);
            }
            finally {
                Controller.getCurrentController().getViewController().setWaitingCursor(false);
            }
        }
    }

    private void refreshMap(Object source, MapModel map) {
        Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent(source, map, Filter.class, null, this, false));
    }

    public void selectVisibleNodes(IMapSelection selection) {
        Filter filter = selection.getFilter();
        NodeModel selectedVisible = selection.getSelected().getVisibleAncestorOrSelf(filter);
        selection.preserveNodeLocationOnScreen(selectedVisible, 0.5f, 0.5f);
        Set<NodeModel> selectedNodes = selection.getSelection();
        NodeModel[] array = new NodeModel[selectedNodes.size()];
        boolean next = false;
        NodeModel selectionRoot = selection.getSelectionRoot();
        for (NodeModel node : selectedNodes.toArray(array)) {
            if (next) {
                if (node.hasVisibleContent(filter) || selectionRoot == node) continue;
                selection.toggleSelected(node);
                continue;
            }
            next = true;
        }
        NodeModel selected = selection.getSelected();
        if (!selected.hasVisibleContent(filter) && selectionRoot != selected) {
            if (selection.getSelection().size() > 1) {
                selection.toggleSelected(selected);
            } else {
                NodeModel visibleAncestorOrSelf = selected.getVisibleAncestorOrSelf(filter);
                if (selectionRoot.isDescendantOf(visibleAncestorOrSelf)) {
                    selection.selectAsTheOnlyOneSelected(selectionRoot);
                } else {
                    selection.selectAsTheOnlyOneSelected(visibleAncestorOrSelf);
                }
            }
        }
    }

    void applySelectedViewCondition() {
        if (this.getFilterConditions().getSelectedItem() != this.selectedViewCondition) {
            this.getFilterConditions().setSelectedItem(this.selectedViewCondition);
        } else {
            this.applyFilter(true);
        }
    }

    private Filter createFilter(ASelectableCondition selectedCondition) {
        ASelectableCondition filterCondition = selectedCondition == null || selectedCondition.equals(NO_FILTERING) ? null : (selectedCondition instanceof ConditionSnapshotFactory ? ((ConditionSnapshotFactory)((Object)selectedCondition)).createSnapshotCondition() : selectedCondition);
        IMapSelection selection = Controller.getCurrentController().getSelection();
        Filter baseFilter = selection != null ? selection.getFilter() : null;
        Filter filter = new Filter(filterCondition, this.hideMatchingNodes.isSelected(), this.showAncestors.isSelected(), this.showDescendants.isSelected(), this.applyToVisibleElementsOnly.isSelected(), this.filteredElement, baseFilter);
        return filter;
    }

    private JComponent createFilterToolbar() {
        Controller controller = Controller.getCurrentController();
        AbstractButton undoBtn = FreeplaneToolBar.createButton(controller.getAction("UndoFilterAction"));
        AbstractButton redoBtn = FreeplaneToolBar.createButton(controller.getAction("RedoFilterAction"));
        JAutoToggleButton showAncestorsBox = new JAutoToggleButton(controller.getAction("ShowAncestorsAction"), this.showAncestors);
        showAncestorsBox.setSelected(this.showAncestors.isSelected());
        JAutoToggleButton showDescendantsBox = new JAutoToggleButton(controller.getAction("ShowDescendantsAction"), this.showDescendants);
        JAutoToggleButton hideMatchingNodesBox = new JAutoToggleButton(controller.getAction("HideMatchingNodesAction"), this.hideMatchingNodes);
        hideMatchingNodesBox.setSelected(this.hideMatchingNodes.isSelected());
        JAutoToggleButton applyToVisibleBox = new JAutoToggleButton(controller.getAction("ApplyToVisibleAction"), this.applyToVisibleElementsOnly);
        JAutoToggleButton applyToNodesBox = new JAutoToggleButton(controller.getAction("SelectFilteredElementAction.NODE"), this.applyToNodes);
        applyToNodesBox.setSelected(this.applyToNodes.isSelected());
        JAutoToggleButton applyToNodesAndConnectorsBox = new JAutoToggleButton(controller.getAction("SelectFilteredElementAction.NODE_AND_CONNECTOR"), this.applyToNodesAndConnectors);
        applyToNodesAndConnectorsBox.setSelected(this.applyToNodesAndConnectors.isSelected());
        JAutoToggleButton applyToConnectorsBox = new JAutoToggleButton(controller.getAction("SelectFilteredElementAction.CONNECTOR"), this.applyToConnectors);
        applyToConnectorsBox.setSelected(this.applyToConnectors.isSelected());
        AbstractButton btnEdit = FreeplaneToolBar.createButton(controller.getAction("EditFilterAction"));
        this.getFilterConditions();
        AbstractButton reapplyFilterBtn = FreeplaneToolBar.createButton(controller.getAction("ReapplyFilterAction"));
        AbstractButton selectFilteredNodesBtn = FreeplaneToolBar.createButton(controller.getAction("SelectFilteredNodesAction"));
        AbstractButton filterSelectedBtn = FreeplaneToolBar.createButton(controller.getAction("ApplySelectedViewConditionAction"));
        AbstractButton noFilteringBtn = FreeplaneToolBar.createButton(controller.getAction("ApplyNoFilteringAction"));
        AbstractButton applyFindPreviousVisibleBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFindAction.BACK_VISIBLE"));
        AbstractButton applyFindPreviousBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFindAction.BACK"));
        AbstractButton applyFindPreviousRemovindFilterBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFindAction.BACK_REMOVE_FILTER"));
        AbstractButton applyFindNextVisibleBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFindAction.FORWARD_VISIBLE"));
        AbstractButton applyFindNextBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFindAction.FORWARD"));
        AbstractButton applyFindNextRemovindFilterBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFindAction.FORWARD_REMOVE_FILTER"));
        AbstractButton applyQuickFilterBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFilterAction"));
        AbstractButton applyAndFilterBtn = FreeplaneToolBar.createButton(controller.getAction("QuickAndFilterAction"));
        AbstractButton applyOrFilterBtn = FreeplaneToolBar.createButton(controller.getAction("QuickOrFilterAction"));
        AbstractButton applyQuickSelectBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFindAllAction"));
        AbstractButton applyQuickHighlightBtn = FreeplaneToolBar.createButton(controller.getAction("QuickHighlightAction"));
        AbstractButton selectSearchRootActionBtn = FreeplaneToolBar.createButton(controller.getAction("SelectSearchRootAction"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        JComponent searchOptionPanel = this.quickEditor.getOptionPanel();
        constraints.weightx = 1.0;
        searchOptionPanel.add((Component)new JUnitPanel(), constraints);
        constraints.weightx = 0.0;
        searchOptionPanel.add((Component)applyQuickHighlightBtn, constraints);
        searchOptionPanel.add((Component)applyQuickSelectBtn, constraints);
        searchOptionPanel.add((Component)applyQuickFilterBtn, constraints);
        searchOptionPanel.add((Component)applyAndFilterBtn, constraints);
        searchOptionPanel.add((Component)applyOrFilterBtn, constraints);
        searchOptionPanel.add((Component)selectSearchRootActionBtn, constraints);
        FreeplaneToolBar searchPanel = new FreeplaneToolBar("searchPanel", 0);
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        ((Container)searchPanel).add((Component)applyFindNextVisibleBtn, constraints);
        ((Container)searchPanel).add((Component)applyFindNextBtn, constraints);
        ((Container)searchPanel).add((Component)applyFindNextRemovindFilterBtn, constraints);
        constraints.gridy = 1;
        ((Container)searchPanel).add((Component)applyFindPreviousVisibleBtn, constraints);
        ((Container)searchPanel).add((Component)applyFindPreviousBtn, constraints);
        ((Container)searchPanel).add((Component)applyFindPreviousRemovindFilterBtn, constraints);
        FreeplaneToolBar filterOptionPanel = new FreeplaneToolBar("filterOptionPanel", 0);
        constraints.gridy = 0;
        constraints.gridwidth = 11;
        constraints.gridheight = 1;
        filterOptionPanel.add((Component)this.activeFilterConditionComboBox, constraints);
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        filterOptionPanel.add((Component)applyToNodesBox, constraints);
        filterOptionPanel.add((Component)applyToNodesAndConnectorsBox, constraints);
        filterOptionPanel.add((Component)applyToConnectorsBox, constraints);
        filterOptionPanel.add((Component)showAncestorsBox, constraints);
        filterOptionPanel.add((Component)showDescendantsBox, constraints);
        filterOptionPanel.add((Component)hideMatchingNodesBox, constraints);
        constraints.weightx = 1.0;
        filterOptionPanel.add((Component)new JUnitPanel(), constraints);
        constraints.weightx = 0.0;
        filterOptionPanel.add((Component)applyToVisibleBox, constraints);
        filterOptionPanel.add((Component)reapplyFilterBtn, constraints);
        filterOptionPanel.add((Component)selectFilteredNodesBtn, constraints);
        filterOptionPanel.add((Component)filterSelectedBtn, constraints);
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        filterOptionPanel.add((Component)undoBtn, constraints);
        filterOptionPanel.add((Component)redoBtn, constraints);
        constraints.gridy = 1;
        filterOptionPanel.add((Component)noFilteringBtn, constraints);
        filterOptionPanel.add((Component)btnEdit, constraints);
        DefaultConditionRenderer toolbarConditionRenderer = new DefaultConditionRenderer(TextUtils.getText("filter_no_filtering"), false);
        this.activeFilterConditionComboBox.setRenderer(toolbarConditionRenderer);
        JPanel filterToolbar = new JPanel();
        filterToolbar.setLayout(ToolbarLayout.horizontal());
        filterToolbar.add(new JSeparator(1));
        filterToolbar.add(this.quickEditor.getPanel());
        filterToolbar.add(searchPanel);
        filterToolbar.add(new JSeparator(1));
        filterToolbar.add(filterOptionPanel);
        filterToolbar.setVisible(ResourceController.getResourceController().getBooleanProperty("filter_toolbar_visible"));
        UIComponentVisibilityDispatcher.install(filterToolbar, "filter_toolbar_visible");
        return filterToolbar;
    }

    JComboBox createActiveFilterConditionBox() {
        JComboBox box = new JComboBox(this.getFilterConditions()){
            {
                this.setMaximumRowCount(10);
            }

            @Override
            public String getToolTipText() {
                return "tooltip";
            }

            @Override
            public JToolTip createToolTip() {
                JToolTip tip = new JToolTip(){

                    @Override
                    public void setTipText(String tipText) {
                        ASelectableCondition selectedItem = FilterController.this.getSelectedFilterCondition();
                        IconListComponent renderer = selectedItem.getListCellRendererComponent(this.getFontMetrics(this.getFont()));
                        MouseAdapter mouseListener = new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                ASelectableCondition removedCondition = this.getConditionUnderMouse(e);
                                if (removedCondition != null && removedCondition != NO_FILTERING) {
                                    this.removeCondition(removedCondition);
                                }
                            }

                            private ASelectableCondition getConditionUnderMouse(MouseEvent e) {
                                IconListComponent component = this.getComponent(e);
                                Icon icon = component.getIconAt(e.getPoint());
                                if (icon instanceof ObjectIcon) {
                                    ASelectableCondition condition = (ASelectableCondition)((ObjectIcon)icon).getObject();
                                    return condition;
                                }
                                return null;
                            }

                            private IconListComponent getComponent(MouseEvent e) {
                                return (IconListComponent)e.getComponent();
                            }

                            private void removeCondition(ASelectableCondition removedCondition) {
                                ASelectableCondition selectedFilterCondition = FilterController.this.getSelectedFilterCondition();
                                ASelectableCondition newCondition = selectedFilterCondition.removeCondition(removedCondition);
                                if (newCondition != selectedFilterCondition) {
                                    FilterController.this.apply(newCondition == null ? NO_FILTERING : newCondition);
                                    NodeTooltipManager.getSharedInstance().hideTipWindow();
                                }
                            }

                            @Override
                            public void mouseEntered(MouseEvent e) {
                                this.highlightCondition(e);
                            }

                            @Override
                            public void mouseExited(MouseEvent e) {
                                this.getComponent(e).highlightRemovedIcon(null);
                            }

                            private void highlightCondition(MouseEvent e) {
                                IconListComponent component = this.getComponent(e);
                                if (FilterController.this.getSelectedCondition() == NO_FILTERING) {
                                    component.highlightRemovedIcon(null);
                                } else {
                                    Icon icon = component.getIconAt(e.getPoint());
                                    component.highlightRemovedIcon(icon);
                                }
                            }

                            @Override
                            public void mouseMoved(MouseEvent e) {
                                this.highlightCondition(e);
                            }
                        };
                        renderer.addMouseListener(mouseListener);
                        renderer.addMouseMotionListener(mouseListener);
                        renderer.setBorder(BorderFactory.createRaisedBevelBorder());
                        this.add(renderer);
                        this.setCursor(Cursor.getPredefinedCursor(12));
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        if (this.getComponentCount() == 0) {
                            return super.getPreferredSize();
                        }
                        Component renderer = this.getComponent(0);
                        return renderer.getPreferredSize();
                    }

                    @Override
                    public void doLayout() {
                        if (this.getComponentCount() == 0) {
                            super.doLayout();
                            return;
                        }
                        Component renderer = this.getComponent(0);
                        renderer.setLocation(0, 0);
                        renderer.setSize(this.getSize());
                    }
                };
                tip.setComponent(this);
                return tip;
            }

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                int height = this.getHeight();
                return new Point(height / 5, 4 * height / 5);
            }
        };
        NodeTooltipManager.getSharedInstance().registerComponent(box);
        box.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        box.addActionListener(this.filterChangeListener);
        return box;
    }

    protected ButtonModel getApplyToVisibleElementsOnly() {
        return this.applyToVisibleElementsOnly;
    }

    public ConditionFactory getConditionFactory() {
        if (this.conditionFactory == null) {
            this.conditionFactory = new ConditionFactory();
        }
        return this.conditionFactory;
    }

    DefaultConditionRenderer getConditionRenderer() {
        if (this.conditionRenderer == null) {
            this.conditionRenderer = new DefaultConditionRenderer(TextUtils.getText("filter_no_filtering"), true);
        }
        return this.conditionRenderer;
    }

    public DefaultComboBoxModel getFilterConditions() {
        if (this.filterConditions == null) {
            this.initConditions();
        }
        return this.filterConditions;
    }

    public JComponent getFilterToolbar() {
        if (this.filterToolbar == null) {
            this.filterToolbar = this.createFilterToolbar();
        }
        return this.filterToolbar;
    }

    public FilterConditionEditor getQuickEditor() {
        return this.quickEditor;
    }

    ASelectableCondition getSelectedCondition() {
        return (ASelectableCondition)this.getFilterConditions().getSelectedItem();
    }

    public ButtonModel getShowAncestors() {
        return this.showAncestors;
    }

    public ButtonModel getHideMatchingNodes() {
        return this.hideMatchingNodes;
    }

    public ButtonModel getShowDescendants() {
        return this.showDescendants;
    }

    public ButtonModel getHighlightNodes() {
        return this.highlightNodes;
    }

    void setHighlightCondition(ASelectableCondition condition, ConditionalStyleModel highlightedConditionContext) {
        this.highlightedConditionContext = highlightedConditionContext;
        if (condition != null) {
            this.highlightCondition = condition;
            this.getHighlightNodes().setSelected(true);
        } else {
            this.highlightCondition = null;
        }
        JComponent mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        if (mapViewComponent != null) {
            mapViewComponent.repaint();
        }
    }

    private void initConditions() {
        this.filterConditions = new DefaultComboBoxModel(){

            @Override
            public void setSelectedItem(Object anObject) {
                int selectedItemIndex;
                if (ResourceController.getResourceController().getBooleanProperty("saveQuickFilters") && (selectedItemIndex = this.getIndexOf(anObject)) == -1 && anObject instanceof ASelectableCondition && ((ASelectableCondition)anObject).canBePersisted()) {
                    this.insertElementAt(anObject, 3);
                }
                super.setSelectedItem(anObject);
            }
        };
        this.addStandardConditions();
        this.filterConditions.setSelectedItem(this.filterConditions.getElementAt(0));
        if (this.activeFilterConditionComboBox == null) {
            this.activeFilterConditionComboBox = this.createActiveFilterConditionBox();
        }
    }

    public void loadDefaultConditions() {
        try {
            this.loadConditions(this.getFilterConditions(), this.pathToFilterFile, false);
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
    }

    void loadConditions(DefaultComboBoxModel filterConditionModel, String pathToFilterFile, boolean showPopupOnError) throws IOException {
        block5: {
            try {
                IXMLParser parser = XMLLocalParserFactory.createLocalXMLParser();
                File filterFile = new File(pathToFilterFile);
                StdXMLReader reader = new StdXMLReader(new BufferedInputStream(new FileInputStream(filterFile)));
                parser.setReader(reader);
                reader.setSystemID(filterFile.toURL().toString());
                XMLElement loader = (XMLElement)parser.parse();
                Vector<XMLElement> conditions = loader.getChildren();
                for (int i = 0; i < conditions.size(); ++i) {
                    ASelectableCondition condition = this.getConditionFactory().loadCondition(conditions.get(i));
                    if (condition == null) continue;
                    filterConditionModel.addElement(condition);
                }
            }
            catch (FileNotFoundException parser) {
            }
            catch (AccessControlException parser) {
            }
            catch (Exception e) {
                LogUtils.warn(e);
                if (!showPopupOnError) break block5;
                UITools.errorMessage(TextUtils.getText("filters_not_loaded"));
            }
        }
    }

    public void saveConditions() {
        try {
            ResourceController resourceController = ResourceController.getResourceController();
            int savedConditionLimit = resourceController.getBooleanProperty("saveQuickFilters") ? resourceController.getIntProperty("savedConditionLimit") : Integer.MAX_VALUE;
            this.saveConditions(this.getFilterConditions(), this.pathToFilterFile, savedConditionLimit);
        }
        catch (Exception e) {
            LogUtils.warn(e);
        }
    }

    void saveConditions(DefaultComboBoxModel filterConditionModel, String pathToFilterFile, int savedConditionLimit) throws IOException {
        XMLElement saver = new XMLElement();
        saver.setName("filter_conditions");
        int savedConditionNumber = Math.min(savedConditionLimit, filterConditionModel.getSize());
        for (int i = 0; i < savedConditionNumber; ++i) {
            ASelectableCondition cond = (ASelectableCondition)filterConditionModel.getElementAt(i);
            if (cond == null || !cond.canBePersisted()) continue;
            cond.toXml(saver);
        }
        try (FileWriter writer = new FileWriter(pathToFilterFile);){
            XMLWriter xmlWriter = new XMLWriter(writer);
            xmlWriter.write(saver, true);
        }
    }

    void setFilterConditions(DefaultComboBoxModel newConditionModel) {
        this.filterConditions.removeAllElements();
        Object selectedItem = newConditionModel.getSelectedItem();
        if (selectedItem != null) {
            this.filterConditions.addElement(selectedItem);
        }
        for (int i = 0; i < newConditionModel.getSize(); ++i) {
            Object element = newConditionModel.getElementAt(i);
            if (element == selectedItem) continue;
            this.filterConditions.addElement(element);
        }
        this.filterMenuBuilder.updateMenus();
        this.addStandardConditions();
        this.applyFilter(false);
    }

    private void updateSettingsFromFilter(Filter filter) {
        this.applyFilterRunning = true;
        try {
            ICondition condition = this.condition(filter);
            if (condition instanceof ASelectableCondition) {
                this.filterConditions.setSelectedItem(condition);
            } else {
                this.filterConditions.setSelectedItem(NO_FILTERING);
            }
            this.hideMatchingNodes.setSelected(filter.areMatchingElementsHidden());
            this.showAncestors.setSelected(filter.areAncestorsShown());
            this.showDescendants.setSelected(filter.areDescendantsShown());
            this.applyToVisibleElementsOnly.setSelected(filter.appliesToVisibleElementsOnly());
            this.applyToNodes.setSelected(filter.getFilteredElement() == Filter.FilteredElement.NODE);
            this.applyToNodesAndConnectors.setSelected(filter.getFilteredElement() == Filter.FilteredElement.NODE_AND_CONNECTOR);
            this.applyToConnectors.setSelected(filter.getFilteredElement() == Filter.FilteredElement.CONNECTOR);
            this.quickFilterAction.setSelected(this.isFilterActive());
        }
        finally {
            this.applyFilterRunning = false;
        }
    }

    private ICondition condition(Filter filter) {
        ICondition condition = filter.getCondition();
        if (condition == null) {
            return NO_FILTERING;
        }
        return condition;
    }

    void updateSettingsFromHistory() {
        Filter filter = this.history.getCurrentFilter();
        this.updateSettingsFromFilter(filter);
    }

    NodeModel findNextInSubtree(NodeModel start, NodeModel subtreeRoot, MapController.Direction direction, ICondition condition, Filter filter) {
        NodeModel next = this.findNext(start, subtreeRoot, direction, condition, filter);
        if (next == null && subtreeRoot != null && subtreeRoot != start) {
            next = condition == null || condition.checkNode(subtreeRoot) ? subtreeRoot : this.findNext(subtreeRoot, subtreeRoot, direction, condition, filter);
        }
        return next;
    }

    NodeModel findNext(NodeModel from, NodeModel end, MapController.Direction direction, ICondition condition, Filter filter) {
        block2: {
            NodeModel next = from;
            while (true) {
                if ((next = direction.isForward() ? MapNavigationUtils.findNext(direction, next, end) : MapNavigationUtils.findPrevious(direction, next, end)) == null) {
                    return null;
                }
                if (!direction.removesFilter() && !next.hasVisibleContent(filter)) continue;
                if (next == from) break block2;
                if (condition == null || condition.checkNode(next)) break;
            }
            return next;
        }
        return null;
    }

    public void redo() {
        this.history.redo();
        this.updateSettingsFromHistory();
    }

    public void undo() {
        this.history.undo();
        this.updateSettingsFromHistory();
    }

    private boolean isNodeHighlighted(NodeModel node) {
        if (this.highlightCondition == null) {
            return false;
        }
        if (this.highlightedConditionContext == null) {
            return this.highlightCondition.checkNode(node);
        }
        try {
            this.highlightedConditionContext.setDisabled(true);
            boolean bl = this.highlightCondition != null && this.highlightCondition.checkNode(node);
            return bl;
        }
        finally {
            this.highlightedConditionContext.setDisabled(false);
        }
    }

    public ButtonModel getApproximateMatchingButtonModel() {
        return this.approximateMatchingButtonModel;
    }

    public ButtonModel getIgnoreDiacriticsButtonModel() {
        return this.ignoreDiacriticsButtonModel;
    }

    public ButtonModel getCaseSensitiveButtonModel() {
        return this.caseSensitiveButtonModel;
    }

    public void apply(ASelectableCondition condition) {
        DefaultComboBoxModel filterConditions = this.getFilterConditions();
        if (condition.equals(filterConditions.getSelectedItem())) {
            this.applyFilter(true);
        } else {
            this.activeFilterConditionComboBox.setEditable(true);
            filterConditions.setSelectedItem(condition);
            this.activeFilterConditionComboBox.setEditable(false);
        }
    }

    public EntryVisitor getMenuBuilder() {
        return this.filterMenuBuilder;
    }

    public boolean isFilterActive() {
        ASelectableCondition selectedCondition = this.getSelectedCondition();
        return NO_FILTERING != selectedCondition && null != selectedCondition;
    }

    public void mapRootNodeChanged(MapModel map) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null && map.equals(selection.getMap())) {
            this.updateUILater();
        }
    }

    private ASelectableCondition getSelectedFilterCondition() {
        return this.getSelectedCondition();
    }

    private class FilterChangeListener
    implements ChangeListener,
    ActionListener {
        private boolean changeInProgress = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.changeInProgress) {
                return;
            }
            try {
                this.changeInProgress = true;
                Object source = e.getSource();
                Filter.FilteredElement oldFilteredElement = FilterController.this.filteredElement;
                if (source == FilterController.this.applyToNodes) {
                    FilterController.this.applyToConnectors.setSelected(false);
                    FilterController.this.applyToNodesAndConnectors.setSelected(false);
                    FilterController.this.filteredElement = Filter.FilteredElement.NODE;
                } else if (source == FilterController.this.applyToNodesAndConnectors) {
                    this.changeInProgress = true;
                    FilterController.this.applyToNodes.setSelected(false);
                    FilterController.this.applyToConnectors.setSelected(false);
                    FilterController.this.filteredElement = Filter.FilteredElement.NODE_AND_CONNECTOR;
                } else if (source == FilterController.this.applyToConnectors) {
                    this.changeInProgress = true;
                    FilterController.this.applyToNodes.setSelected(false);
                    FilterController.this.applyToNodesAndConnectors.setSelected(false);
                    FilterController.this.filteredElement = Filter.FilteredElement.CONNECTOR;
                }
                if (oldFilteredElement != FilterController.this.filteredElement) {
                    ResourceController.getResourceController().setProperty("filter.filteredElement", FilterController.this.filteredElement.name());
                }
            }
            finally {
                this.changeInProgress = false;
            }
            FilterController.this.applyFilter(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FilterController.this.getSelectedCondition() != null) {
                FilterController.this.applyFilter(true);
            }
        }
    }

    @SelectableAction(checkOnPopup=true)
    private class ToggleFilterToolbarAction
    extends ToggleToolbarAction {
        private ToggleFilterToolbarAction(String actionName, String toolbarName) {
            super(actionName, toolbarName);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComponent toolbar = this.getToolbar();
            if (toolbar == null) {
                return;
            }
            boolean visible = this.isVisible();
            if (visible && !FilterController.this.quickEditor.isInputFieldFocused() && EventQueue.getCurrentEvent() instanceof KeyEvent) {
                FilterController.this.quickEditor.focusInputField(true);
            } else {
                this.changeFocusWhenVisibilityChanges(toolbar);
                super.actionPerformed(event);
            }
        }

        private void changeFocusWhenVisibilityChanges(JComponent toolBar) {
            final JComponent editorPanel = FilterController.this.quickEditor.getPanel();
            editorPanel.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    FilterController.this.quickEditor.focusInputField(true);
                    editorPanel.removeAncestorListener(this);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    Component selectedComponent = Controller.getCurrentController().getMapViewManager().getSelectedComponent();
                    if (selectedComponent != null) {
                        selectedComponent.requestFocusInWindow();
                    }
                    editorPanel.removeAncestorListener(this);
                }
            });
        }
    }
}

