/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class QuickFindAllAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final FilterConditionEditor filterEditor;
    private final FilterController filterController;

    QuickFindAllAction(FilterController filterController, FilterConditionEditor quickEditor) {
        super("QuickFindAllAction");
        this.filterController = filterController;
        this.filterEditor = quickEditor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NodeModel searchRoot;
        ASelectableCondition condition = this.filterEditor.getCondition();
        if (condition == null) {
            return;
        }
        IMapSelection selection = Controller.getCurrentController().getSelection();
        MapController mapController = Controller.getCurrentModeController().getMapController();
        NodeModel selected = selection.getSelected();
        NodeModel searchStart = selected == (searchRoot = selection.getEffectiveSearchRoot()) || selected.isDescendantOf(searchRoot) ? selected : searchRoot;
        boolean nodeFound = condition.checkNode(searchStart);
        if (nodeFound) {
            selection.selectAsTheOnlyOneSelected(searchStart);
        }
        NodeModel next = searchRoot;
        while ((next = this.filterController.findNext(next, searchRoot, MapController.Direction.FORWARD, condition, selection.getFilter())) != null) {
            mapController.displayNode(next);
            if (nodeFound) {
                selection.toggleSelected(next);
                continue;
            }
            selection.selectAsTheOnlyOneSelected(next);
            nodeFound = true;
        }
        if (condition.checkNode(searchStart)) {
            selection.makeTheSelected(searchStart);
        }
    }
}

