/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.SourcedInterruptedException;
import com.jogamp.common.util.locks.SingletonInstance;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class SingletonInstanceServerSocket
extends SingletonInstance {
    private static int serverInstanceCount = 0;
    private final Server singletonServer;
    private final String fullName;

    public SingletonInstanceServerSocket(long l, int n) {
        super(l);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getByName("localhost");
                if (null != inetAddress && !inetAddress.isLoopbackAddress()) {
                    inetAddress = null;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
                if (null != inetAddress && !inetAddress.isLoopbackAddress()) {
                    inetAddress = null;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            throw new RuntimeException(this.infoPrefix() + " EEE Could not determine local InetAddress");
        }
        this.fullName = inetAddress.toString() + ":" + n;
        this.singletonServer = new Server(inetAddress, n);
        Runtime.getRuntime().addShutdownHook(new InterruptSource.Thread(){

            @Override
            public void run() {
                SingletonInstanceServerSocket.this.singletonServer.kill();
            }
        });
    }

    public final InetAddress getLocalInetAddress() {
        return this.singletonServer.getLocalInetAddress();
    }

    public final int getPortNumber() {
        return this.singletonServer.getPortNumber();
    }

    @Override
    public final String getName() {
        return this.fullName;
    }

    @Override
    protected boolean tryLockImpl() {
        if (this.singletonServer.isRunning()) {
            return false;
        }
        Socket socket = this.singletonServer.connect();
        if (null != socket) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return this.singletonServer.start();
    }

    @Override
    protected boolean unlockImpl() {
        return this.singletonServer.shutdown();
    }

    public class Server
    implements Runnable {
        private final InetAddress localInetAddress;
        private final int portNumber;
        private volatile boolean shallQuit = false;
        private volatile boolean alive = false;
        private final Object syncOnStartStop = new Object();
        private ServerSocket serverSocket = null;
        private Thread serverThread = null;

        public Server(InetAddress inetAddress, int n) {
            this.localInetAddress = inetAddress;
            this.portNumber = n;
        }

        public final InetAddress getLocalInetAddress() {
            return this.localInetAddress;
        }

        public final int getPortNumber() {
            return this.portNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean start() {
            if (this.alive) {
                return true;
            }
            Object object = Server.class;
            synchronized (Server.class) {
                serverInstanceCount++;
                String string = "SingletonServerSocket" + serverInstanceCount + "-" + SingletonInstanceServerSocket.this.fullName;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                object = this.syncOnStartStop;
                synchronized (object) {
                    this.shallQuit = false;
                    this.serverThread = new InterruptSource.Thread(null, this, string);
                    this.serverThread.setDaemon(true);
                    this.serverThread.start();
                    try {
                        while (!this.alive && !this.shallQuit) {
                            this.syncOnStartStop.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedException interruptedException2 = SourcedInterruptedException.wrap(interruptedException);
                        this.shutdown(false);
                        throw new InterruptedRuntimeException(interruptedException2);
                    }
                }
                boolean bl = this.isBound();
                if (!bl) {
                    this.shutdown(true);
                }
                return bl;
            }
        }

        public final boolean shutdown() {
            return this.shutdown(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean shutdown(boolean bl) {
            if (!this.alive) {
                return true;
            }
            try {
                Object object = this.syncOnStartStop;
                synchronized (object) {
                    this.shallQuit = true;
                    this.connect();
                    if (bl) {
                        try {
                            while (this.alive) {
                                this.syncOnStartStop.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            throw new InterruptedRuntimeException(interruptedException);
                        }
                    }
                }
            }
            finally {
                if (this.alive) {
                    System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " EEE " + SingletonInstanceServerSocket.this.getName() + " - Unable to remove lock: ServerThread still alive ?");
                    this.kill();
                }
            }
            return true;
        }

        public final void kill() {
            if (this.alive) {
                System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " XXX " + SingletonInstanceServerSocket.this.getName() + " - Kill @ JVM Shutdown");
            }
            this.alive = false;
            this.shallQuit = false;
            if (null != this.serverThread && this.serverThread.isAlive()) {
                try {
                    this.serverThread.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (null != this.serverSocket) {
                try {
                    ServerSocket serverSocket = this.serverSocket;
                    this.serverSocket = null;
                    serverSocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public final boolean isRunning() {
            return this.alive;
        }

        public final boolean isBound() {
            return this.alive && null != this.serverSocket && this.serverSocket.isBound();
        }

        public final Socket connect() {
            try {
                return new Socket(this.localInetAddress, this.portNumber);
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " III - Start");
            try {
                object = this.syncOnStartStop;
                synchronized (object) {
                    try {
                        this.serverSocket = new ServerSocket(this.portNumber, 1, this.localInetAddress);
                        this.serverSocket.setReuseAddress(true);
                        this.alive = true;
                    }
                    catch (IOException iOException) {
                        System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " III - Unable to install ServerSocket: " + iOException.getMessage());
                        this.shallQuit = true;
                    }
                    finally {
                        this.syncOnStartStop.notifyAll();
                    }
                }
                while (!this.shallQuit) {
                    try {
                        object = this.serverSocket.accept();
                        ((Socket)object).close();
                    }
                    catch (IOException iOException) {
                        System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " EEE - Exception during accept: " + iOException.getMessage());
                    }
                }
                object = this.syncOnStartStop;
            }
            catch (ThreadDeath threadDeath) {
                Object object2;
                try {
                    ExceptionUtils.dumpThrowable("", threadDeath);
                    object2 = this.syncOnStartStop;
                }
                catch (Throwable throwable) {
                    Object object3 = this.syncOnStartStop;
                    synchronized (object3) {
                        System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " III - Stopping: alive " + this.alive + ", shallQuit " + this.shallQuit + ", hasSocket " + (null != this.serverSocket));
                        if (null != this.serverSocket) {
                            try {
                                this.serverSocket.close();
                            }
                            catch (IOException iOException) {
                                System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " EEE - Exception during close: " + iOException.getMessage());
                            }
                        }
                        this.serverSocket = null;
                        this.alive = false;
                        this.syncOnStartStop.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (object2) {
                    System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " III - Stopping: alive " + this.alive + ", shallQuit " + this.shallQuit + ", hasSocket " + (null != this.serverSocket));
                    if (null != this.serverSocket) {
                        try {
                            this.serverSocket.close();
                        }
                        catch (IOException iOException) {
                            System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " EEE - Exception during close: " + iOException.getMessage());
                        }
                    }
                    this.serverSocket = null;
                    this.alive = false;
                    this.syncOnStartStop.notifyAll();
                }
            }
            synchronized (object) {
                System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " III - Stopping: alive " + this.alive + ", shallQuit " + this.shallQuit + ", hasSocket " + (null != this.serverSocket));
                if (null != this.serverSocket) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {
                        System.err.println(SingletonInstanceServerSocket.this.infoPrefix() + " EEE - Exception during close: " + iOException.getMessage());
                    }
                }
                this.serverSocket = null;
                this.alive = false;
                this.syncOnStartStop.notifyAll();
            }
        }
    }
}

