/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;

class TransitionShorthandSetter
extends ShorthandSetter {
    private String cssText = null;
    private String minifiedCssText = null;
    private int transitionsCount = 0;
    private final ValueList lstProperty = ValueList.createCSValueList();
    private final ValueList lstDuration = ValueList.createCSValueList();
    private final ValueList lstTiming = ValueList.createCSValueList();
    private final ValueList lstDelay = ValueList.createCSValueList();

    TransitionShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(baseCSSStyleDeclaration, "transition");
    }

    @Override
    public void init(LexicalUnit lexicalUnit, boolean bl) {
        this.currentValue = lexicalUnit;
        this.setPriority(bl);
        this.setCssText(lexicalUnit);
        this.countTransitions(lexicalUnit);
    }

    private void setCssText(LexicalUnit lexicalUnit) {
        StringBuilder stringBuilder = new StringBuilder(64);
        StringBuilder stringBuilder2 = new StringBuilder(64);
        block5: do {
            switch (lexicalUnit.getLexicalUnitType()) {
                case OPERATOR_COMMA: {
                    stringBuilder.append(',');
                    stringBuilder2.append(',');
                    break;
                }
                case OPERATOR_SLASH: {
                    stringBuilder.append('/');
                    stringBuilder2.append('/');
                    break;
                }
                case OPERATOR_EXP: {
                    stringBuilder.append('^');
                    stringBuilder2.append('^');
                    break;
                }
                default: {
                    ValueItem valueItem = this.valueFactory.createCSSValueItem(lexicalUnit, true);
                    StyleValue styleValue = valueItem.getCSSValue();
                    int n = stringBuilder.length();
                    if (n != 0) {
                        char c = stringBuilder.charAt(n - 1);
                        if (c != ',') {
                            stringBuilder2.append(' ');
                        }
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(styleValue.getCssText());
                    stringBuilder2.append(styleValue.getMinifiedCssText(this.getShorthandName()));
                    if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
                        lexicalUnit = valueItem.getNextLexicalUnit();
                        continue block5;
                    }
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    continue block5;
                }
            }
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        } while (lexicalUnit != null);
        this.cssText = stringBuilder.toString();
        this.minifiedCssText = stringBuilder2.toString();
    }

    @Override
    public String getCssText() {
        return this.cssText;
    }

    @Override
    public String getMinifiedCssText() {
        return this.minifiedCssText;
    }

    private void countTransitions(LexicalUnit lexicalUnit) {
        this.transitionsCount = 0;
        int n = 0;
        for (LexicalUnit lexicalUnit2 = lexicalUnit; lexicalUnit2 != null; lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) {
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (n <= 0) continue;
                ++this.transitionsCount;
                n = 0;
                continue;
            }
            ++n;
        }
        if (n > 0) {
            ++this.transitionsCount;
        }
    }

    @Override
    public boolean assignSubproperties() {
        int n;
        int n2;
        int n3 = 0;
        block0: while (n3 < this.transitionsCount && this.currentValue != null) {
            n2 = 1;
            boolean bl = true;
            n = 1;
            boolean bl2 = true;
            while (this.currentValue != null) {
                Object object;
                LexicalUnit.LexicalType lexicalType = this.currentValue.getLexicalUnitType();
                if (lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    ++n3;
                    this.nextCurrentValue();
                    break;
                }
                LexicalUnit.LexicalType lexicalType2 = this.currentValue.getLexicalUnitType();
                if (lexicalType2 == LexicalUnit.LexicalType.INHERIT || lexicalType2 == LexicalUnit.LexicalType.REVERT) {
                    if (n3 != 0 || n2 == 0 || !bl || n == 0 || !bl2 || this.currentValue.getNextLexicalUnit() != null) {
                        this.reportDeclarationError("transition", "Found 'inherit' or 'revert' mixed with other values.");
                        return false;
                    }
                    object = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue();
                    this.addSingleValueLayer((StyleValue)object);
                    this.appendValueItemString((StyleValue)object);
                    break block0;
                }
                if (lexicalType2 == LexicalUnit.LexicalType.INITIAL || lexicalType2 == LexicalUnit.LexicalType.UNSET) {
                    if (n2 == 0 || !bl || n == 0 || !bl2 || (object = this.currentValue.getNextLexicalUnit()) != null && object.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.reportDeclarationError("transition", "Found a keyword mixed with other values.");
                        return false;
                    }
                    this.nextCurrentValue();
                    continue;
                }
                if ((bl || bl2) && ValueFactory.isTimeSACUnit(this.currentValue)) {
                    if (bl) {
                        object = this.createCSSValue("transition-duration", this.currentValue);
                        if (object != null) {
                            this.lstDuration.add((StyleValue)object);
                            bl = false;
                            this.nextCurrentValue();
                            continue;
                        }
                    } else {
                        object = this.createCSSValue("transition-delay", this.currentValue);
                        if (object != null) {
                            this.lstDelay.add((StyleValue)object);
                            bl2 = false;
                            this.nextCurrentValue();
                            continue;
                        }
                    }
                }
                if (n != 0) {
                    if (LexicalUnit.LexicalType.IDENT == lexicalType) {
                        if (this.testIdentifiers("transition-timing-function")) {
                            object = this.createCSSValue("transition-timing-function", this.currentValue);
                            this.lstTiming.add((StyleValue)object);
                            n = 0;
                            this.nextCurrentValue();
                            continue;
                        }
                    } else if ((lexicalType == LexicalUnit.LexicalType.CUBIC_BEZIER_FUNCTION || lexicalType == LexicalUnit.LexicalType.STEPS_FUNCTION) && (object = this.createCSSValue("transition-timing-function", this.currentValue)) != null) {
                        this.lstTiming.add((StyleValue)object);
                        n = 0;
                        this.nextCurrentValue();
                        continue;
                    }
                }
                if (n2 != 0 && (lexicalType == LexicalUnit.LexicalType.IDENT || lexicalType == LexicalUnit.LexicalType.STRING)) {
                    object = this.createCSSValue("transition-property", this.currentValue);
                    if (!"none".equals(((StyleValue)object).getCssText()) || this.transitionsCount == 1) {
                        this.lstProperty.add((StyleValue)object);
                        n2 = 0;
                        this.nextCurrentValue();
                        continue;
                    }
                    this.reportDeclarationError("transition", "Found 'none' in a multiple declaration.");
                    return false;
                }
                object = this.styleDeclaration.getStyleDeclarationErrorHandler();
                if (object != null) {
                    if (lexicalType == LexicalUnit.LexicalType.IDENT) {
                        object.unknownIdentifier("transition", this.currentValue.getStringValue());
                    } else {
                        StyleValue styleValue = this.createCSSValue("transition", this.currentValue);
                        object.unassignedShorthandValue("transition", styleValue.getCssText());
                    }
                }
                return false;
            }
            if (n2 != 0) {
                this.lstProperty.add(this.defaultPropertyValue("transition-property"));
            }
            if (bl) {
                this.lstDuration.add(this.defaultPropertyValue("transition-duration"));
            }
            if (n != 0) {
                this.lstTiming.add(this.defaultPropertyValue("transition-timing-function"));
            }
            if (!bl2) continue;
            this.lstDelay.add(this.defaultPropertyValue("transition-delay"));
        }
        if ((n2 = this.lstProperty.getLength()) > 1) {
            for (n3 = 1; n3 < n2; ++n3) {
                StyleValue styleValue = this.lstProperty.item(n3);
                if (!"all".equals(styleValue.getCssText())) continue;
                for (n = n3 - 1; n != -1; --n) {
                    this.lstDuration.set(n, this.lstDuration.item(n3));
                    this.lstTiming.set(n, this.lstTiming.item(n3));
                    this.lstDelay.set(n, this.lstDelay.item(n3));
                }
            }
        }
        this.setSubpropertyValueWListCheck("transition-property", this.lstProperty);
        this.setSubpropertyValueWListCheck("transition-duration", this.lstDuration);
        this.setSubpropertyValueWListCheck("transition-timing-function", this.lstTiming);
        this.setSubpropertyValueWListCheck("transition-delay", this.lstDelay);
        this.flush();
        return true;
    }

    private void addSingleValueLayer(StyleValue styleValue) {
        this.lstProperty.add(styleValue);
        this.lstDuration.add(styleValue);
        this.lstTiming.add(styleValue);
        this.lstDelay.add(styleValue);
    }

    @Override
    void reportDeclarationError(String string, String string2) {
        this.lstProperty.clear();
        this.lstDuration.clear();
        this.lstTiming.clear();
        this.lstDelay.clear();
        this.cssText = "";
        super.reportDeclarationError(string, string2);
    }
}

