/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionServices;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.UnavailableResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactResults;

public class DefaultVisitedArtifactResults
implements VisitedArtifactResults {
    private final List<ArtifactSet> artifactsById;

    public DefaultVisitedArtifactResults(ImmutableList<ArtifactSet> artifactsById) {
        this.artifactsById = artifactsById;
    }

    @Override
    public SelectedArtifactResults select(ArtifactSelectionServices consumerServices, ArtifactSelectionSpec spec, boolean lenient) {
        ArrayList<ResolvedArtifactSet> resolvedArtifactSets = new ArrayList<ResolvedArtifactSet>(this.artifactsById.size());
        for (ArtifactSet artifactSet : this.artifactsById) {
            ResolvedArtifactSet resolvedArtifacts = artifactSet.select(consumerServices, spec);
            if (!lenient || !(resolvedArtifacts instanceof UnavailableResolvedArtifactSet)) {
                resolvedArtifactSets.add(resolvedArtifacts);
                continue;
            }
            resolvedArtifactSets.add(ResolvedArtifactSet.EMPTY);
        }
        return new DefaultSelectedArtifactResults(spec.getSortOrder(), resolvedArtifactSets);
    }

    private static class DefaultSelectedArtifactResults
    implements SelectedArtifactResults {
        private final ResolvedArtifactSet allArtifacts;
        private final List<ResolvedArtifactSet> resolvedArtifactsById;

        DefaultSelectedArtifactResults(ResolutionStrategy.SortOrder sortOrder, List<ResolvedArtifactSet> resolvedArtifactsById) {
            this.resolvedArtifactsById = resolvedArtifactsById;
            this.allArtifacts = sortOrder == ResolutionStrategy.SortOrder.DEPENDENCY_FIRST ? CompositeResolvedArtifactSet.of(Lists.reverse(resolvedArtifactsById)) : CompositeResolvedArtifactSet.of(resolvedArtifactsById);
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return this.allArtifacts;
        }

        @Override
        public ResolvedArtifactSet getArtifactsWithId(int id) {
            return this.resolvedArtifactsById.get(id);
        }
    }
}

