/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.tasks;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.jacoco.JacocoCoverageAction;
import org.gradle.internal.jacoco.rules.JacocoViolationRulesContainerImpl;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.jacoco.tasks.JacocoReportBase;
import org.gradle.testing.jacoco.tasks.rules.JacocoViolationRulesContainer;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class JacocoCoverageVerification
extends JacocoReportBase {
    private final JacocoViolationRulesContainer violationRules;
    private final String projectName = this.getProject().getName();

    public JacocoCoverageVerification() {
        Instantiator instantiator = this.getInstantiator();
        this.violationRules = (JacocoViolationRulesContainer)instantiator.newInstance(JacocoViolationRulesContainerImpl.class, new Object[]{instantiator});
    }

    @Nested
    public JacocoViolationRulesContainer getViolationRules() {
        return this.violationRules;
    }

    @OutputFile
    protected File getDummyOutputFile() {
        return new File(this.getTemporaryDir(), "success.txt");
    }

    public JacocoViolationRulesContainer violationRules(Action<? super JacocoViolationRulesContainer> configureAction) {
        configureAction.execute((Object)this.violationRules);
        return this.violationRules;
    }

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public void check() throws IOException {
        WorkQueue queue = this.getWorkerExecutor().classLoaderIsolation();
        queue.submit(JacocoCoverageAction.class, parameters -> {
            parameters.getAntLibraryClasspath().convention((Iterable)this.getJacocoClasspath());
            parameters.getProjectName().convention((Object)this.projectName);
            parameters.getEncoding().convention(this.getSourceEncoding());
            parameters.getAllSourcesDirs().convention((Iterable)this.getAllSourceDirs());
            parameters.getAllClassesDirs().convention((Iterable)this.getAllClassDirs());
            parameters.getExecutionData().convention((Iterable)this.getExecutionData());
            parameters.getFailOnViolation().convention((Object)this.getViolationRules().isFailOnViolation());
            parameters.getRules().convention(this.getViolationRules().getRules());
            parameters.getDummyOutputFile().fileValue(this.getDummyOutputFile());
        });
    }
}

