/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.gradle.internal.collect.PersistentList;

class DynamicGraphCycleDetector<T> {
    private final Map<T, Set<T>> graph = new HashMap<T, Set<T>>();
    private final Set<T> acyclicNodes = new LinkedHashSet<T>();

    DynamicGraphCycleDetector() {
    }

    public void addAcyclicNode(T node) {
        this.acyclicNodes.add(node);
    }

    public void addEdge(T from, T to) {
        this.referrersOf(to).add(from);
    }

    public Optional<Cycle<T>> findFirstInvalidCycle() {
        for (T node : this.acyclicNodes) {
            Optional<Cycle<T>> cycle = this.findCycle(node, node);
            if (!cycle.isPresent()) continue;
            return cycle;
        }
        return Optional.empty();
    }

    private Optional<Cycle<T>> findCycle(T from, T to) {
        return this.findCycle(from, to, PersistentList.of(from));
    }

    private Optional<Cycle<T>> findCycle(T from, T to, PersistentList<T> path) {
        Set<T> referrers = this.graph.get(from);
        if (referrers == null) {
            return Optional.empty();
        }
        if (referrers.contains(to)) {
            return Optional.of(new Cycle(path.plus(to)));
        }
        for (T referrer : referrers) {
            Optional<Cycle<T>> cycle;
            if (Iterables.contains(path, referrer) || !(cycle = this.findCycle(referrer, to, path.plus(referrer))).isPresent()) continue;
            return cycle;
        }
        return Optional.empty();
    }

    private Set<T> referrersOf(T from) {
        return this.graph.computeIfAbsent(from, k -> new LinkedHashSet());
    }

    public static class Cycle<T> {
        private final PersistentList<T> path;

        public Cycle(PersistentList<T> path) {
            this.path = path;
        }

        public String format(Function<T, String> toString) {
            StringBuilder builder = new StringBuilder();
            for (Object segment : this.path) {
                if (builder.length() > 0) {
                    builder.append(" -> ");
                }
                builder.append(toString.apply(segment));
            }
            return builder.toString();
        }

        public Cycle<T> plus(T from) {
            return new Cycle<T>(this.path.plus(from));
        }
    }
}

