import type { ReadableStreamBYOBReader } from 'node:stream/web';
import { AbstractStreamReader } from "./AbstractStreamReader.js";
/**
 * Read from a WebStream using a BYOB reader
 * Reference: https://nodejs.org/api/webstreams.html#class-readablestreambyobreader
 */
export declare class WebStreamByobReader extends AbstractStreamReader {
    private reader;
    constructor(reader: ReadableStreamBYOBReader);
    protected readFromStream(buffer: Uint8Array, offset: number, length: number): Promise<number>;
    abort(): Promise<void>;
    close(): Promise<void>;
}
