/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.time.Instant;
import java.util.Optional;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.state.WindowStoreIterator;

@InterfaceStability.Evolving
public class WindowKeyQuery<K, V>
implements Query<WindowStoreIterator<V>> {
    private final K key;
    private final Optional<Instant> timeFrom;
    private final Optional<Instant> timeTo;

    private WindowKeyQuery(K key, Optional<Instant> timeTo, Optional<Instant> timeFrom) {
        this.key = key;
        this.timeFrom = timeFrom;
        this.timeTo = timeTo;
    }

    public static <K, V> WindowKeyQuery<K, V> withKeyAndWindowStartRange(K key, Instant timeFrom, Instant timeTo) {
        return new WindowKeyQuery<K, V>(key, Optional.of(timeFrom), Optional.of(timeTo));
    }

    public K getKey() {
        return this.key;
    }

    public Optional<Instant> getTimeFrom() {
        return this.timeFrom;
    }

    public Optional<Instant> getTimeTo() {
        return this.timeTo;
    }

    public String toString() {
        return "WindowKeyQuery{key=" + String.valueOf(this.key) + ", timeFrom=" + String.valueOf(this.timeFrom) + ", timeTo=" + String.valueOf(this.timeTo) + "}";
    }
}

