/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.sqlserver;

import java.util.function.Consumer;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionRule;
import schemacrawler.server.sqlserver.SqlServerConnectionInitializer;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.datasource.DatabaseConnectionSourceBuilder;
import us.fatehi.utility.datasource.DatabaseServerType;

public final class SqlServerDatabaseConnector
extends DatabaseConnector {
    public SqlServerDatabaseConnector() {
        super(new DatabaseServerType("sqlserver", "Microsoft SQL Server"), url -> url != null && url.startsWith("jdbc:sqlserver:"), (informationSchemaViewsBuilder, connection) -> informationSchemaViewsBuilder.fromResourceFolder("/sqlserver.information_schema"), (schemaRetrievalOptionsBuilder, connection) -> {}, limitOptionsBuilder -> limitOptionsBuilder.includeSchemas((InclusionRule)new RegularExpressionRule(".*\\.dbo", "model\\..*|master\\..*|msdb\\..*|tempdb\\..*|rdsadmin\\..*")), () -> DatabaseConnectionSourceBuilder.builder((String)"jdbc:sqlserver://${host}:${port};databaseName=${database}").withDefaultPort(1433).withDefaultUrlx("applicationName", "SchemaCrawler").withDefaultUrlx("encrypt", false).withConnectionInitializer((Consumer)new SqlServerConnectionInitializer()));
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = super.getHelpCommand();
        pluginCommand.addOption("server", String.class, new String[]{"--server=mysql", "Loads SchemaCrawler plug-in for Microsoft SQL Server", "If you are using instance names, named pipes, or Windows authentication, you will need to provide a database connection URL on the SchemaCrawler command-line", "See https://www.schemacrawler.com/database-support.html"}).addOption("host", String.class, new String[]{"Host name", "Optional, defaults to localhost"}).addOption("port", Integer.class, new String[]{"Port number", "Optional, defaults to 1433"}).addOption("database", String.class, new String[]{"Database name", "Be sure to also restrict your schemas to this database, by using an additional option,", "--schemas=<database>.dbo"});
        return pluginCommand;
    }
}

