/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.AbstractGenerator;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.StreamContext;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;

public class JsonSerializerImpl
extends AbstractGenerator {
    private static final byte[] CHAR_TYPES;
    private static final byte CHAR_OTHER = 0;
    private static final byte CHAR_CONTROL = 1;
    private static final byte CHAR_LF = 2;
    private static final byte CHAR_QUOTATION = 3;
    private static final byte CHAR_REVERSE_SOLIDUS = 4;
    private static final byte CHAR_SURROGATE = 5;
    private static final byte CHAR_BACKSPACE = 6;
    private static final byte CHAR_FORMFEED = 7;
    private static final byte CHAR_CR = 8;
    private static final byte CHAR_TAB = 9;
    private static final byte CHAR_ASCII = 10;
    private static final int ASCII_MAX = 127;
    private JsonOutput writer;
    private StreamContext ctx;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;

    public JsonSerializerImpl(OutputStream out) {
        this.writer = new UTF8JsonOutput(out);
        this.ctx = new StreamContext(this.getExceptionFactory());
    }

    public JsonSerializerImpl(Writer writer) {
        this.writer = new WriterJsonOutput(writer);
        this.ctx = new StreamContext(this.getExceptionFactory());
    }

    @Override
    public OracleJsonGenerator writeStartObject() {
        this.writeSeparator();
        this.ctx.startObject();
        this.writeAscii('{');
        return this;
    }

    @Override
    public OracleJsonGenerator writeStartArray() {
        this.writeSeparator();
        this.ctx.startArray();
        this.writeAscii('[');
        return this;
    }

    @Override
    public OracleJsonGenerator writeEnd() {
        if (this.ctx.inObject()) {
            this.ctx.end();
            this.writeAscii('}');
        } else {
            this.ctx.end();
            this.writeAscii(']');
        }
        return this;
    }

    @Override
    public OracleJsonGenerator write(String value) {
        this.primitive();
        JsonSerializerImpl.writeQuotedString(value, this.writer, this.getExceptionFactory());
        return this;
    }

    @Override
    public OracleJsonGenerator writeKey(String key) {
        this.writeSeparator();
        this.ctx.pendingKey();
        JsonSerializerImpl.writeQuotedString(key, this.writer, this.getExceptionFactory());
        this.writeAscii(':');
        return this;
    }

    private static void writeQuotedString(String value, JsonOutput writer, OracleJsonExceptions.ExceptionFactory f2) {
        try {
            writer.writeAscii((byte)34);
            JsonSerializerImpl.writeEscaped(value, writer);
            writer.writeAscii((byte)34);
        }
        catch (IOException e2) {
            throw OracleJsonExceptions.IO.create(f2, e2, new Object[0]);
        }
    }

    public static String serializeString(String value) {
        StringWriter w2 = new StringWriter();
        WriterJsonOutput o2 = new WriterJsonOutput(w2);
        JsonSerializerImpl.writeQuotedString(value, o2, null);
        try {
            o2.close();
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
        return w2.toString();
    }

    @Override
    public OracleJsonGenerator write(BigDecimal value) {
        this.primitive();
        this.writeBigDecimal(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigInteger value) {
        this.primitive();
        this.writeBigInteger(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(int value) {
        this.primitive();
        this.writeInt(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(long value) {
        this.primitive();
        this.writeLong(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(double value) {
        this.assertFinite(value);
        this.primitive();
        this.writeDouble(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(float value) {
        this.assertFinite(value);
        this.primitive();
        this.writeFloat(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(boolean value) {
        this.primitive();
        this.writeBoolean(value);
        return this;
    }

    @Override
    public OracleJsonGenerator writeNull() {
        this.primitive();
        this.writeNullInternal();
        return this;
    }

    @Override
    public void close() {
        this.ctx.close();
        try {
            this.writer.close();
        }
        catch (IOException e2) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e2, new Object[0]);
        }
    }

    protected OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e2) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e2, new Object[0]);
        }
    }

    @Override
    protected OracleJsonGenerator writeBinary(OracleJsonBinary value) {
        return this.write(((OracleJsonBinaryImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeDouble(OracleJsonDouble value) {
        return this.writeNumber(value);
    }

    @Override
    protected OracleJsonGenerator writeFloat(OracleJsonFloat value) {
        return this.writeNumber(value);
    }

    @Override
    protected OracleJsonGenerator writeOraNumber(OracleJsonDecimal value) {
        return this.writeNumber(value);
    }

    private OracleJsonGenerator writeNumber(OracleJsonNumber value) {
        this.primitive();
        try {
            this.writer.writeAscii(this.numberToString(value));
        }
        catch (IOException e2) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e2, new Object[0]);
        }
        return this;
    }

    private String numberToString(OracleJsonNumber n2) {
        if (n2 instanceof OracleJsonNumberImpl) {
            return ((OracleJsonNumberImpl)((Object)n2)).getString();
        }
        return n2.toString();
    }

    @Override
    protected OracleJsonGenerator writeTimestamp(OracleJsonTimestamp value) {
        return this.write(((OracleJsonTimestampImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeTimestampTZ(OracleJsonTimestampTZ value) {
        return this.write(((OracleJsonTimestampTZImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeDate(OracleJsonDate value) {
        return this.write(((OracleJsonDateImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeIntervalDS(OracleJsonIntervalDS value) {
        return this.write(((OracleJsonIntervalDSImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeIntervalYM(OracleJsonIntervalYM value) {
        return this.write(((OracleJsonIntervalYMImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeString(OracleJsonString value) {
        return this.write(value.getString());
    }

    private void writeAscii(CharSequence s2) {
        try {
            this.writer.writeAscii(s2);
        }
        catch (IOException e2) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e2, new Object[0]);
        }
    }

    private void writeBigDecimal(BigDecimal value) {
        this.writeAscii(value.toString());
    }

    private void writeBigInteger(BigInteger value) {
        this.writeAscii(new BigDecimal(value).toString());
    }

    private void writeInt(int value) {
        this.writeAscii(new BigDecimal(value).toString());
    }

    private void writeLong(long value) {
        this.writeAscii(new BigDecimal(value).toString());
    }

    private void writeFloat(float value) {
        this.writeAscii(Float.toString(value));
    }

    private void writeDouble(double value) {
        this.writeAscii(Double.toString(value));
    }

    private void writeBoolean(boolean value) {
        this.writeAscii(String.valueOf(value));
    }

    private void writeNullInternal() {
        this.writeAscii("null");
    }

    private void writeAscii(char c2) {
        try {
            this.writer.writeAscii((byte)c2);
        }
        catch (IOException e2) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e2, new Object[0]);
        }
    }

    private void primitive() {
        this.writeSeparator();
        this.ctx.primitive();
    }

    private void writeSeparator() {
        if (this.ctx.hasChildren() && !this.ctx.pendingKey) {
            this.writeAscii(',');
        }
    }

    private static void writeEscaped(String value, JsonOutput writer) throws IOException {
        int length = value.length();
        block13: for (int i2 = 0; i2 < length; ++i2) {
            char c2 = value.charAt(i2);
            switch (CHAR_TYPES[c2]) {
                case 10: {
                    writer.writeAscii((byte)c2);
                    continue block13;
                }
                case 0: {
                    writer.write(c2);
                    continue block13;
                }
                case 2: {
                    writer.writeAscii("\\n");
                    continue block13;
                }
                case 6: {
                    writer.writeAscii("\\b");
                    continue block13;
                }
                case 7: {
                    writer.writeAscii("\\f");
                    continue block13;
                }
                case 8: {
                    writer.writeAscii("\\r");
                    continue block13;
                }
                case 9: {
                    writer.writeAscii("\\t");
                    continue block13;
                }
                case 3: {
                    writer.writeAscii("\\\"");
                    continue block13;
                }
                case 4: {
                    writer.writeAscii("\\\\");
                    continue block13;
                }
                case 1: {
                    JsonSerializerImpl.escape(c2, writer);
                    continue block13;
                }
                case 5: {
                    writer.writeSurrogates(value.charAt(i2), value.charAt(i2 + 1));
                    ++i2;
                }
            }
        }
    }

    private void assertFinite(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException(Double.toString(value));
        }
    }

    private static void escape(int cp, JsonOutput writer) throws IOException {
        for (char c2 : Character.toChars(cp)) {
            String hex = Integer.toHexString(c2).toUpperCase();
            writer.writeAscii("\\u");
            for (int i2 = 0; i2 < 4 - hex.length(); ++i2) {
                writer.writeAscii((byte)48);
            }
            writer.writeAscii(hex);
        }
    }

    @Override
    public OracleJsonGenerator write(LocalDateTime local) {
        byte[] bytes = OsonPrimitiveConversions.toOracleTimestamp(this.getExceptionFactory(), local);
        this.write(OsonPrimitiveConversions.timestampToString(this.getExceptionFactory(), bytes));
        return this;
    }

    @Override
    public OracleJsonGenerator write(OffsetDateTime off) {
        byte[] bytes = OsonPrimitiveConversions.toOracleTimestampTZ(this.getExceptionFactory(), off);
        this.write(OsonPrimitiveConversions.timestampTZToString(this.getExceptionFactory(), bytes));
        return this;
    }

    @Override
    public OracleJsonGenerator write(String key, LocalDateTime value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String key, OffsetDateTime value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String key, byte[] value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(byte[] value) {
        return this.write(OracleJsonBinaryImpl.getString(value, false));
    }

    @Override
    public OracleJsonGenerator writeId(byte[] value) {
        return this.write(OracleJsonBinaryImpl.getString(value, true));
    }

    @Override
    public OracleJsonGenerator write(Period value) {
        return this.write(OracleJsonIntervalYMImpl.serializePeriod(value, this.getExceptionFactory()));
    }

    @Override
    public OracleJsonGenerator write(Duration value) {
        return this.write(OracleJsonIntervalDSImpl.serializeDuration(value, this.getExceptionFactory()));
    }

    @Override
    protected void writeStringFromParser(OracleJsonParser parser) {
        if (!this.writer.utf8() || !(parser instanceof OsonParserImpl)) {
            this.write(parser.getString());
            return;
        }
        this.primitive();
        OsonParserImpl oparser = (OsonParserImpl)parser;
        byte[] arr = oparser.getContext().b.buffer.array();
        this.writeQuotedUTF8String(arr, oparser.getCurrentStringPos(), oparser.getCurrentStringLen());
    }

    private void writeQuotedUTF8String(byte[] array, int offset, int len) {
        try {
            this.writeAscii('\"');
            int end = offset + len;
            block13: for (int i2 = offset; i2 < end; ++i2) {
                byte b2 = array[i2];
                switch (CHAR_TYPES[b2 & 0xFF]) {
                    case 10: {
                        this.writer.writeAscii(b2);
                        continue block13;
                    }
                    case 2: {
                        this.writer.writeAscii("\\n");
                        continue block13;
                    }
                    case 6: {
                        this.writer.writeAscii("\\b");
                        continue block13;
                    }
                    case 7: {
                        this.writer.writeAscii("\\f");
                        continue block13;
                    }
                    case 8: {
                        this.writer.writeAscii("\\r");
                        continue block13;
                    }
                    case 9: {
                        this.writer.writeAscii("\\t");
                        continue block13;
                    }
                    case 3: {
                        this.writer.writeAscii("\\\"");
                        continue block13;
                    }
                    case 4: {
                        this.writer.writeAscii("\\\\");
                        continue block13;
                    }
                    case 1: {
                        JsonSerializerImpl.escape(b2, this.writer);
                        continue block13;
                    }
                    default: {
                        if ((b2 & 0xE0) == 192) {
                            this.writer.utf8(array, i2, 2);
                            ++i2;
                            continue block13;
                        }
                        if ((b2 & 0xF0) == 224) {
                            this.writer.utf8(array, i2, 3);
                            i2 += 2;
                            continue block13;
                        }
                        this.writer.utf8(array, i2, 4);
                        i2 += 3;
                    }
                }
            }
            this.writeAscii('\"');
        }
        catch (IOException e2) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e2, new Object[0]);
        }
    }

    @Override
    protected void writeDecimalFromParser(OracleJsonParser parser) {
        this.primitive();
        try {
            this.writer.writeAscii(parser.getString());
        }
        catch (IOException e2) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e2, new Object[0]);
        }
    }

    static {
        int i2;
        try {
            $$$methodRef$$$58 = JsonSerializerImpl.class.getDeclaredConstructor(Writer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = JsonSerializerImpl.class.getDeclaredConstructor(OutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = JsonSerializerImpl.class.getDeclaredMethod("writeDecimalFromParser", OracleJsonParser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = JsonSerializerImpl.class.getDeclaredMethod("writeQuotedUTF8String", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = JsonSerializerImpl.class.getDeclaredMethod("writeStringFromParser", OracleJsonParser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = JsonSerializerImpl.class.getDeclaredMethod("write", Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = JsonSerializerImpl.class.getDeclaredMethod("write", Period.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = JsonSerializerImpl.class.getDeclaredMethod("writeId", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = JsonSerializerImpl.class.getDeclaredMethod("write", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = JsonSerializerImpl.class.getDeclaredMethod("write", String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = JsonSerializerImpl.class.getDeclaredMethod("write", String.class, OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = JsonSerializerImpl.class.getDeclaredMethod("write", String.class, LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = JsonSerializerImpl.class.getDeclaredMethod("write", OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = JsonSerializerImpl.class.getDeclaredMethod("write", LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = JsonSerializerImpl.class.getDeclaredMethod("escape", Integer.TYPE, JsonOutput.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = JsonSerializerImpl.class.getDeclaredMethod("assertFinite", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = JsonSerializerImpl.class.getDeclaredMethod("writeEscaped", String.class, JsonOutput.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = JsonSerializerImpl.class.getDeclaredMethod("writeSeparator", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = JsonSerializerImpl.class.getDeclaredMethod("primitive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = JsonSerializerImpl.class.getDeclaredMethod("writeAscii", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = JsonSerializerImpl.class.getDeclaredMethod("writeNullInternal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = JsonSerializerImpl.class.getDeclaredMethod("writeBoolean", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = JsonSerializerImpl.class.getDeclaredMethod("writeDouble", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = JsonSerializerImpl.class.getDeclaredMethod("writeFloat", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = JsonSerializerImpl.class.getDeclaredMethod("writeLong", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = JsonSerializerImpl.class.getDeclaredMethod("writeInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = JsonSerializerImpl.class.getDeclaredMethod("writeBigInteger", BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = JsonSerializerImpl.class.getDeclaredMethod("writeBigDecimal", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = JsonSerializerImpl.class.getDeclaredMethod("writeAscii", CharSequence.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = JsonSerializerImpl.class.getDeclaredMethod("writeString", OracleJsonString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = JsonSerializerImpl.class.getDeclaredMethod("writeIntervalYM", OracleJsonIntervalYM.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = JsonSerializerImpl.class.getDeclaredMethod("writeIntervalDS", OracleJsonIntervalDS.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = JsonSerializerImpl.class.getDeclaredMethod("writeDate", OracleJsonDate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = JsonSerializerImpl.class.getDeclaredMethod("writeTimestampTZ", OracleJsonTimestampTZ.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = JsonSerializerImpl.class.getDeclaredMethod("writeTimestamp", OracleJsonTimestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = JsonSerializerImpl.class.getDeclaredMethod("numberToString", OracleJsonNumber.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = JsonSerializerImpl.class.getDeclaredMethod("writeNumber", OracleJsonNumber.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = JsonSerializerImpl.class.getDeclaredMethod("writeOraNumber", OracleJsonDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = JsonSerializerImpl.class.getDeclaredMethod("writeFloat", OracleJsonFloat.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = JsonSerializerImpl.class.getDeclaredMethod("writeDouble", OracleJsonDouble.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = JsonSerializerImpl.class.getDeclaredMethod("writeBinary", OracleJsonBinary.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = JsonSerializerImpl.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = JsonSerializerImpl.class.getDeclaredMethod("getExceptionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = JsonSerializerImpl.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = JsonSerializerImpl.class.getDeclaredMethod("writeNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = JsonSerializerImpl.class.getDeclaredMethod("write", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = JsonSerializerImpl.class.getDeclaredMethod("write", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JsonSerializerImpl.class.getDeclaredMethod("write", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JsonSerializerImpl.class.getDeclaredMethod("write", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonSerializerImpl.class.getDeclaredMethod("write", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonSerializerImpl.class.getDeclaredMethod("write", BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonSerializerImpl.class.getDeclaredMethod("write", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonSerializerImpl.class.getDeclaredMethod("serializeString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonSerializerImpl.class.getDeclaredMethod("writeQuotedString", String.class, JsonOutput.class, OracleJsonExceptions.ExceptionFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonSerializerImpl.class.getDeclaredMethod("writeKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonSerializerImpl.class.getDeclaredMethod("write", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonSerializerImpl.class.getDeclaredMethod("writeEnd", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonSerializerImpl.class.getDeclaredMethod("writeStartArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonSerializerImpl.class.getDeclaredMethod("writeStartObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        CHAR_TYPES = new byte[65536];
        for (i2 = 0; i2 <= 127; ++i2) {
            JsonSerializerImpl.CHAR_TYPES[i2] = 10;
        }
        for (i2 = 0; i2 <= 31; i2 = (int)((char)(i2 + 1))) {
            JsonSerializerImpl.CHAR_TYPES[i2] = 1;
        }
        JsonSerializerImpl.CHAR_TYPES[127] = 1;
        JsonSerializerImpl.CHAR_TYPES[10] = 2;
        JsonSerializerImpl.CHAR_TYPES[92] = 4;
        JsonSerializerImpl.CHAR_TYPES[34] = 3;
        JsonSerializerImpl.CHAR_TYPES[8] = 6;
        JsonSerializerImpl.CHAR_TYPES[12] = 7;
        JsonSerializerImpl.CHAR_TYPES[13] = 8;
        JsonSerializerImpl.CHAR_TYPES[9] = 9;
        for (int c2 = 55296; c2 <= 56319; c2 = (int)((char)(c2 + 1))) {
            JsonSerializerImpl.CHAR_TYPES[c2] = 5;
        }
    }

    private static class UTF8JsonOutput
    implements JsonOutput {
        byte[] buffer = new byte[1024];
        OutputStream out;
        int pos = 0;
        CharsetEncoder encoder;
        CharBuffer cbuffer;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;

        public UTF8JsonOutput(OutputStream out) {
            this.out = out;
        }

        private void initEncoder() {
            if (this.encoder == null) {
                this.encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.cbuffer = CharBuffer.allocate(2);
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.out.close();
            this.buffer = null;
        }

        @Override
        public void writeAscii(CharSequence value) throws IOException {
            for (int i2 = 0; i2 < value.length(); ++i2) {
                if (this.pos >= this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.pos++] = (byte)value.charAt(i2);
            }
        }

        @Override
        public void writeAscii(byte value) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = value;
        }

        @Override
        public void flush() throws IOException {
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }

        @Override
        public void write(char c2) throws IOException {
            if (c2 <= '\u007f') {
                this.writeAscii((byte)c2);
            } else {
                this.flush();
                this.initEncoder();
                this.cbuffer.clear();
                this.cbuffer.append(c2);
                this.cbuffer.flip();
                this.encodeChars();
            }
        }

        @Override
        public void writeSurrogates(char c1, char c2) throws IOException {
            this.flush();
            this.initEncoder();
            this.cbuffer.clear();
            this.cbuffer.append(c1);
            this.cbuffer.append(c2);
            this.cbuffer.flip();
            this.encodeChars();
        }

        @Override
        public boolean utf8() {
            return true;
        }

        private void encodeChars() {
            ByteBuffer b2 = ByteBuffer.wrap(this.buffer);
            this.encoder.encode(this.cbuffer, b2, false);
            this.pos = b2.position();
        }

        @Override
        public void utf8(byte[] array, int offset, int len) throws IOException {
            this.flush();
            this.out.write(array, offset, len);
        }

        static {
            try {
                $$$methodRef$$$10 = UTF8JsonOutput.class.getDeclaredConstructor(OutputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = UTF8JsonOutput.class.getDeclaredMethod("utf8", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = UTF8JsonOutput.class.getDeclaredMethod("encodeChars", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = UTF8JsonOutput.class.getDeclaredMethod("utf8", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = UTF8JsonOutput.class.getDeclaredMethod("writeSurrogates", Character.TYPE, Character.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = UTF8JsonOutput.class.getDeclaredMethod("write", Character.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = UTF8JsonOutput.class.getDeclaredMethod("flush", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = UTF8JsonOutput.class.getDeclaredMethod("writeAscii", Byte.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = UTF8JsonOutput.class.getDeclaredMethod("writeAscii", CharSequence.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = UTF8JsonOutput.class.getDeclaredMethod("close", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = UTF8JsonOutput.class.getDeclaredMethod("initEncoder", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class WriterJsonOutput
    implements JsonOutput {
        char[] buffer = new char[1024];
        int pos = 0;
        Writer writer;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        WriterJsonOutput(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.writer.close();
            this.buffer = null;
        }

        @Override
        public void flush() throws IOException {
            this.writer.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }

        @Override
        public void writeAscii(CharSequence value) throws IOException {
            for (int i2 = 0; i2 < value.length(); ++i2) {
                if (this.pos >= this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.pos++] = value.charAt(i2);
            }
        }

        @Override
        public void writeAscii(byte value) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = (char)value;
        }

        @Override
        public void write(char c2) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = c2;
        }

        @Override
        public void writeSurrogates(char c1, char c2) throws IOException {
            this.write(c1);
            this.write(c2);
        }

        @Override
        public boolean utf8() {
            return false;
        }

        @Override
        public void utf8(byte[] array, int offset, int len) throws IOException {
            this.flush();
            this.writer.write(new String(array, offset, len, StandardCharsets.UTF_8));
        }

        static {
            try {
                $$$methodRef$$$8 = WriterJsonOutput.class.getDeclaredConstructor(Writer.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = WriterJsonOutput.class.getDeclaredMethod("utf8", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = WriterJsonOutput.class.getDeclaredMethod("utf8", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = WriterJsonOutput.class.getDeclaredMethod("writeSurrogates", Character.TYPE, Character.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WriterJsonOutput.class.getDeclaredMethod("write", Character.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WriterJsonOutput.class.getDeclaredMethod("writeAscii", Byte.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WriterJsonOutput.class.getDeclaredMethod("writeAscii", CharSequence.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WriterJsonOutput.class.getDeclaredMethod("flush", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WriterJsonOutput.class.getDeclaredMethod("close", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static interface JsonOutput
    extends Closeable {
        public void flush() throws IOException;

        public void write(char var1) throws IOException;

        public void writeAscii(CharSequence var1) throws IOException;

        public void writeAscii(byte var1) throws IOException;

        public void writeSurrogates(char var1, char var2) throws IOException;

        public boolean utf8();

        public void utf8(byte[] var1, int var2, int var3) throws IOException;
    }
}

