/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.PickleOutputStream;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public final class PickleContext {
    private PickleOutputStream outStream;
    byte[] image;
    int imageOffset;
    private byte[] byteBuffer;
    private int userCode;
    static short KOPI20_LN_ELNL;
    static short KOPI20_LN_5BLN;
    static short KOPI20_LN_ATMN;
    static short KOPI20_LN_IEMN;
    static short KOPI20_LN_MAXV;
    static short KOPI20_IF_IS81;
    static short KOPI20_IF_CMSB;
    static short KOPI20_IF_CLSB;
    static short KOPI20_IF_DEGN;
    static short KOPI20_IF_COLL;
    static short KOPI20_IF_NOPS;
    static short KOPI20_IF_ANY;
    static short KOPI20_IF_NONL;
    static short KOPI20_CF_CMSB;
    static short KOPI20_CF_CLSB;
    static short KOPI20_CF_INDX;
    static short KOPI20_CF_NOLN;
    static short KOPI20_VERSION;
    public static final byte KOPU_UPT_INDEX_TBL = 1;
    public static final byte KOPU_UPT_NEST_TBL = 2;
    public static final byte KOPU_UPT_VARRAY = 3;
    public static final byte KOPU_UPT_ASSOC_ARRAY = 4;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;

    public PickleContext() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, PickleContext.class, $$$methodRef$$$53, null, new Object[0]);
            }
            this.userCode = 0;
            this.byteBuffer = new byte[5];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, PickleContext.class, $$$methodRef$$$53, null);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, PickleContext.class, $$$methodRef$$$53, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, PickleContext.class, $$$methodRef$$$53, null, throwable2);
            }
            throw throwable;
        }
    }

    public PickleContext(byte[] pickled_bytes) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, PickleContext.class, $$$methodRef$$$54, null, new Object[]{pickled_bytes});
            }
            this.userCode = 0;
            this.byteBuffer = new byte[5];
            this.image = pickled_bytes;
            this.imageOffset = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, PickleContext.class, $$$methodRef$$$54, null);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, PickleContext.class, $$$methodRef$$$54, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, PickleContext.class, $$$methodRef$$$54, null, throwable2);
            }
            throw throwable;
        }
    }

    public PickleContext(byte[] pickled_bytes, long offset) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, PickleContext.class, $$$methodRef$$$55, null, pickled_bytes, offset);
            }
            this.userCode = 0;
            this.byteBuffer = new byte[5];
            this.image = pickled_bytes;
            this.imageOffset = (int)offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, PickleContext.class, $$$methodRef$$$55, null);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, PickleContext.class, $$$methodRef$$$55, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, PickleContext.class, $$$methodRef$$$55, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initStream(int n2) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void imglen;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, PickleContext.class, $$$methodRef$$$0, this, n2);
            }
            this.outStream = new PickleOutputStream((int)imglen);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, PickleContext.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, PickleContext.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, PickleContext.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public void initStream() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, PickleContext.class, $$$methodRef$$$1, this, new Object[0]);
            }
            this.outStream = new PickleOutputStream();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, PickleContext.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, PickleContext.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, PickleContext.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int lengthInBytes(int n2) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void v2;
            int n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, PickleContext.class, $$$methodRef$$$2, this, n2);
            }
            int n4 = n3 = v2 <= KOPI20_LN_MAXV ? 1 : 5;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, PickleContext.class, $$$methodRef$$$2, this, n3);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, PickleContext.class, $$$methodRef$$$2, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, PickleContext.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public int writeElementNull() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, PickleContext.class, $$$methodRef$$$3, this, new Object[0]);
            }
            this.outStream.write(KOPI20_LN_ELNL);
            int n2 = 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, PickleContext.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, PickleContext.class, $$$methodRef$$$3, this, null);
            }
            return 1;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, PickleContext.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public int writeAtomicNull() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, PickleContext.class, $$$methodRef$$$4, this, new Object[0]);
            }
            this.outStream.write(KOPI20_LN_ATMN);
            int n2 = 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, PickleContext.class, $$$methodRef$$$4, this, n2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, PickleContext.class, $$$methodRef$$$4, this, null);
            }
            return 1;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, PickleContext.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeImmediatelyEmbeddedElementNull(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void null_adtno;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, PickleContext.class, $$$methodRef$$$5, this, by);
            }
            this.byteBuffer[0] = (byte)KOPI20_LN_IEMN;
            this.byteBuffer[1] = null_adtno;
            this.outStream.write(this.byteBuffer, 0, 2);
            int n2 = 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, PickleContext.class, $$$methodRef$$$5, this, n2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, PickleContext.class, $$$methodRef$$$5, this, null);
            }
            return 2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, PickleContext.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeSB2(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, PickleContext.class, $$$methodRef$$$6, this, n2);
            }
            this.byteBuffer[0] = (byte)(len >> 8 & 0xFF);
            this.byteBuffer[1] = (byte)(len & 0xFF);
            this.outStream.write(this.byteBuffer, 0, 2);
            int n3 = 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, PickleContext.class, $$$methodRef$$$6, this, n3);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, PickleContext.class, $$$methodRef$$$6, this, null);
            }
            return 2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, PickleContext.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeUB4(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, PickleContext.class, $$$methodRef$$$7, this, n2);
            }
            this.byteBuffer[0] = (byte)(value >> 24 & 0xFF);
            this.byteBuffer[1] = (byte)(value >> 16 & 0xFF);
            this.byteBuffer[2] = (byte)(value >> 8 & 0xFF);
            this.byteBuffer[3] = (byte)(value & 0xFF);
            this.outStream.write(this.byteBuffer, 0, 4);
            int n3 = 4;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, PickleContext.class, $$$methodRef$$$7, this, n3);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, PickleContext.class, $$$methodRef$$$7, this, null);
            }
            return 4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, PickleContext.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public int writeLength(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, PickleContext.class, $$$methodRef$$$8, this, n2);
            }
            if (len <= KOPI20_LN_MAXV) {
                this.outStream.write((byte)len);
                int n3 = 1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, PickleContext.class, $$$methodRef$$$8, this, n3);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, PickleContext.class, $$$methodRef$$$8, this, null);
                }
                return 1;
            }
            this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
            this.byteBuffer[1] = (byte)(len >> 24);
            this.byteBuffer[2] = (byte)((len &= 0xFFFFFF) >> 16);
            this.byteBuffer[3] = (byte)((len &= 0xFFFF) >> 8);
            this.byteBuffer[4] = (byte)(len &= 0xFF);
            try {
                this.outStream.write(this.byteBuffer);
            }
            catch (IOException ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                if (bl) {
                    this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "OracleTypeADT.writeLength_pctx " + ex.toString() + sw.toString());
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, PickleContext.class, $$$methodRef$$$8, this, sQLException);
                }
                throw sQLException;
            }
            int n4 = 5;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, PickleContext.class, $$$methodRef$$$8, this, n4);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, PickleContext.class, $$$methodRef$$$8, this, null);
            }
            return 5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, PickleContext.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeLength(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            int datalen;
            void include;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, PickleContext.class, $$$methodRef$$$9, this, n2, bl);
            }
            if (include == false) {
                int n3 = this.writeLength(datalen);
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, PickleContext.class, $$$methodRef$$$9, this, n3);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, PickleContext.class, $$$methodRef$$$9, this, null);
                }
                return n3;
            }
            if (datalen <= KOPI20_LN_MAXV - 1) {
                this.outStream.write((byte)datalen + 1);
                int n4 = 1;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, PickleContext.class, $$$methodRef$$$9, this, n4);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, PickleContext.class, $$$methodRef$$$9, this, null);
                }
                return 1;
            }
            this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
            this.byteBuffer[1] = (byte)((datalen += 5) >> 24);
            this.byteBuffer[2] = (byte)((datalen &= 0xFFFFFF) >> 16);
            this.byteBuffer[3] = (byte)((datalen &= 0xFFFF) >> 8);
            this.byteBuffer[4] = (byte)(datalen &= 0xFF);
            try {
                this.outStream.write(this.byteBuffer);
            }
            catch (IOException ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                if (bl2) {
                    this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "OracleTypeADT.writeLength_pctx " + ex.toString() + sw.toString());
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, PickleContext.class, $$$methodRef$$$9, this, sQLException);
                }
                throw sQLException;
            }
            int n5 = 5;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, PickleContext.class, $$$methodRef$$$9, this, n5);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, PickleContext.class, $$$methodRef$$$9, this, null);
            }
            return 5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, PickleContext.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] to5bLengthBytes_pctx(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, PickleContext.class, $$$methodRef$$$10, this, n2);
            }
            this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
            this.byteBuffer[1] = (byte)(len >> 24);
            this.byteBuffer[2] = (byte)((len &= 0xFFFFFF) >> 16);
            this.byteBuffer[3] = (byte)((len &= 0xFFFF) >> 8);
            this.byteBuffer[4] = (byte)(len &= 0xFF);
            byte[] byArray = this.byteBuffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, PickleContext.class, $$$methodRef$$$10, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, PickleContext.class, $$$methodRef$$$10, this, null);
            }
            return this.byteBuffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, PickleContext.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeData(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, PickleContext.class, $$$methodRef$$$11, this, by);
            }
            this.outStream.write((int)b2);
            int n2 = 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, PickleContext.class, $$$methodRef$$$11, this, n2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, PickleContext.class, $$$methodRef$$$11, this, null);
            }
            return 1;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, PickleContext.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeData(byte[] byArray) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, PickleContext.class, $$$methodRef$$$12, this, new Object[]{byArray});
            }
            try {
                this.outStream.write((byte[])b2);
            }
            catch (IOException ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                if (bl) {
                    this.debug($$$loggerRef$$$12, Level.FINEST, $$$methodRef$$$12, "OracleTypeADT.write_data_pctx" + ex.toString() + sw.toString());
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, PickleContext.class, $$$methodRef$$$12, this, sQLException);
                }
                throw sQLException;
            }
            int n2 = ((void)b2).length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, PickleContext.class, $$$methodRef$$$12, this, n2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, PickleContext.class, $$$methodRef$$$12, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, PickleContext.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void patchImageLen(int n2, int n3) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void image_length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, PickleContext.class, $$$methodRef$$$13, this, n2, n3);
            }
            byte[] lenbuf = this.to5bLengthBytes_pctx((int)image_length);
            this.outStream.overwrite((int)offset, lenbuf, 0, lenbuf.length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, PickleContext.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, PickleContext.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, PickleContext.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeImageHeader(boolean bl) throws SQLException {
        boolean bl2 = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void withPrefix;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, PickleContext.class, $$$methodRef$$$14, this, bl);
            }
            int n2 = this.writeImageHeader(KOPI20_LN_MAXV + 1, (boolean)withPrefix);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, PickleContext.class, $$$methodRef$$$14, this, n2);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, PickleContext.class, $$$methodRef$$$14, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, PickleContext.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeOpaqueImageHeader(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void data_length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, PickleContext.class, $$$methodRef$$$15, this, n2);
            }
            int count = 2;
            this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS | KOPI20_IF_NONL);
            this.byteBuffer[1] = (byte)KOPI20_VERSION;
            this.outStream.write(this.byteBuffer, 0, 2);
            int n3 = count += this.writeLength((int)(data_length + 2), true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, PickleContext.class, $$$methodRef$$$15, this, n3);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, PickleContext.class, $$$methodRef$$$15, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, PickleContext.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeImageHeader(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void image_length;
            void withPrefix;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, PickleContext.class, $$$methodRef$$$16, this, n2, bl);
            }
            int count = 2;
            this.byteBuffer[0] = withPrefix != false ? (byte)KOPI20_IF_IS81 : (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS);
            this.byteBuffer[1] = (byte)KOPI20_VERSION;
            this.outStream.write(this.byteBuffer, 0, 2);
            int n3 = count += this.writeLength((int)image_length);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, PickleContext.class, $$$methodRef$$$16, this, n3);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, PickleContext.class, $$$methodRef$$$16, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, PickleContext.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeCollImageHeader(int n2, int n3) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void typeVersion;
            void num_collection_items;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, PickleContext.class, $$$methodRef$$$17, this, n2, n3);
            }
            int n4 = this.writeCollImageHeader(KOPI20_LN_MAXV + 1, (int)num_collection_items, (int)typeVersion);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, PickleContext.class, $$$methodRef$$$17, this, n4);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, PickleContext.class, $$$methodRef$$$17, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, PickleContext.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeCollImageHeader(int n2, int n3, int n4) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void num_collection_items;
            void typeVersion;
            void image_length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, PickleContext.class, $$$methodRef$$$18, this, n2, n3, n4);
            }
            int count = 5;
            this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL);
            this.byteBuffer[1] = (byte)KOPI20_VERSION;
            this.outStream.write(this.byteBuffer, 0, 2);
            count += this.writeLength((int)image_length);
            this.byteBuffer[0] = 1;
            this.byteBuffer[1] = 17;
            if (typeVersion > KOPI20_LN_MAXV) {
                this.byteBuffer[0] = (byte)(this.byteBuffer[0] + 5);
                count += 5;
                this.outStream.write(this.byteBuffer, 0, 2);
                this.writeLength((int)typeVersion);
            } else {
                this.byteBuffer[0] = (byte)(this.byteBuffer[0] + 2);
                count += 2;
                this.outStream.write(this.byteBuffer, 0, 2);
                this.writeSB2((int)typeVersion);
            }
            this.byteBuffer[0] = this.userCode == 1 ? (byte)KOPI20_CF_INDX : (byte)0;
            this.outStream.write(this.byteBuffer, 0, 1);
            int n5 = count += this.writeLength((int)num_collection_items);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, PickleContext.class, $$$methodRef$$$18, this, n5);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, PickleContext.class, $$$methodRef$$$18, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, PickleContext.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeCollImageHeader(byte[] byArray) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void prefix_segment;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, PickleContext.class, $$$methodRef$$$19, this, new Object[]{byArray});
            }
            int n2 = this.writeCollImageHeader(KOPI20_LN_MAXV + 1, (byte[])prefix_segment);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, PickleContext.class, $$$methodRef$$$19, this, n2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, PickleContext.class, $$$methodRef$$$19, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, PickleContext.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeCollImageHeader(int n2, byte[] byArray) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void image_length;
            void prefix_segment;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, PickleContext.class, $$$methodRef$$$20, this, n2, byArray);
            }
            int psegLen = ((void)prefix_segment).length;
            int count = 3 + psegLen;
            this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN);
            this.byteBuffer[1] = (byte)KOPI20_VERSION;
            this.outStream.write(this.byteBuffer, 0, 2);
            count += this.writeLength((int)image_length);
            this.byteBuffer[0] = 0;
            this.outStream.write(this.byteBuffer, 0, 1);
            this.outStream.write((byte[])prefix_segment, 0, psegLen);
            int n3 = count += this.writeLength(psegLen + 1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, PickleContext.class, $$$methodRef$$$20, this, n3);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, PickleContext.class, $$$methodRef$$$20, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, PickleContext.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] stream2Bytes() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, PickleContext.class, $$$methodRef$$$21, this, new Object[0]);
            }
            byte[] byArray = this.outStream.toByteArray();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, PickleContext.class, $$$methodRef$$$21, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, PickleContext.class, $$$methodRef$$$21, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, PickleContext.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte readByte() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte by;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, PickleContext.class, $$$methodRef$$$22, this, new Object[0]);
                }
                try {
                    byte by2 = this.image[this.imageOffset];
                    ++this.imageOffset;
                    by = by2;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    ++this.imageOffset;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, PickleContext.class, $$$methodRef$$$22, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, PickleContext.class, $$$methodRef$$$22, this, by);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, PickleContext.class, $$$methodRef$$$22, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, PickleContext.class, $$$methodRef$$$22, this, throwable3);
            }
            throw throwable;
        }
    }

    public boolean readAndCheckVersion() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, PickleContext.class, $$$methodRef$$$23, this, new Object[0]);
                }
                try {
                    boolean bl3 = (this.image[this.imageOffset] & 0xFF) <= KOPI20_VERSION;
                    ++this.imageOffset;
                    bl2 = bl3;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    ++this.imageOffset;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, PickleContext.class, $$$methodRef$$$23, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, PickleContext.class, $$$methodRef$$$23, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, PickleContext.class, $$$methodRef$$$23, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, PickleContext.class, $$$methodRef$$$23, this, throwable3);
            }
            throw throwable;
        }
    }

    public int readLength() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, PickleContext.class, $$$methodRef$$$24, this, new Object[0]);
            }
            if ((len = this.image[this.imageOffset] & 0xFF) > KOPI20_LN_MAXV) {
                if (len == KOPI20_LN_ELNL) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid null flag read").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, PickleContext.class, $$$methodRef$$$24, this, sQLException);
                    }
                    throw sQLException;
                }
                len = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
                this.imageOffset += 5;
            } else {
                ++this.imageOffset;
            }
            int n2 = len;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, PickleContext.class, $$$methodRef$$$24, this, n2);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, PickleContext.class, $$$methodRef$$$24, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, PickleContext.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    public void skipLength() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, PickleContext.class, $$$methodRef$$$25, this, new Object[0]);
            }
            this.imageOffset = (len = this.image[this.imageOffset] & 0xFF) > KOPI20_LN_MAXV ? (this.imageOffset += 5) : ++this.imageOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, PickleContext.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, PickleContext.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, PickleContext.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int readRestOfLength(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block9: {
                void len;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, PickleContext.class, $$$methodRef$$$26, this, by);
                }
                if ((len & 0xFF) != KOPI20_LN_5BLN) {
                    int n3 = len & 0xFF;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, PickleContext.class, $$$methodRef$$$26, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, PickleContext.class, $$$methodRef$$$26, this, null);
                    }
                    return n3;
                }
                try {
                    int n4 = (((this.image[this.imageOffset] & 0xFF) * 256 + (this.image[this.imageOffset + 1] & 0xFF)) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF);
                    this.imageOffset += 4;
                    n2 = n4;
                    if (!bl) break block9;
                }
                catch (Throwable throwable) {
                    this.imageOffset += 4;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, PickleContext.class, $$$methodRef$$$26, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, PickleContext.class, $$$methodRef$$$26, this, n2);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, PickleContext.class, $$$methodRef$$$26, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, PickleContext.class, $$$methodRef$$$26, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void skipRestOfLength(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, PickleContext.class, $$$methodRef$$$27, this, by);
            }
            if ((len & 0xFF) > KOPI20_LN_MAXV) {
                if ((len & 0xFF) == KOPI20_LN_5BLN) {
                    this.imageOffset += 4;
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid first length byte").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, PickleContext.class, $$$methodRef$$$27, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, PickleContext.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, PickleContext.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, PickleContext.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int readLength(boolean bl) throws SQLException {
        boolean bl2 = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void exclude;
            int len;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, PickleContext.class, $$$methodRef$$$28, this, bl);
            }
            if ((len = this.image[this.imageOffset] & 0xFF) > KOPI20_LN_MAXV) {
                len = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
                if (exclude != false) {
                    len -= 5;
                }
                this.imageOffset += 5;
            } else {
                if (exclude != false) {
                    --len;
                }
                ++this.imageOffset;
            }
            int n2 = len;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, PickleContext.class, $$$methodRef$$$28, this, n2);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, PickleContext.class, $$$methodRef$$$28, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, PickleContext.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] readPrefixSegment() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, PickleContext.class, $$$methodRef$$$29, this, new Object[0]);
            }
            byte[] b2 = new byte[this.readLength()];
            System.arraycopy(this.image, this.imageOffset, b2, 0, b2.length);
            this.imageOffset += b2.length;
            byte[] byArray = b2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, PickleContext.class, $$$methodRef$$$29, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, PickleContext.class, $$$methodRef$$$29, this, null);
            }
            return b2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, PickleContext.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] readDataValue() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, PickleContext.class, $$$methodRef$$$30, this, new Object[0]);
            }
            if ((len = this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
                ++this.imageOffset;
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, PickleContext.class, $$$methodRef$$$30, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, PickleContext.class, $$$methodRef$$$30, this, null);
                }
                return null;
            }
            if (len > KOPI20_LN_MAXV) {
                len = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
                this.imageOffset += 5;
            } else {
                ++this.imageOffset;
            }
            byte[] b2 = new byte[len];
            System.arraycopy(this.image, this.imageOffset, b2, 0, b2.length);
            this.imageOffset += b2.length;
            byte[] byArray = b2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, PickleContext.class, $$$methodRef$$$30, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, PickleContext.class, $$$methodRef$$$30, this, null);
            }
            return b2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, PickleContext.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readBytes(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, PickleContext.class, $$$methodRef$$$31, this, n2);
            }
            byte[] b2 = new byte[length];
            System.arraycopy(this.image, this.imageOffset, b2, 0, (int)length);
            this.imageOffset += length;
            byte[] byArray = b2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, PickleContext.class, $$$methodRef$$$31, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, PickleContext.class, $$$methodRef$$$31, this, null);
            }
            return b2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, PickleContext.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] read1ByteDataValue() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, PickleContext.class, $$$methodRef$$$32, this, new Object[0]);
            }
            if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, PickleContext.class, $$$methodRef$$$32, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, PickleContext.class, $$$methodRef$$$32, this, null);
                }
                return null;
            }
            byte[] b2 = new byte[this.image[this.imageOffset] & 0xFF];
            System.arraycopy(this.image, this.imageOffset + 1, b2, 0, b2.length);
            this.imageOffset += b2.length + 1;
            byte[] byArray = b2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, PickleContext.class, $$$methodRef$$$32, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, PickleContext.class, $$$methodRef$$$32, this, null);
            }
            return b2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, PickleContext.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readDataValue(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void byte1;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, PickleContext.class, $$$methodRef$$$33, this, by);
            }
            byte[] b2 = new byte[this.readRestOfLength((byte)byte1)];
            System.arraycopy(this.image, this.imageOffset, b2, 0, b2.length);
            this.imageOffset += b2.length;
            byte[] byArray = b2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, PickleContext.class, $$$methodRef$$$33, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, PickleContext.class, $$$methodRef$$$33, this, null);
            }
            return b2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, PickleContext.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readDataValue(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, PickleContext.class, $$$methodRef$$$34, this, n2);
            }
            byte[] b2 = new byte[len];
            System.arraycopy(this.image, this.imageOffset, b2, 0, (int)len);
            this.imageOffset += len;
            byte[] byArray = b2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, PickleContext.class, $$$methodRef$$$34, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, PickleContext.class, $$$methodRef$$$34, this, null);
            }
            return b2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, PickleContext.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    public long readUB4() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            long ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, PickleContext.class, $$$methodRef$$$35, this, new Object[0]);
            }
            long l2 = ret = (long)this.image[this.imageOffset++] << 24 & 0xFFFFFFFFFF000000L | (long)this.image[this.imageOffset++] << 16 & 0xFF0000L | (long)this.image[this.imageOffset++] << 8 & 0xFF00L | (long)this.image[this.imageOffset++] & 0xFFL;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, PickleContext.class, $$$methodRef$$$35, this, l2);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, PickleContext.class, $$$methodRef$$$35, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, PickleContext.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    public int readUB2() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            int ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, PickleContext.class, $$$methodRef$$$36, this, new Object[0]);
            }
            int n2 = ret = this.image[this.imageOffset++] << 8 & 0xFF00 | this.image[this.imageOffset++] & 0xFF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, PickleContext.class, $$$methodRef$$$36, this, n2);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, PickleContext.class, $$$methodRef$$$36, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, PickleContext.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    public void skipDataValue() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, PickleContext.class, $$$methodRef$$$37, this, new Object[0]);
            }
            if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
                ++this.imageOffset;
            } else {
                this.skipBytes(this.readLength());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, PickleContext.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, PickleContext.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, PickleContext.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void skipDataValue(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, PickleContext.class, $$$methodRef$$$38, this, by);
            }
            this.skipBytes(this.readRestOfLength((byte)b2));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, PickleContext.class, $$$methodRef$$$38, this);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, PickleContext.class, $$$methodRef$$$38, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, PickleContext.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void skipBytes(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, PickleContext.class, $$$methodRef$$$39, this, n2);
            }
            if (b2 > 0) {
                this.imageOffset += b2;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, PickleContext.class, $$$methodRef$$$39, this);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, PickleContext.class, $$$methodRef$$$39, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, PickleContext.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    public int offset() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, PickleContext.class, $$$methodRef$$$40, this, new Object[0]);
            }
            if (this.outStream != null) {
                int n2 = this.outStream.offset();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, PickleContext.class, $$$methodRef$$$40, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, PickleContext.class, $$$methodRef$$$40, this, null);
                }
                return n2;
            }
            int n3 = this.imageOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, PickleContext.class, $$$methodRef$$$40, this, n3);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, PickleContext.class, $$$methodRef$$$40, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, PickleContext.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    public int absoluteOffset() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, PickleContext.class, $$$methodRef$$$41, this, new Object[0]);
            }
            int n2 = this.imageOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, PickleContext.class, $$$methodRef$$$41, this, n2);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, PickleContext.class, $$$methodRef$$$41, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, PickleContext.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void skipTo(long l2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, PickleContext.class, $$$methodRef$$$42, this, l2);
            }
            if (offset > (long)this.imageOffset) {
                this.imageOffset = (int)offset;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, PickleContext.class, $$$methodRef$$$42, this);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, PickleContext.class, $$$methodRef$$$42, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, PickleContext.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] image() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, PickleContext.class, $$$methodRef$$$43, this, new Object[0]);
            }
            byte[] byArray = this.image;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, PickleContext.class, $$$methodRef$$$43, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, PickleContext.class, $$$methodRef$$$43, this, null);
            }
            return this.image;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, PickleContext.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean is81format(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte flag;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, PickleContext.class, $$$methodRef$$$44, null, by);
            }
            boolean bl3 = bl2 = (flag & 0xFF & KOPI20_IF_IS81) != 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, PickleContext.class, $$$methodRef$$$44, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, PickleContext.class, $$$methodRef$$$44, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, PickleContext.class, $$$methodRef$$$44, null, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isCollectionImage_pctx(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte flag;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, PickleContext.class, $$$methodRef$$$45, null, by);
            }
            boolean bl3 = bl2 = (flag & 0xFF & KOPI20_IF_COLL) != 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, PickleContext.class, $$$methodRef$$$45, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, PickleContext.class, $$$methodRef$$$45, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, PickleContext.class, $$$methodRef$$$45, null, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isDegenerateImage_pctx(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte flag;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, PickleContext.class, $$$methodRef$$$46, null, by);
            }
            boolean bl3 = bl2 = (flag & 0xFF & KOPI20_IF_DEGN) != 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, PickleContext.class, $$$methodRef$$$46, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, PickleContext.class, $$$methodRef$$$46, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, PickleContext.class, $$$methodRef$$$46, null, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean hasPrefix(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte flag;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, PickleContext.class, $$$methodRef$$$47, null, by);
            }
            boolean bl3 = bl2 = (flag & 0xFF & KOPI20_IF_NOPS) == 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, PickleContext.class, $$$methodRef$$$47, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, PickleContext.class, $$$methodRef$$$47, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, PickleContext.class, $$$methodRef$$$47, null, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isAtomicNull(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte flag;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, PickleContext.class, $$$methodRef$$$48, null, by);
            }
            boolean bl3 = bl2 = (flag & 0xFF) == KOPI20_LN_ATMN;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, PickleContext.class, $$$methodRef$$$48, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, PickleContext.class, $$$methodRef$$$48, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, PickleContext.class, $$$methodRef$$$48, null, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isImmediatelyEmbeddedNull(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte flag;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, PickleContext.class, $$$methodRef$$$49, null, by);
            }
            boolean bl3 = bl2 = (flag & 0xFF) == KOPI20_LN_IEMN;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, PickleContext.class, $$$methodRef$$$49, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, PickleContext.class, $$$methodRef$$$49, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, PickleContext.class, $$$methodRef$$$49, null, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isElementNull(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte flag;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, PickleContext.class, $$$methodRef$$$50, null, by);
            }
            boolean bl3 = bl2 = (flag & 0xFF) == KOPI20_LN_ELNL;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, PickleContext.class, $$$methodRef$$$50, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, PickleContext.class, $$$methodRef$$$50, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, PickleContext.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, PickleContext.class, $$$methodRef$$$51, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, PickleContext.class, $$$methodRef$$$51, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, PickleContext.class, $$$methodRef$$$51, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, PickleContext.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    /*
     * WARNING - void declaration
     */
    void setCollectionUserCode(int n2) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void userCode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, PickleContext.class, $$$methodRef$$$52, this, n2);
            }
            this.userCode = userCode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, PickleContext.class, $$$methodRef$$$52, this);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, PickleContext.class, $$$methodRef$$$52, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, PickleContext.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$55 = PickleContext.class.getDeclaredConstructor(byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = PickleContext.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = PickleContext.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = PickleContext.class.getDeclaredMethod("setCollectionUserCode", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = PickleContext.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = PickleContext.class.getDeclaredMethod("isElementNull", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = PickleContext.class.getDeclaredMethod("isImmediatelyEmbeddedNull", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = PickleContext.class.getDeclaredMethod("isAtomicNull", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = PickleContext.class.getDeclaredMethod("hasPrefix", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = PickleContext.class.getDeclaredMethod("isDegenerateImage_pctx", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = PickleContext.class.getDeclaredMethod("isCollectionImage_pctx", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = PickleContext.class.getDeclaredMethod("is81format", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = PickleContext.class.getDeclaredMethod("image", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = PickleContext.class.getDeclaredMethod("skipTo", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = PickleContext.class.getDeclaredMethod("absoluteOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = PickleContext.class.getDeclaredMethod("offset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = PickleContext.class.getDeclaredMethod("skipBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = PickleContext.class.getDeclaredMethod("skipDataValue", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = PickleContext.class.getDeclaredMethod("skipDataValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = PickleContext.class.getDeclaredMethod("readUB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = PickleContext.class.getDeclaredMethod("readUB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = PickleContext.class.getDeclaredMethod("readDataValue", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = PickleContext.class.getDeclaredMethod("readDataValue", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = PickleContext.class.getDeclaredMethod("read1ByteDataValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = PickleContext.class.getDeclaredMethod("readBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = PickleContext.class.getDeclaredMethod("readDataValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = PickleContext.class.getDeclaredMethod("readPrefixSegment", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = PickleContext.class.getDeclaredMethod("readLength", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = PickleContext.class.getDeclaredMethod("skipRestOfLength", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = PickleContext.class.getDeclaredMethod("readRestOfLength", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = PickleContext.class.getDeclaredMethod("skipLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = PickleContext.class.getDeclaredMethod("readLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = PickleContext.class.getDeclaredMethod("readAndCheckVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = PickleContext.class.getDeclaredMethod("readByte", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = PickleContext.class.getDeclaredMethod("stream2Bytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = PickleContext.class.getDeclaredMethod("writeCollImageHeader", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = PickleContext.class.getDeclaredMethod("writeCollImageHeader", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = PickleContext.class.getDeclaredMethod("writeCollImageHeader", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = PickleContext.class.getDeclaredMethod("writeCollImageHeader", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = PickleContext.class.getDeclaredMethod("writeImageHeader", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = PickleContext.class.getDeclaredMethod("writeOpaqueImageHeader", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = PickleContext.class.getDeclaredMethod("writeImageHeader", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = PickleContext.class.getDeclaredMethod("patchImageLen", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = PickleContext.class.getDeclaredMethod("writeData", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = PickleContext.class.getDeclaredMethod("writeData", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = PickleContext.class.getDeclaredMethod("to5bLengthBytes_pctx", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = PickleContext.class.getDeclaredMethod("writeLength", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = PickleContext.class.getDeclaredMethod("writeLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = PickleContext.class.getDeclaredMethod("writeUB4", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = PickleContext.class.getDeclaredMethod("writeSB2", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = PickleContext.class.getDeclaredMethod("writeImmediatelyEmbeddedElementNull", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = PickleContext.class.getDeclaredMethod("writeAtomicNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = PickleContext.class.getDeclaredMethod("writeElementNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = PickleContext.class.getDeclaredMethod("lengthInBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = PickleContext.class.getDeclaredMethod("initStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = PickleContext.class.getDeclaredMethod("initStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        KOPI20_LN_ELNL = (short)255;
        KOPI20_LN_5BLN = (short)254;
        KOPI20_LN_ATMN = (short)253;
        KOPI20_LN_IEMN = (short)252;
        KOPI20_LN_MAXV = (short)245;
        KOPI20_IF_IS81 = (short)128;
        KOPI20_IF_CMSB = (short)64;
        KOPI20_IF_CLSB = (short)32;
        KOPI20_IF_DEGN = (short)16;
        KOPI20_IF_COLL = (short)8;
        KOPI20_IF_NOPS = (short)4;
        KOPI20_IF_ANY = (short)2;
        KOPI20_IF_NONL = 1;
        KOPI20_CF_CMSB = (short)64;
        KOPI20_CF_CLSB = (short)32;
        KOPI20_CF_INDX = (short)16;
        KOPI20_CF_NOLN = (short)8;
        KOPI20_VERSION = 1;
    }
}

