/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.queue;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.queue.PSimpleQueue;
import com.oracle.graal.python.builtins.objects.queue.SimpleQueueBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.queue.SimpleQueueBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.queue.SimpleQueueBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSimpleQueue})
public final class SimpleQueueBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = SimpleQueueBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SimpleQueueBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Builtin(name="put_nowait", minNumOfPositionalArgs=2, parameterNames={"$self", "item"}, doc="put_nowait($self, /, item)\n--\n\nPut an item into the queue without blocking.\n\nThis is exactly equivalent to `put(item)` and is only provided\nfor compatibility with the Queue class.")
    @GenerateNodeFactory
    public static abstract class SimpleQueuePutNoWaitNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone doGeneric(PSimpleQueue self, Object item, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            if (!self.put(item)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="put", minNumOfPositionalArgs=2, parameterNames={"$self", "item", "block", "timeout"}, doc="put($self, /, item, block=True, timeout=None)\n--\n\nPut the item on the queue.\n\nThe optional 'block' and 'timeout' arguments are ignored, as this method\nnever blocks.  They are provided for compatibility with the Queue class.")
    @GenerateNodeFactory
    public static abstract class SimpleQueuePutNode
    extends PythonQuaternaryBuiltinNode {
        @Specialization
        static PNone doGeneric(PSimpleQueue self, Object item, Object block, Object timeout, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            if (!self.put(item)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="get", minNumOfPositionalArgs=1, parameterNames={"$self", "block", "timeout"}, doc="get($self, /, block=True, timeout=None)\n--\n\nRemove and return an item from the queue.\n\nIf optional args 'block' is true and 'timeout' is None (the default),\nblock if necessary until an item is available. If 'timeout' is\na non-negative number, it blocks at most 'timeout' seconds and raises\nthe Empty exception if no item was available within that time.\nOtherwise ('block' is false), return an item if one is immediately\navailable, else raise the Empty exception ('timeout' is ignored\nin that case).")
    @GenerateNodeFactory
    @ArgumentClinic(name="block", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")
    public static abstract class SimpleQueueGetNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SimpleQueueBuiltinsClinicProviders.SimpleQueueGetNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!withTimeout(block, timeout)"})
        static Object doNoTimeout(PSimpleQueue self, boolean block, Object timeout, @Bind Node inliningTarget, @Cached.Shared @Cached GilNode gil, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object result = self.poll();
            if (result != null) {
                return result;
            }
            if (block) {
                try {
                    gil.release(true);
                    Object object = self.get();
                    return object;
                }
                catch (InterruptedException e) {
                    CompilerDirectives.transferToInterpreter();
                    Thread.currentThread().interrupt();
                    PNone pNone = PNone.NONE;
                    return pNone;
                }
                finally {
                    gil.acquire();
                }
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.Empty);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"withTimeout(block, timeout)"})
        static Object doTimeout(VirtualFrame frame, PSimpleQueue self, boolean block, Object timeout, @Bind Node inliningTarget, @Cached PyLongAsLongAndOverflowNode asLongNode, @Cached CastToJavaDoubleNode castToDouble, @Cached.Shared @Cached GilNode gil, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            long ltimeout;
            assert (block);
            try {
                ltimeout = (long)(castToDouble.execute(inliningTarget, timeout) * 1000000.0);
            }
            catch (CannotCastException e) {
                try {
                    ltimeout = PythonUtils.multiplyExact(asLongNode.execute((Frame)frame, inliningTarget, timeout), 1000000L);
                }
                catch (OverflowException oe) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.TIMEOUT_VALUE_TOO_LARGE);
                }
            }
            if (ltimeout < 0L) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.TIMEOUT_MUST_BE_NON_NEG_NUM);
            }
            Object result = self.poll();
            if (result != null) {
                return result;
            }
            try {
                gil.release(true);
                result = self.get(ltimeout);
                if (result != null) {
                    Object oe = result;
                    return oe;
                }
            }
            catch (InterruptedException e) {
                CompilerDirectives.transferToInterpreter();
                Thread.currentThread().interrupt();
            }
            finally {
                gil.acquire();
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.Empty);
        }

        static boolean withTimeout(boolean block, Object timeout) {
            return block && !(timeout instanceof PNone);
        }
    }

    @Builtin(name="get_nowait", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, doc="get_nowait($self, /)\n--\n\nRemove and return an item from the queue without blocking.\n\nOnly get an item if one is immediately available. Otherwise\nraise the Empty exception.")
    @GenerateNodeFactory
    public static abstract class SimpleQueueGetNoWaitNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doNoTimeout(PSimpleQueue self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            Object result = self.poll();
            if (result != null) {
                return result;
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.Empty);
        }
    }

    @Builtin(name="qsize", minNumOfPositionalArgs=1, doc="qsize($self, /)\n--\n\nReturn the approximate size of the queue (not reliable!).")
    @GenerateNodeFactory
    public static abstract class SimpleQueueQSizeNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static int doGeneric(PSimpleQueue self) {
            return self.getQueueSize();
        }
    }

    @Builtin(name="empty", minNumOfPositionalArgs=1, doc="empty($self, /)\n--\n\nReturn True if the queue is empty, False otherwise (not reliable!).")
    @GenerateNodeFactory
    public static abstract class SimpleQueueEmptyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static boolean doGeneric(PSimpleQueue self) {
            return self.getQueueSize() == 0;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="SimpleQueue", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class SimpleQueueNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PSimpleQueue doGeneric(Object cls, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createSimpleQueue(language, cls, getInstanceShape.execute(cls));
        }
    }
}

