/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSetAttr;
import com.oracle.graal.python.lib.PyObjectSetAttrNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class PyObjectSetAttr
extends PNodeWithContext {
    public static void executeUncached(Object receiver, TruffleString name, Object value) {
        PyObjectSetAttr.getUncached().execute(null, null, receiver, name, value);
    }

    public final void executeCached(Frame frame, Object receiver, TruffleString name, Object value) {
        this.execute(frame, this, receiver, name, value);
    }

    public abstract void execute(Frame var1, Node var2, Object var3, TruffleString var4, Object var5);

    public final void execute(Node inliningTarget, Object receiver, TruffleString name, Object value) {
        this.execute(null, inliningTarget, receiver, name, value);
    }

    public final void deleteCached(Frame frame, Object receiver, TruffleString name) {
        this.execute(frame, null, receiver, name, PNone.NO_VALUE);
    }

    public static void deleteUncached(Object receiver, TruffleString name) {
        PyObjectSetAttr.executeUncached(receiver, name, PNone.NO_VALUE);
    }

    public final void delete(Frame frame, Node inliningTarget, Object receiver, TruffleString name) {
        this.execute(frame, inliningTarget, receiver, name, PNone.NO_VALUE);
    }

    @Specialization(guards={"name == cachedName", "value != null"}, limit="1")
    static void setFixedAttr(Frame frame, Node inliningTarget, Object self, TruffleString name, Object value, @Cached(value="name") TruffleString cachedName, @Cached.Shared @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached.Shared @Cached PRaiseNode raise, @Cached.Shared @Cached TpSlotSetAttr.CallSlotSetAttrNode callSetAttr) {
        assert (value != null);
        TpSlots slots = getSlotsNode.execute(inliningTarget, self);
        if (slots.combined_tp_setattro_setattr() != null) {
            callSetAttr.execute((VirtualFrame)frame, inliningTarget, slots, self, name, value);
        } else {
            PyObjectSetAttr.raiseNoSlotError(inliningTarget, self, name, value, raise, slots);
        }
    }

    @Specialization(replaces={"setFixedAttr"})
    @HostCompilerDirectives.InliningCutoff
    static void doDynamicAttr(Frame frame, Node inliningTarget, Object self, TruffleString name, Object value, @Cached.Shared @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached.Shared @Cached PRaiseNode raise, @Cached.Shared @Cached TpSlotSetAttr.CallSlotSetAttrNode callSetAttr) {
        PyObjectSetAttr.setFixedAttr(frame, inliningTarget, self, name, value, name, getSlotsNode, raise, callSetAttr);
    }

    @HostCompilerDirectives.InliningCutoff
    static void raiseNoSlotError(Node inliningTarget, Object self, Object name, Object value, PRaiseNode raise, TpSlots slots) {
        boolean isDelete;
        boolean bl = isDelete = value == PNone.NO_VALUE;
        TruffleString message = slots.combined_tp_getattro_getattr() == null ? (isDelete ? ErrorMessages.P_HAS_NO_ATTRS_S_TO_DELETE : ErrorMessages.P_HAS_NO_ATTRS_S_TO_ASSIGN) : (isDelete ? ErrorMessages.P_HAS_RO_ATTRS_S_TO_DELETE : ErrorMessages.P_HAS_RO_ATTRS_S_TO_ASSIGN);
        throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, message, self, name);
    }

    @NeverDefault
    public static PyObjectSetAttr create() {
        return PyObjectSetAttrNodeGen.create();
    }

    public static PyObjectSetAttr getUncached() {
        return PyObjectSetAttrNodeGen.getUncached();
    }
}

