/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.WrapForValidAsyncIteratorPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSAsyncIterator;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidAsyncIteratorObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSWrapForValidAsyncIterator
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSWrapForValidAsyncIterator INSTANCE = new JSWrapForValidAsyncIterator();

    private JSWrapForValidAsyncIterator() {
    }

    public static JSWrapForValidAsyncIteratorObject create(JSContext context, JSRealm realm, IteratorRecord iteratorRecord) {
        JSObjectFactory factory = context.getWrapForAsyncIteratorFactory();
        JSDynamicObject proto = factory.getPrototype(realm);
        Shape shape = factory.getShape(realm, proto);
        JSWrapForValidAsyncIteratorObject newObj = factory.initProto(new JSWrapForValidAsyncIteratorObject(shape, proto, iteratorRecord), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static boolean isWrapForAsyncIterator(Object obj) {
        return obj instanceof JSWrapForValidAsyncIteratorObject;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSDynamicObject iteratorPrototype = realm.getAsyncIteratorPrototype();
        JSObject wrapForIteratorPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer(realm, wrapForIteratorPrototype, WrapForValidAsyncIteratorPrototypeBuiltins.BUILTINS);
        return wrapForIteratorPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWrapForAsyncIteratorPrototype();
    }

    @Override
    public TruffleString getClassName() {
        return JSAsyncIterator.CLASS_NAME;
    }
}

