/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.ArrayBufferFunctionBuiltins;
import com.oracle.truffle.js.builtins.ArrayBufferPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSAbstractBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.util.DirectByteBufferHelper;
import java.nio.ByteBuffer;

public final class JSArrayBuffer
extends JSAbstractBuffer
implements JSConstructorFactory.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("ArrayBuffer");
    public static final TruffleString PROTOTYPE_NAME = Strings.concat(CLASS_NAME, Strings.DOT_PROTOTYPE);
    public static final JSArrayBuffer HEAP_INSTANCE = new JSArrayBuffer();
    public static final JSArrayBuffer DIRECT_INSTANCE = new JSArrayBuffer();
    public static final JSArrayBuffer INTEROP_INSTANCE = new JSArrayBuffer();
    public static final int FIXED_LENGTH = -1;

    private JSArrayBuffer() {
    }

    public static JSArrayBufferObject createArrayBuffer(JSContext context, JSRealm realm, int length) {
        return JSArrayBuffer.createArrayBuffer(context, realm, new byte[length]);
    }

    public static JSArrayBufferObject createArrayBuffer(JSContext context, JSRealm realm, byte[] byteArray) {
        return JSArrayBuffer.createArrayBuffer(context, realm, byteArray, byteArray.length, -1);
    }

    public static JSArrayBufferObject createArrayBuffer(JSContext context, JSRealm realm, byte[] byteArray, int byteLength, int maxByteLength) {
        JSObjectFactory factory = context.getArrayBufferFactory();
        return JSArrayBuffer.createHeapArrayBuffer(factory, realm, factory.getPrototype(realm), byteArray, byteLength, maxByteLength);
    }

    public static JSArrayBufferObject createArrayBuffer(JSContext context, JSRealm realm, JSDynamicObject proto, int byteLength, int maxByteLength) {
        JSObjectFactory factory = context.getArrayBufferFactory();
        return JSArrayBuffer.createHeapArrayBuffer(factory, realm, proto, new byte[Math.max(byteLength, maxByteLength)], byteLength, maxByteLength);
    }

    private static JSArrayBufferObject createHeapArrayBuffer(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto, byte[] byteArray, int byteLength, int maxByteLength) {
        Shape shape = factory.getShape(realm, proto);
        JSArrayBufferObject.Heap newObj = factory.initProto(new JSArrayBufferObject.Heap(shape, proto, byteArray, byteLength, maxByteLength), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static byte[] getByteArray(Object thisObj) {
        assert (JSArrayBuffer.isJSHeapArrayBuffer(thisObj));
        return JSArrayBufferObject.getByteArray(thisObj);
    }

    public static ByteBuffer getDirectByteBuffer(Object thisObj) {
        assert (JSArrayBuffer.isJSDirectArrayBuffer(thisObj) || JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
        return JSArrayBufferObject.getDirectByteBuffer(thisObj);
    }

    public static JSArrayBufferObject createDirectArrayBuffer(JSContext context, JSRealm realm, int length) {
        return JSArrayBuffer.createDirectArrayBuffer(context, realm, DirectByteBufferHelper.allocateDirect(length));
    }

    public static JSArrayBufferObject createDirectArrayBuffer(JSContext context, JSRealm realm, JSDynamicObject proto, int byteLength, int maxByteLength) {
        JSObjectFactory factory = context.getDirectArrayBufferFactory();
        return JSArrayBuffer.createDirectArrayBuffer(factory, realm, proto, DirectByteBufferHelper.allocateDirect(Math.max(byteLength, maxByteLength)), byteLength, maxByteLength);
    }

    public static JSArrayBufferObject createDirectArrayBuffer(JSContext context, JSRealm realm, ByteBuffer buffer) {
        JSObjectFactory factory = context.getDirectArrayBufferFactory();
        return JSArrayBuffer.createDirectArrayBuffer(factory, realm, factory.getPrototype(realm), buffer);
    }

    public static JSArrayBufferObject createDirectArrayBuffer(JSContext context, JSRealm realm, ByteBuffer buffer, int byteLength, int maxByteLength) {
        JSObjectFactory factory = context.getDirectArrayBufferFactory();
        return JSArrayBuffer.createDirectArrayBuffer(factory, realm, factory.getPrototype(realm), buffer, byteLength, maxByteLength);
    }

    private static JSArrayBufferObject createDirectArrayBuffer(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto, ByteBuffer buffer) {
        return JSArrayBuffer.createDirectArrayBuffer(factory, realm, proto, buffer, buffer.capacity(), -1);
    }

    private static JSArrayBufferObject createDirectArrayBuffer(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto, ByteBuffer buffer, int byteLength, int maxByteLength) {
        Shape shape = factory.getShape(realm, proto);
        JSArrayBufferObject.Direct newObj = factory.initProto(new JSArrayBufferObject.Direct(shape, proto, buffer, byteLength, maxByteLength), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static Object getInteropBuffer(Object thisObj) {
        assert (JSArrayBuffer.isJSInteropArrayBuffer(thisObj));
        return JSArrayBufferObject.getInteropBuffer(thisObj);
    }

    public static JSArrayBufferObject.Interop createInteropArrayBuffer(JSContext context, JSRealm realm, Object buffer) {
        JSObjectFactory factory = context.getInteropArrayBufferFactory();
        return JSArrayBuffer.createInteropArrayBuffer(factory, realm, factory.getPrototype(realm), buffer);
    }

    public static JSArrayBufferObject.Interop createInteropArrayBuffer(JSContext context, JSRealm realm, JSDynamicObject proto, Object buffer) {
        JSObjectFactory factory = context.getInteropArrayBufferFactory();
        return JSArrayBuffer.createInteropArrayBuffer(factory, realm, proto, buffer);
    }

    private static JSArrayBufferObject.Interop createInteropArrayBuffer(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto, Object buffer) {
        Shape shape = factory.getShape(realm, proto);
        JSArrayBufferObject.Interop newObj = factory.initProto(new JSArrayBufferObject.Interop(shape, proto, buffer), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject arrayBufferPrototype;
        JSContext context = realm.getContext();
        if (context.getEcmaScriptVersion() < 6) {
            Shape protoShape = JSShape.createPrototypeShape(context, HEAP_INSTANCE, realm.getObjectPrototype());
            arrayBufferPrototype = JSArrayBufferObject.createHeapArrayBuffer(protoShape, realm.getObjectPrototype(), new byte[0]);
            JSObjectUtil.setOrVerifyPrototype(context, arrayBufferPrototype, realm.getObjectPrototype());
        } else {
            arrayBufferPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        }
        JSObjectUtil.putConstructorProperty(arrayBufferPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, arrayBufferPrototype, ArrayBufferPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, arrayBufferPrototype, ArrayBufferPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(arrayBufferPrototype, CLASS_NAME);
        return arrayBufferPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        if (this == INTEROP_INSTANCE) {
            return JSObjectUtil.getProtoChildShape(prototype, INTEROP_INSTANCE, context);
        }
        if (this == HEAP_INSTANCE) {
            return JSObjectUtil.getProtoChildShape(prototype, HEAP_INSTANCE, context);
        }
        assert (this == DIRECT_INSTANCE);
        return JSObjectUtil.getProtoChildShape(prototype, DIRECT_INSTANCE, context);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return HEAP_INSTANCE.createConstructorAndPrototype(realm, ArrayBufferFunctionBuiltins.BUILTINS);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    public static boolean isJSHeapArrayBuffer(Object obj) {
        return obj instanceof JSArrayBufferObject.Heap;
    }

    public static boolean isJSDirectArrayBuffer(Object obj) {
        return obj instanceof JSArrayBufferObject.Direct;
    }

    public static boolean isJSInteropArrayBuffer(Object obj) {
        return obj instanceof JSArrayBufferObject.Interop;
    }

    public static boolean isJSDirectOrSharedArrayBuffer(Object obj) {
        return JSArrayBuffer.isJSDirectArrayBuffer(obj) || JSSharedArrayBuffer.isJSSharedArrayBuffer(obj);
    }

    public static boolean isDetachedBuffer(JSArrayBufferObject arrayBuffer) {
        if (JSArrayBuffer.isJSHeapArrayBuffer((Object)arrayBuffer)) {
            return JSArrayBuffer.getByteArray((Object)arrayBuffer) == null;
        }
        if (JSArrayBuffer.isJSDirectOrSharedArrayBuffer((Object)arrayBuffer)) {
            return JSArrayBuffer.getDirectByteBuffer((Object)arrayBuffer) == null;
        }
        assert (JSArrayBuffer.isJSInteropArrayBuffer((Object)arrayBuffer));
        return JSArrayBuffer.getInteropBuffer((Object)arrayBuffer) == null;
    }

    @CompilerDirectives.TruffleBoundary
    public static void detachArrayBuffer(JSArrayBufferObject arrayBuffer) {
        JSObject.getJSContext(arrayBuffer).getTypedArrayNotDetachedAssumption().invalidate("no detached array buffer");
        if (JSArrayBuffer.isJSDirectArrayBuffer((Object)arrayBuffer)) {
            ((JSArrayBufferObject.Direct)arrayBuffer).detachArrayBuffer();
        } else if (JSArrayBuffer.isJSInteropArrayBuffer((Object)arrayBuffer)) {
            ((JSArrayBufferObject.Interop)arrayBuffer).detachArrayBuffer();
        } else {
            assert (JSArrayBuffer.isJSHeapArrayBuffer((Object)arrayBuffer));
            ((JSArrayBufferObject.Heap)arrayBuffer).detachArrayBuffer();
        }
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getArrayBufferPrototype();
    }
}

