"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logger = void 0;
class Logger {
    static setLogErrorsOnly(logErrorsOnly) {
        Logger.logErrorsOnly = logErrorsOnly;
    }
    static setDebug(debug) {
        this.logDebug = debug;
    }
    static log(...args) {
        if (!Logger.logErrorsOnly) {
            console.log(...args);
        }
    }
    static error(...args) {
        console.error(...args);
    }
    static debug(...args) {
        if (!Logger.logErrorsOnly && this.logDebug) {
            console.log(...args);
        }
    }
}
exports.Logger = Logger;
Logger.logErrorsOnly = false;
Logger.logDebug = false;
//# sourceMappingURL=logger.js.map