/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.StackMarker;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import java.io.IOException;

public class L2HMathGroup
extends MathGroup {
    public L2HMathGroup() {
    }

    public L2HMathGroup(int n) {
        super(n);
    }

    @Override
    public TeXObjectList createList() {
        L2HMathGroup l2HMathGroup = new L2HMathGroup(this.capacity());
        l2HMathGroup.setInLine(this.isInLine());
        return l2HMathGroup;
    }

    @Override
    public void processList(TeXParser teXParser, StackMarker stackMarker) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        while (this.size() > 0) {
            if (((TeXObject)this.get(0)).equals(stackMarker)) {
                this.remove(0);
                break;
            }
            TeXObject teXObject = this.expandedPopStack(teXParser);
            if (teXObject == null) break;
            if (l2HConverter.useMathJax() && teXObject instanceof ControlSequence && !l2HConverter.isStyControlSequence((ControlSequence)teXObject)) {
                l2HConverter.write(teXObject.format());
                continue;
            }
            teXObject.process(teXParser, this);
        }
    }

    @Override
    public void startGroup(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        teXParser.startGroup();
        if (!this.isInLine()) {
            teXParser.getSettings().setMode(2);
            l2HConverter.writeliteral("<div class=\"displaymath\">");
        } else {
            teXParser.getSettings().setMode(1);
        }
        if (l2HConverter.useMathJax()) {
            if (this.isInLine()) {
                l2HConverter.writeliteral(l2HConverter.mathJaxStartInline());
            } else {
                l2HConverter.writeliteral(l2HConverter.mathJaxStartDisplay());
            }
        }
    }

    @Override
    public void endGroup(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (l2HConverter.useMathJax()) {
            if (this.isInLine()) {
                l2HConverter.writeliteral(l2HConverter.mathJaxEndInline());
            } else {
                l2HConverter.writeliteral(l2HConverter.mathJaxEndDisplay());
            }
        }
        if (!this.isInLine()) {
            l2HConverter.writeliteral("</div>");
        }
        teXParser.endGroup();
    }
}

