/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.MPPPath;
import org.islandoftex.arara.api.files.Project;
import org.islandoftex.arara.cli.utils.LoggingUtils;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Environment;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.islandoftex.arara.core.session.Session;
import org.islandoftex.arara.mvel.configuration.LocalConfiguration;
import org.islandoftex.arara.mvel.utils.MvelState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a8\u0006\r"}, d2={"Lorg/islandoftex/arara/cli/configuration/ConfigurationUtils;", "", "()V", "configFileForProject", "Lorg/islandoftex/arara/api/files/MPPPath;", "project", "Lorg/islandoftex/arara/api/files/Project;", "load", "", "file", "currentProject", "loadLocalConfiguration", "Lorg/islandoftex/arara/mvel/configuration/LocalConfiguration;", "cli"})
public final class ConfigurationUtils {
    @NotNull
    public static final ConfigurationUtils INSTANCE = new ConfigurationUtils();

    private ConfigurationUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MPPPath configFileForProject(@NotNull Project project) {
        Object v0;
        Object object;
        List<String> names;
        block7: {
            void $this$firstOrNull$iv;
            Iterator $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(project, "project");
            String[] stringArray = new String[]{".araraconfig.yaml", "araraconfig.yaml", ".arararc.yaml", "arararc.yaml"};
            names = CollectionsKt.listOf(stringArray);
            MPPPath workingDir = project.getWorkingDirectory();
            boolean bl = false;
            Iterable $this$map$iv = names;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(workingDir.div((String)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MPPPath it = (MPPPath)element$iv;
                boolean bl3 = false;
                if (!it.getExists()) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        MPPPath mPPPath = v0;
        MPPPath mPPPath2 = mPPPath;
        if (mPPPath == null) {
            String string = Environment.getSystemPropertyOrNull("user.home");
            if (string != null) {
                Object v3;
                block8: {
                    void $this$firstOrNull$iv;
                    void $this$mapTo$iv$iv;
                    Object element$iv;
                    String userHome = string;
                    boolean bl = false;
                    Iterable $this$map$iv = names;
                    boolean $i$f$map = false;
                    element$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        object = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(new MPPPath(userHome).div((String)it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        MPPPath it = (MPPPath)element$iv2;
                        boolean bl5 = false;
                        if (!it.getExists()) continue;
                        v3 = element$iv2;
                        break block8;
                    }
                    v3 = null;
                }
                mPPPath2 = v3;
            } else {
                mPPPath2 = null;
            }
        }
        return mPPPath2;
    }

    private final LocalConfiguration loadLocalConfiguration(MPPPath file) throws AraraException {
        if (!StringsKt.endsWith$default(file.getFileName(), ".yaml", false, 2, null)) {
            String string = "Kotlin DSL not implemented yet";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        return LocalConfiguration.Companion.load(file);
    }

    public final void load(@NotNull MPPPath file, @NotNull Project currentProject) throws AraraException {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(currentProject, "currentProject");
        LocalConfiguration resource = this.loadLocalConfiguration(file);
        LinearExecutor.INSTANCE.setExecutionOptions(resource.toExecutionOptions(currentProject, LinearExecutor.INSTANCE.getExecutionOptions()));
        Session.INSTANCE.setLoggingOptions(resource.toLoggingOptions(Session.INSTANCE.getLoggingOptions()));
        Session.INSTANCE.setUserInterfaceOptions(resource.toUserInterfaceOptions(Session.INSTANCE.getUserInterfaceOptions()));
        MvelState.INSTANCE.getPreambles().putAll(resource.getPreambles());
        MvelState.INSTANCE.setDefaultPreamble(resource.getDefaultPreamble());
        MvelState.INSTANCE.setPrependPreambleIfDirectivesGiven(resource.getPrependPreambleIfDirectivesGiven());
        LanguageController.loadMessagesFor(Session.INSTANCE.getUserInterfaceOptions().getLocale());
        LoggingUtils.INSTANCE.setupLogging(Session.INSTANCE.getLoggingOptions());
    }
}

