/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public class MaskManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 20;
    }

    @Override
    public String getPropertyName() {
        return "mask";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case URI: {
                return new URIValue(lexicalUnit.getStringValue(), MaskManager.resolveURI(cSSEngine.getCSSBaseURI(), lexicalUnit.getStringValue()));
            }
            case IDENT: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: {
                return this.createLexicalValue(lexicalUnit);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String string, CSSEngine cSSEngine) throws DOMException {
        switch (type) {
            case IDENT: {
                if (!string.equalsIgnoreCase("none")) break;
                return ValueConstants.NONE_VALUE;
            }
            case URI: {
                return new URIValue(string, MaskManager.resolveURI(cSSEngine.getCSSBaseURI(), string));
            }
        }
        throw this.createInvalidStringTypeDOMException(type);
    }
}

