/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.Hashtable;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeCollectionIterator;
import org.mozilla.javascript.NativeSet;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeMap
extends IdScriptableObject {
    private static final long serialVersionUID = 1171922614280016891L;
    private static final Object MAP_TAG = "Map";
    static final String ITERATOR_TAG = "Map Iterator";
    private final Hashtable entries = new Hashtable();
    private boolean instanceOfMap = false;
    private static final int Id_constructor = 1;
    private static final int Id_set = 2;
    private static final int Id_get = 3;
    private static final int Id_delete = 4;
    private static final int Id_has = 5;
    private static final int Id_clear = 6;
    private static final int Id_keys = 7;
    private static final int Id_values = 8;
    private static final int Id_entries = 9;
    private static final int Id_forEach = 10;
    private static final int SymbolId_getSize = 11;
    private static final int SymbolId_toStringTag = 12;
    private static final int MAX_PROTOTYPE_ID = 12;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeMap nativeMap = new NativeMap();
        IdFunctionObject idFunctionObject = nativeMap.exportAsJSClass(12, scriptable, false);
        ScriptableObject scriptableObject = (ScriptableObject)context.newObject(scriptable);
        scriptableObject.put("enumerable", (Scriptable)scriptableObject, (Object)Boolean.FALSE);
        scriptableObject.put("configurable", (Scriptable)scriptableObject, (Object)Boolean.TRUE);
        scriptableObject.put("get", (Scriptable)scriptableObject, nativeMap.get(NativeSet.GETSIZE, (Scriptable)nativeMap));
        nativeMap.defineOwnProperty(context, "size", scriptableObject);
        ScriptRuntimeES6.addSymbolSpecies(context, scriptable, idFunctionObject);
        if (bl) {
            nativeMap.sealObject();
        }
    }

    @Override
    public String getClassName() {
        return "Map";
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(MAP_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                if (scriptable2 == null) {
                    NativeMap nativeMap = new NativeMap();
                    nativeMap.instanceOfMap = true;
                    if (objectArray.length > 0) {
                        NativeMap.loadFromIterable(context, scriptable, nativeMap, NativeMap.key(objectArray));
                    }
                    return nativeMap;
                }
                throw ScriptRuntime.typeErrorById("msg.no.new", "Map");
            }
            case 2: {
                return NativeMap.realThis(scriptable2, idFunctionObject).js_set(NativeMap.key(objectArray), objectArray.length > 1 ? objectArray[1] : Undefined.instance);
            }
            case 4: {
                return NativeMap.realThis(scriptable2, idFunctionObject).js_delete(NativeMap.key(objectArray));
            }
            case 3: {
                return NativeMap.realThis(scriptable2, idFunctionObject).js_get(NativeMap.key(objectArray));
            }
            case 5: {
                return NativeMap.realThis(scriptable2, idFunctionObject).js_has(NativeMap.key(objectArray));
            }
            case 6: {
                return NativeMap.realThis(scriptable2, idFunctionObject).js_clear();
            }
            case 7: {
                return NativeMap.realThis(scriptable2, idFunctionObject).js_iterator(scriptable, NativeCollectionIterator.Type.KEYS);
            }
            case 8: {
                return NativeMap.realThis(scriptable2, idFunctionObject).js_iterator(scriptable, NativeCollectionIterator.Type.VALUES);
            }
            case 9: {
                return NativeMap.realThis(scriptable2, idFunctionObject).js_iterator(scriptable, NativeCollectionIterator.Type.BOTH);
            }
            case 10: {
                return NativeMap.realThis(scriptable2, idFunctionObject).js_forEach(context, scriptable, objectArray.length > 0 ? objectArray[0] : Undefined.instance, objectArray.length > 1 ? objectArray[1] : Undefined.instance);
            }
            case 11: {
                return NativeMap.realThis(scriptable2, idFunctionObject).js_getSize();
            }
        }
        throw new IllegalArgumentException("Map.prototype has no method: " + idFunctionObject.getFunctionName());
    }

    private Object js_set(Object object, Object object2) {
        Object object3 = object;
        if (object3 instanceof Number && ((Number)object3).doubleValue() == ScriptRuntime.negativeZero) {
            object3 = ScriptRuntime.zeroObj;
        }
        this.entries.put(object3, object2);
        return this;
    }

    private Object js_delete(Object object) {
        return this.entries.deleteEntry(object);
    }

    private Object js_get(Object object) {
        Hashtable.Entry entry = this.entries.getEntry(object);
        if (entry == null) {
            return Undefined.instance;
        }
        return entry.value;
    }

    private Object js_has(Object object) {
        return this.entries.has(object);
    }

    private Object js_getSize() {
        return this.entries.size();
    }

    private Object js_iterator(Scriptable scriptable, NativeCollectionIterator.Type type) {
        return new NativeCollectionIterator(scriptable, ITERATOR_TAG, type, this.entries.iterator());
    }

    private Object js_clear() {
        this.entries.clear();
        return Undefined.instance;
    }

    private Object js_forEach(Context context, Scriptable scriptable, Object object, Object object2) {
        if (!(object instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", object, ScriptRuntime.typeof(object));
        }
        Callable callable = (Callable)object;
        boolean bl = context.isStrictMode();
        for (Hashtable.Entry entry : this.entries) {
            Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object2, scriptable);
            if (scriptable2 == null && !bl) {
                scriptable2 = scriptable;
            }
            if (scriptable2 == null) {
                scriptable2 = Undefined.SCRIPTABLE_UNDEFINED;
            }
            Hashtable.Entry entry2 = entry;
            callable.call(context, scriptable, scriptable2, new Object[]{entry2.value, entry2.key, this});
        }
        return Undefined.instance;
    }

    static void loadFromIterable(Context context, Scriptable scriptable, ScriptableObject scriptableObject, Object object3) {
        if (object3 == null || Undefined.instance.equals(object3)) {
            return;
        }
        Object object4 = ScriptRuntime.callIterator(object3, context, scriptable);
        if (Undefined.instance.equals(object4)) {
            return;
        }
        Scriptable scriptable2 = ScriptableObject.getClassPrototype(scriptable, scriptableObject.getClassName());
        Callable callable = ScriptRuntime.getPropFunctionAndThis(scriptable2, "set", context, scriptable);
        ScriptRuntime.lastStoredScriptable(context);
        ScriptRuntime.loadFromIterable(context, scriptable, object3, (Object object, Object object2) -> callable.call(context, scriptable, scriptableObject, new Object[]{object, object2}));
    }

    private static NativeMap realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        NativeMap nativeMap = NativeMap.ensureType(scriptable, NativeMap.class, idFunctionObject);
        if (!nativeMap.instanceOfMap) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", idFunctionObject.getFunctionName());
        }
        return nativeMap;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 11: {
                this.initPrototypeMethod(MAP_TAG, n, NativeSet.GETSIZE, "get size", 0);
                return;
            }
            case 12: {
                this.initPrototypeValue(12, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
                return;
            }
        }
        String string2 = null;
        switch (n) {
            case 1: {
                n2 = 0;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 2;
                string = "set";
                break;
            }
            case 3: {
                n2 = 1;
                string = "get";
                break;
            }
            case 4: {
                n2 = 1;
                string = "delete";
                break;
            }
            case 5: {
                n2 = 1;
                string = "has";
                break;
            }
            case 6: {
                n2 = 0;
                string = "clear";
                break;
            }
            case 7: {
                n2 = 0;
                string = "keys";
                break;
            }
            case 8: {
                n2 = 0;
                string = "values";
                break;
            }
            case 9: {
                n2 = 0;
                string = "entries";
                break;
            }
            case 10: {
                n2 = 1;
                string = "forEach";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(MAP_TAG, n, string, string2, n2);
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (NativeSet.GETSIZE.equals(symbol)) {
            return 11;
        }
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return 9;
        }
        if (SymbolKey.TO_STRING_TAG.equals(symbol)) {
            return 12;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "set": {
                n = 2;
                break;
            }
            case "get": {
                n = 3;
                break;
            }
            case "delete": {
                n = 4;
                break;
            }
            case "has": {
                n = 5;
                break;
            }
            case "clear": {
                n = 6;
                break;
            }
            case "keys": {
                n = 7;
                break;
            }
            case "values": {
                n = 8;
                break;
            }
            case "entries": {
                n = 9;
                break;
            }
            case "forEach": {
                n = 10;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    static Object key(Object[] objectArray) {
        if (objectArray.length > 0) {
            Object object = objectArray[0];
            if (object instanceof Delegator) {
                return ((Delegator)object).getDelegee();
            }
            return object;
        }
        return Undefined.instance;
    }
}

