/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import org.mozilla.javascript.EmbeddedSlotMap;
import org.mozilla.javascript.HashSlotMap;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMap;

class SlotMapContainer
implements SlotMap {
    private static final int LARGE_HASH_SIZE = 2000;
    private static final int DEFAULT_SIZE = 10;
    protected SlotMap map;

    SlotMapContainer() {
        this(10);
    }

    SlotMapContainer(int n) {
        this.map = n > 2000 ? new HashSlotMap() : new EmbeddedSlotMap();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public int dirtySize() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Slot modify(Object object, int n, int n2) {
        this.checkMapSize();
        return this.map.modify(object, n, n2);
    }

    @Override
    public void replace(Slot slot, Slot slot2) {
        this.map.replace(slot, slot2);
    }

    @Override
    public Slot query(Object object, int n) {
        return this.map.query(object, n);
    }

    @Override
    public void add(Slot slot) {
        this.checkMapSize();
        this.map.add(slot);
    }

    @Override
    public void remove(Object object, int n) {
        this.map.remove(object, n);
    }

    @Override
    public Iterator<Slot> iterator() {
        return this.map.iterator();
    }

    public long readLock() {
        return 0L;
    }

    public void unlockRead(long l) {
    }

    protected void checkMapSize() {
        if (this.map instanceof EmbeddedSlotMap && this.map.size() >= 2000) {
            HashSlotMap hashSlotMap = new HashSlotMap();
            for (Slot slot : this.map) {
                hashSlotMap.add(slot);
            }
            this.map = hashSlotMap;
        }
    }
}

