/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSUnicodeRangeValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.UnicodeValue;
import io.sf.carte.doc.style.css.property.UnicodeWildcardValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class UnicodeRangeValue
extends TypedValue
implements CSSUnicodeRangeValue {
    private static final long serialVersionUID = 1L;
    private TypedValue value = null;
    private TypedValue endValue = null;

    UnicodeRangeValue() {
        super(CSSValue.Type.UNICODE_RANGE);
    }

    protected UnicodeRangeValue(UnicodeRangeValue unicodeRangeValue) {
        super(unicodeRangeValue);
        this.value = unicodeRangeValue.value;
        this.endValue = unicodeRangeValue.endValue;
    }

    @Override
    public String getCssText() {
        if (this.endValue == null) {
            return this.value.getCssText();
        }
        String string = this.value.getCssText();
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2 + 16);
        stringBuilder.append(string).append('-');
        if (this.endValue.getPrimitiveType() == CSSValue.Type.UNICODE_CHARACTER) {
            stringBuilder.append(Integer.toHexString(((CSSUnicodeRangeValue.CSSUnicodeValue)((Object)this.endValue)).getCodePoint()));
        } else {
            stringBuilder.append(this.endValue.getStringValue());
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        this.value.writeCssText(simpleWriter);
        if (this.endValue != null) {
            simpleWriter.write('-');
            if (this.endValue.getPrimitiveType() == CSSValue.Type.UNICODE_CHARACTER) {
                simpleWriter.write((CharSequence)Integer.toHexString(((CSSUnicodeRangeValue.CSSUnicodeValue)((Object)this.endValue)).getCodePoint()));
            } else {
                simpleWriter.write((CharSequence)this.endValue.getStringValue());
            }
        }
    }

    @Override
    public TypedValue getValue() {
        return this.value;
    }

    @Override
    public TypedValue getEndValue() {
        return this.endValue;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        return cSSValueSyntax.getCategory() == CSSValueSyntax.Category.unicodeRange ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.endValue == null ? 0 : this.endValue.hashCode());
        n2 = 31 * n2 + (this.value == null ? 0 : this.value.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UnicodeRangeValue unicodeRangeValue = (UnicodeRangeValue)object;
        if (this.endValue == null ? unicodeRangeValue.endValue != null : !this.endValue.equals(unicodeRangeValue.endValue)) {
            return false;
        }
        if (this.value == null) {
            return unicodeRangeValue.value == null;
        }
        return this.value.equals(unicodeRangeValue.value);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public UnicodeRangeValue clone() {
        return new UnicodeRangeValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getSubValues();
            if (lexicalUnit2 == null) {
                throw new DOMException(11, "Invalid (empty) range value");
            }
            UnicodeRangeValue.this.value = this.readValue(lexicalUnit2);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2 != null) {
                UnicodeRangeValue.this.endValue = this.readValue(lexicalUnit2);
            } else {
                UnicodeRangeValue.this.endValue = null;
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private TypedValue readValue(LexicalUnit lexicalUnit) {
            LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
                UnicodeValue unicodeValue = new UnicodeValue();
                unicodeValue.setCodePoint(lexicalUnit.getIntegerValue());
                return unicodeValue;
            }
            if (lexicalType == LexicalUnit.LexicalType.UNICODE_WILDCARD) {
                UnicodeWildcardValue unicodeWildcardValue = new UnicodeWildcardValue();
                unicodeWildcardValue.setWildcard(lexicalUnit.getStringValue());
                return unicodeWildcardValue;
            }
            throw new DOMException(17, "Wrong type for unicode range");
        }
    }
}

