/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image;

import io.sf.carte.echosvg.ext.awt.image.TransferFunction;

public class LinearTransfer
implements TransferFunction {
    public byte[] lutData;
    public float slope;
    public float intercept;

    public LinearTransfer(float f, float f2) {
        this.slope = f;
        this.intercept = f2;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        float f = this.intercept * 255.0f + 0.5f;
        for (int i = 0; i <= 255; ++i) {
            int n = (int)(this.slope * (float)i + f);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            this.lutData[i] = (byte)(0xFF & n);
        }
    }

    @Override
    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

