/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjBadCrcException;
import jogamp.opengl.util.pngj.PngjOutputException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;

public class ChunkRaw {
    public final int len;
    public final byte[] idbytes = new byte[4];
    public byte[] data = null;
    private int crcval = 0;

    public ChunkRaw(int n, byte[] byArray, boolean bl) {
        this.len = n;
        System.arraycopy(byArray, 0, this.idbytes, 0, 4);
        if (bl) {
            this.allocData();
        }
    }

    private void allocData() {
        if (this.data == null || this.data.length < this.len) {
            this.data = new byte[this.len];
        }
    }

    private int computeCrc() {
        CRC32 cRC32 = PngHelperInternal.getCRC();
        cRC32.reset();
        cRC32.update(this.idbytes, 0, 4);
        if (this.len > 0) {
            cRC32.update(this.data, 0, this.len);
        }
        return (int)cRC32.getValue();
    }

    public void writeChunk(OutputStream outputStream) {
        if (this.idbytes.length != 4) {
            throw new PngjOutputException("bad chunkid [" + ChunkHelper.toString(this.idbytes) + "]");
        }
        this.crcval = this.computeCrc();
        PngHelperInternal.writeInt4(outputStream, this.len);
        PngHelperInternal.writeBytes(outputStream, this.idbytes);
        if (this.len > 0) {
            PngHelperInternal.writeBytes(outputStream, this.data, 0, this.len);
        }
        PngHelperInternal.writeInt4(outputStream, this.crcval);
    }

    public int readChunkData(InputStream inputStream, boolean bl) {
        int n;
        PngHelperInternal.readBytes(inputStream, this.data, 0, this.len);
        this.crcval = PngHelperInternal.readInt4(inputStream);
        if (bl && (n = this.computeCrc()) != this.crcval) {
            throw new PngjBadCrcException("chunk: " + this + " crc calc=" + n + " read=" + this.crcval);
        }
        return this.len + 4;
    }

    ByteArrayInputStream getAsByteStream() {
        return new ByteArrayInputStream(this.data);
    }

    public String toString() {
        return "chunkid=" + ChunkHelper.toString(this.idbytes) + " len=" + this.len;
    }
}

