/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom.util;

import io.sf.carte.echosvg.dom.util.DocumentDescriptor;
import io.sf.carte.echosvg.dom.util.DocumentFactory;
import io.sf.carte.echosvg.dom.util.HashTableStack;
import io.sf.carte.echosvg.dom.util.ResourceEntityResolver;
import io.sf.carte.echosvg.dom.util.SAXIOException;
import io.sf.carte.echosvg.util.HaltingThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SAXDocumentFactory
extends DocumentBuilder
implements LexicalHandler,
DocumentFactory,
ContentHandler,
ErrorHandler {
    private DOMImplementation implementation;
    private XMLReader parser;
    private Document document;
    private DocumentDescriptor documentDescriptor;
    private boolean createDocumentDescriptor;
    private Node currentNode;
    private Locator locator;
    private StringBuilder stringBuffer = new StringBuilder();
    private DocumentType doctype;
    private boolean stringContent;
    private boolean inDTD;
    private boolean inCDATA;
    private boolean inProlog;
    private boolean isValidating;
    private boolean isStandalone;
    private String xmlVersion;
    private HashTableStack namespaces;
    protected ErrorHandler errorHandler;
    private List<PreInfo> preInfo;
    private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();

    public SAXDocumentFactory(DOMImplementation impl) {
        this(impl, null);
    }

    public SAXDocumentFactory(DOMImplementation impl, XMLReader reader) {
        this(impl, reader, false);
    }

    public SAXDocumentFactory(DOMImplementation impl, XMLReader reader, boolean dd) {
        this.implementation = impl;
        this.parser = SAXDocumentFactory.getXMLReader(reader);
        this.createDocumentDescriptor = dd;
    }

    private static XMLReader getXMLReader(XMLReader reader) {
        if (reader == null) {
            ServiceLoader<XMLReader> loader = ServiceLoader.load(XMLReader.class);
            Iterator<XMLReader> it = loader.iterator();
            if (it.hasNext()) {
                reader = it.next();
                try {
                    reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                    // empty catch block
                }
                try {
                    reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {}
            } else {
                try {
                    SAXParser saxParser = saxFactory.newSAXParser();
                    reader = saxParser.getXMLReader();
                }
                catch (ParserConfigurationException | SAXException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            reader.setEntityResolver(SAXDocumentFactory.createEntityResolver());
        }
        return reader;
    }

    @Override
    public Document createDocument(String ns, String root, String uri) throws IOException {
        return this.parseDocument(ns, root, uri, new InputSource(uri));
    }

    @Override
    public Document createDocument(String ns, String root, String uri, String encoding) throws IOException {
        InputSource inp = new InputSource(uri);
        inp.setEncoding(encoding);
        return this.parseDocument(ns, root, uri, inp);
    }

    public Document createDocument(String uri) throws IOException {
        return this.parseDocument(new InputSource(uri));
    }

    public Document createDocument(String uri, String encoding) throws IOException {
        InputSource inp = new InputSource(uri);
        inp.setEncoding(encoding);
        return this.parseDocument(inp);
    }

    @Override
    public Document createDocument(String ns, String root, String uri, InputStream is) throws IOException {
        InputSource inp = new InputSource(is);
        inp.setSystemId(uri);
        return this.parseDocument(ns, root, uri, inp);
    }

    @Override
    public Document createDocument(String ns, String root, String uri, InputStream is, String encoding) throws IOException {
        InputSource inp = new InputSource(is);
        inp.setSystemId(uri);
        inp.setEncoding(encoding);
        return this.parseDocument(ns, root, uri, inp);
    }

    public Document createDocument(String uri, InputStream is) throws IOException {
        InputSource inp = new InputSource(is);
        inp.setSystemId(uri);
        return this.parseDocument(inp);
    }

    @Override
    public Document createDocument(String ns, String root, String uri, Reader r) throws IOException {
        InputSource inp = new InputSource(r);
        inp.setSystemId(uri);
        return this.parseDocument(ns, root, uri, inp);
    }

    @Override
    @Deprecated
    public Document createDocument(String ns, String root, String uri, XMLReader r) throws IOException {
        r.setContentHandler(this);
        if (r.getEntityResolver() == null) {
            r.setEntityResolver(SAXDocumentFactory.createEntityResolver());
        }
        try {
            r.parse(uri);
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex instanceof InterruptedIOException) {
                throw (InterruptedIOException)ex;
            }
            throw new SAXIOException(e);
        }
        this.currentNode = null;
        Document ret = this.document;
        this.document = null;
        this.doctype = null;
        ret.setDocumentURI(uri);
        return ret;
    }

    private static EntityResolver createEntityResolver() {
        return new ResourceEntityResolver();
    }

    public Document createDocument(String uri, Reader r) throws IOException {
        InputSource inp = new InputSource(r);
        inp.setSystemId(uri);
        return this.parseDocument(inp);
    }

    private Document parseDocument(String ns, String root, String uri, InputSource is) throws IOException {
        Document doc = this.createDocument(ns, root, uri, is);
        doc.setDocumentURI(uri);
        return doc;
    }

    protected Document createDocument(String ns, String root, String uri, InputSource is) throws IOException {
        String docElemNS;
        this.checkRootElement(ns, root);
        Document ret = this.createDocument(is);
        Element docElem = ret.getDocumentElement();
        String lname = root;
        String nsURI = ns;
        if (ns == null) {
            int idx = lname.indexOf(58);
            String nsp = idx == -1 || idx == lname.length() - 1 ? "" : lname.substring(0, idx);
            nsURI = this.namespaces.get(nsp);
            if (idx != -1 && idx != lname.length() - 1) {
                lname = lname.substring(idx + 1);
            }
        }
        if ((docElemNS = docElem.getNamespaceURI()) != nsURI && docElemNS != null && !docElemNS.equals(nsURI)) {
            throw new IOException("Root element namespace does not match that requested:\nRequested: " + nsURI + "\nFound: " + docElemNS);
        }
        if (docElemNS != null) {
            if (!docElem.getLocalName().equals(lname)) {
                throw new IOException("Root element does not match that requested:\nRequested: " + lname + "\nFound: " + docElem.getLocalName());
            }
        } else if (!docElem.getNodeName().equals(lname)) {
            throw new IOException("Root element does not match that requested:\nRequested: " + lname + "\nFound: " + docElem.getNodeName());
        }
        return ret;
    }

    protected void checkRootElement(String ns, String root) {
    }

    private Document parseDocument(InputSource is) throws IOException {
        Document doc = this.createDocument(is);
        doc.setDocumentURI(is.getSystemId());
        return doc;
    }

    protected Document createDocument(InputSource is) throws IOException {
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this.errorHandler == null ? this : this.errorHandler);
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", this.isValidating);
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.parser.parse(is);
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex instanceof InterruptedIOException) {
                throw (InterruptedIOException)ex;
            }
            throw new SAXIOException(e);
        }
        this.currentNode = null;
        Document ret = this.document;
        this.document = null;
        this.doctype = null;
        this.locator = null;
        return ret;
    }

    @Override
    public DocumentDescriptor getDocumentDescriptor() {
        return this.documentDescriptor;
    }

    @Override
    public void setXMLReader(XMLReader reader) {
        this.parser = SAXDocumentFactory.getXMLReader(reader);
    }

    @Override
    public void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    @Override
    public void setValidating(boolean isValidating) {
        this.isValidating = isValidating;
        if (this.parser.getEntityResolver() == null) {
            if (isValidating) {
                this.parser.setEntityResolver(SAXDocumentFactory.createEntityResolver());
            } else {
                this.secureReader();
            }
        }
    }

    @Override
    public boolean isValidating() {
        return this.isValidating;
    }

    protected boolean isStandalone() {
        return this.isStandalone;
    }

    protected String getXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    public DOMImplementation getDOMImplementation(String ver) {
        return this.implementation;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.implementation;
    }

    @Override
    public Document parse(InputSource is) throws SAXException, IOException {
        return this.parseDocument(is);
    }

    @Override
    public boolean isNamespaceAware() {
        try {
            return this.parser.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            return false;
        }
    }

    @Override
    public boolean isXIncludeAware() {
        try {
            return this.parser.getFeature("http://apache.org/xml/features/xinclude");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            return false;
        }
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.parser.setEntityResolver(er);
        if (er == null) {
            this.secureReader();
        }
    }

    private void secureReader() {
        this.isValidating = false;
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        try {
            this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        try {
            this.parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            this.parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }

    @Override
    public Document newDocument() {
        return this.implementation.createDocument(null, null, null);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        throw ex;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.initPreInfo();
        this.namespaces = new HashTableStack();
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
        this.namespaces.put("", null);
        this.inDTD = false;
        this.inCDATA = false;
        this.inProlog = true;
        this.currentNode = null;
        this.document = null;
        this.doctype = null;
        this.isStandalone = false;
        this.xmlVersion = "1.0";
        this.stringBuffer.setLength(0);
        this.stringContent = false;
        this.documentDescriptor = this.createDocumentDescriptor ? new DocumentDescriptor() : null;
    }

    protected void initPreInfo() {
        this.preInfo = new LinkedList<PreInfo>();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        Element e;
        if (HaltingThread.hasBeenHalted()) {
            throw new SAXException(new InterruptedIOException());
        }
        if (this.inProlog) {
            this.inProlog = false;
            if (this.parser != null) {
                try {
                    this.isStandalone = this.parser.getFeature("http://xml.org/sax/features/is-standalone");
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
                try {
                    this.xmlVersion = (String)this.parser.getProperty("http://xml.org/sax/properties/document-xml-version");
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
        }
        int len = attributes.getLength();
        this.namespaces.push();
        String version = null;
        for (int i = 0; i < len; ++i) {
            String ns;
            String aname = attributes.getQName(i);
            int slen = aname.length();
            if (slen < 5) continue;
            if (aname.equals("version")) {
                version = attributes.getValue(i);
                continue;
            }
            if (!aname.startsWith("xmlns")) continue;
            if (slen == 5) {
                ns = attributes.getValue(i);
                if (ns.length() == 0) {
                    ns = null;
                }
                this.namespaces.put("", ns);
                continue;
            }
            if (aname.charAt(5) != ':') continue;
            ns = attributes.getValue(i);
            if (ns.length() == 0) {
                ns = null;
            }
            this.namespaces.put(aname.substring(6), ns);
        }
        this.appendStringData();
        int idx = rawName.indexOf(58);
        String nsp = idx == -1 || idx == rawName.length() - 1 ? "" : rawName.substring(0, idx);
        String nsURI = this.namespaces.get(nsp);
        if (this.currentNode == null) {
            this.implementation = this.getDOMImplementation(version);
            this.document = this.implementation.createDocument(nsURI, rawName, this.doctype);
            Iterator<PreInfo> i = this.preInfoIterator();
            e = this.document.getDocumentElement();
            this.currentNode = e;
            while (i.hasNext()) {
                PreInfo pi = i.next();
                Node n = pi.createNode(this.document);
                this.document.insertBefore(n, e);
            }
            this.preInfo = null;
        } else {
            e = this.document.createElementNS(nsURI, rawName);
            this.currentNode.appendChild(e);
            this.currentNode = e;
        }
        if (this.createDocumentDescriptor && this.locator != null) {
            this.documentDescriptor.setLocation(e, this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        for (int i = 0; i < len; ++i) {
            String aname = attributes.getQName(i);
            if (aname.equals("xmlns")) {
                e.setAttributeNS("http://www.w3.org/2000/xmlns/", aname, attributes.getValue(i));
                continue;
            }
            idx = aname.indexOf(58);
            nsURI = idx == -1 ? null : this.namespaces.get(aname.substring(0, idx));
            e.setAttributeNS(nsURI, aname, attributes.getValue(i));
        }
    }

    protected Iterator<PreInfo> preInfoIterator() {
        return this.preInfo.iterator();
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        this.appendStringData();
        if (this.currentNode != null) {
            this.currentNode = this.currentNode.getParentNode();
        }
        this.namespaces.pop();
    }

    public void appendStringData() {
        if (!this.stringContent) {
            return;
        }
        String str = this.stringBuffer.toString();
        this.stringBuffer.setLength(0);
        this.stringContent = false;
        if (this.currentNode == null) {
            if (this.inCDATA) {
                this.addPreInfo(new CDataInfo(str));
            } else {
                this.addPreInfo(new TextInfo(str));
            }
        } else {
            Text n = this.inCDATA ? this.document.createCDATASection(str) : this.document.createTextNode(str);
            this.currentNode.appendChild(n);
        }
    }

    protected void addPreInfo(PreInfo node) {
        this.preInfo.add(node);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.stringBuffer.append(ch, start, length);
        this.stringContent = true;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.stringBuffer.append(ch, start, length);
        this.stringContent = true;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.appendStringData();
        if (this.currentNode == null) {
            this.addPreInfo(new ProcessingInstructionInfo(target, data));
        } else {
            this.currentNode.appendChild(this.document.createProcessingInstruction(target, data));
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.appendStringData();
        this.doctype = this.implementation.createDocumentType(name, publicId, systemId);
        this.inDTD = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.appendStringData();
        this.inCDATA = true;
        this.stringContent = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.appendStringData();
        this.inCDATA = false;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.appendStringData();
        String str = new String(ch, start, length);
        if (this.currentNode == null) {
            this.addPreInfo(new CommentInfo(str));
        } else {
            this.currentNode.appendChild(this.document.createComment(str));
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    static {
        try {
            saxFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            saxFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            saxFactory.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
    }

    protected static interface PreInfo {
        public Node createNode(Document var1);
    }

    private static class CDataInfo
    implements PreInfo {
        public String cdata;

        public CDataInfo(String cdata) {
            this.cdata = cdata;
        }

        @Override
        public Node createNode(Document doc) {
            return doc.createCDATASection(this.cdata);
        }
    }

    private static class TextInfo
    implements PreInfo {
        public String text;

        public TextInfo(String text) {
            this.text = text;
        }

        @Override
        public Node createNode(Document doc) {
            return doc.createTextNode(this.text);
        }
    }

    private static class ProcessingInstructionInfo
    implements PreInfo {
        public String target;
        public String data;

        public ProcessingInstructionInfo(String target, String data) {
            this.target = target;
            this.data = data;
        }

        @Override
        public Node createNode(Document doc) {
            return doc.createProcessingInstruction(this.target, this.data);
        }
    }

    private static class CommentInfo
    implements PreInfo {
        public String comment;

        public CommentInfo(String comment) {
            this.comment = comment;
        }

        @Override
        public Node createNode(Document doc) {
            return doc.createComment(this.comment);
        }
    }
}

