/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.echosvg.i18n.LocalizableSupport;
import io.sf.carte.echosvg.parser.CalcParseException;
import io.sf.carte.echosvg.parser.DefaultErrorHandler;
import io.sf.carte.echosvg.parser.ErrorHandler;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.Parser;
import io.sf.carte.echosvg.util.io.NormalizingReader;
import io.sf.carte.echosvg.util.io.StreamNormalizingReader;
import io.sf.carte.echosvg.util.io.StringNormalizingReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public abstract class AbstractParser
implements Parser {
    public static final String BUNDLE_CLASSNAME = "io.sf.carte.echosvg.parser.resources.Messages";
    protected ErrorHandler errorHandler = new DefaultErrorHandler();
    protected LocalizableSupport localizableSupport = new LocalizableSupport("io.sf.carte.echosvg.parser.resources.Messages", AbstractParser.class.getClassLoader());
    protected NormalizingReader reader;
    protected int current;

    public int getCurrent() {
        return this.current;
    }

    public void setLocale(Locale l) {
        this.localizableSupport.setLocale(l);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String key, Object[] args) throws MissingResourceException {
        return this.localizableSupport.formatMessage(key, args);
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void parse(Reader r) throws ParseException {
        try {
            this.reader = new StreamNormalizingReader(r);
            this.doParse();
        }
        catch (IOException e) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), e));
        }
    }

    public void parse(InputStream is, String enc) throws ParseException {
        try {
            this.reader = new StreamNormalizingReader(is, enc);
            this.doParse();
        }
        catch (IOException e) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), e));
        }
    }

    @Override
    public void parse(String s) throws ParseException {
        try {
            this.reader = new StringNormalizingReader(s);
            this.doParse();
        }
        catch (IOException e) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), e));
        }
        catch (CalcParseException e) {
            this.cssParse();
        }
    }

    void cssParse() throws ParseException {
        LexicalUnit lunit;
        PushbackReader pbre = new PushbackReader((Reader)this.reader, 5);
        char[] cbuf = new char[]{'c', 'a', 'l', 'c', '('};
        try {
            pbre.unread(cbuf);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        CSSParser parser = new CSSParser();
        try {
            lunit = parser.parsePropertyValue((Reader)pbre);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            ParseException pex = new ParseException(ex);
            pex.lineNumber = this.reader.getLine();
            pex.columnNumber = this.reader.getColumn();
            this.errorHandler.error(pex);
            return;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        try {
            StyleValue cssvalue = new ValueFactory().createCSSValue(lunit);
            this.handleStyleValue((CSSValue)cssvalue);
        }
        catch (ParseException pex) {
            pex.lineNumber = this.reader.getLine();
            pex.columnNumber = this.reader.getColumn();
            this.errorHandler.error(pex);
        }
        catch (Exception ex) {
            ParseException pex = new ParseException(ex);
            pex.lineNumber = this.reader.getLine();
            pex.columnNumber = this.reader.getColumn();
            this.errorHandler.error(pex);
        }
        this.current = -1;
    }

    private void handleStyleValue(CSSValue cssvalue) throws ParseException {
        switch (cssvalue.getCssValueType()) {
            case LIST: {
                ValueList list = (ValueList)cssvalue;
                this.handleListStart(list.isCommaSeparated());
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.handleStyleValue((CSSValue)it.next());
                }
                this.handleListEnd(list.isCommaSeparated());
                break;
            }
            case TYPED: {
                this.handleTyped((CSSTypedValue)cssvalue);
                break;
            }
            default: {
                this.errorHandler.error(new ParseException(this.createErrorMessage("non.css.context", new Object[]{cssvalue.getCssText()}), -1, -1));
            }
        }
    }

    protected void handleListStart(boolean commaSeparated) {
    }

    protected void handleListEnd(boolean commaSeparated) {
    }

    private void handleTyped(CSSTypedValue cssvalue) throws ParseException {
        switch (cssvalue.getPrimitiveType()) {
            case NUMERIC: {
                this.handleNumber(cssvalue.getUnitType(), cssvalue.getFloatValue(cssvalue.getUnitType()));
                break;
            }
            case EXPRESSION: {
                this.handleMathExpression((CSSExpressionValue)cssvalue);
                break;
            }
            case MATH_FUNCTION: {
                this.handleMathFunction((CSSMathFunctionValue)cssvalue);
                break;
            }
            case IDENT: {
                this.handleIdent(cssvalue.getStringValue());
                break;
            }
            default: {
                this.errorHandler.error(new ParseException(this.createErrorMessage("non.css.context", new Object[]{cssvalue.getCssText()}), -1, -1));
            }
        }
    }

    protected void handleNumber(short unitType, float floatValue) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage("unexpected.value", new Object[]{Float.toString(floatValue) + CSSUnit.dimensionUnitString((short)unitType)}), -1, -1));
    }

    protected void handleMathExpression(CSSExpressionValue cssvalue) throws ParseException {
        float floatValue;
        short unitType;
        Evaluator eval = new Evaluator(this.getPreferredUnit());
        try {
            CSSTypedValue typed = eval.evaluateExpression(cssvalue);
            unitType = typed.getUnitType();
            if (unitType != this.getPreferredUnit()) {
                if (this.getPreferredUnit() == 0) {
                    throw new ParseException("Invalid unit.", -1, -1);
                }
                if (unitType == 0) {
                    unitType = this.getPreferredUnit();
                }
            }
            floatValue = typed.getFloatValue(unitType);
        }
        catch (RuntimeException e) {
            throw new ParseException(e);
        }
        this.handleNumber(unitType, floatValue);
    }

    protected void handleMathFunction(CSSMathFunctionValue cssvalue) throws ParseException {
        float floatValue;
        short unitType;
        Evaluator eval = new Evaluator(this.getPreferredUnit());
        try {
            CSSNumberValue typed = eval.evaluateFunction(cssvalue);
            unitType = typed.getUnitType();
            if (unitType != this.getPreferredUnit()) {
                if (this.getPreferredUnit() == 0) {
                    throw new ParseException("Invalid unit.", -1, -1);
                }
                if (unitType == 0) {
                    unitType = this.getPreferredUnit();
                }
            }
            floatValue = typed.getFloatValue(unitType);
        }
        catch (RuntimeException e) {
            throw new ParseException(e);
        }
        this.handleNumber(unitType, floatValue);
    }

    protected short getPreferredUnit() {
        return 0;
    }

    protected void handleIdent(String ident) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage("unexpected.identifier", new Object[]{ident}), -1, -1));
    }

    protected abstract void doParse() throws ParseException, IOException;

    void checkForCalc() throws IOException {
        int line = this.reader.getLine();
        int column = this.reader.getColumn();
        char[] calcLCRef = new char[]{'a', 'l', 'c', '('};
        char[] calcUCRef = new char[]{'A', 'L', 'C', '('};
        char[] calcBuf = new char[4];
        this.reader.read(calcBuf);
        if (AbstractParser.equalsAny(calcLCRef, calcUCRef, calcBuf)) {
            this.handleCalc(line, column);
        } else {
            this.reportError("character.unexpected", new Object[]{this.current}, line, column);
        }
    }

    private static boolean equalsAny(char[] lcRef, char[] ucRef, char[] buf) {
        assert (lcRef.length == buf.length);
        for (int i = 0; i < lcRef.length; ++i) {
            char c = buf[i];
            if (c == lcRef[i] || c == ucRef[i]) continue;
            return false;
        }
        return true;
    }

    protected void handleCalc(int line, int column) throws CalcParseException {
        throw new CalcParseException("Cannot handle calc().", line, column);
    }

    private void reportError(String key, Object[] objects, int line, int column) {
        this.errorHandler.error(new ParseException(this.createErrorMessage(key, new Object[]{this.current}), line, column));
    }

    protected void reportError(String key, Object[] args) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage(key, args), this.reader.getLine(), this.reader.getColumn()));
    }

    protected void reportCharacterExpectedError(char expectedChar, int currentChar) {
        this.reportError("character.expected", new Object[]{Character.valueOf(expectedChar), currentChar});
    }

    protected void reportUnexpectedCharacterError(int currentChar) {
        this.reportError("character.unexpected", new Object[]{currentChar});
    }

    protected String createErrorMessage(String key, Object[] args) {
        try {
            return this.formatMessage(key, args);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    protected String getBundleClassName() {
        return BUNDLE_CLASSNAME;
    }

    protected void skipSpaces() throws IOException {
        while (true) {
            switch (this.current) {
                default: {
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
            this.current = this.reader.read();
        }
    }

    protected void skipCommaSpaces() throws IOException {
        block6: while (true) {
            switch (this.current) {
                default: {
                    break block6;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.current = this.reader.read();
                    continue block6;
                }
            }
            break;
        }
        if (this.current == 44) {
            block7: while (true) {
                this.current = this.reader.read();
                switch (this.current) {
                    default: {
                        break block7;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block7;
                    }
                }
                break;
            }
        }
    }
}

