/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DummyNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeListIterator;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class LinkedNodeList
implements AbstractDOMNode.RawNodeList,
Serializable {
    private static final long serialVersionUID = 1L;
    private AbstractDOMNode firstNode = null;
    private AbstractDOMNode lastNode = null;

    LinkedNodeList() {
    }

    @Override
    public void add(AbstractDOMNode node) throws DOMException {
        if (this.lastNode != null) {
            this.lastNode.nextSibling = node;
            node.previousSibling = this.lastNode;
        } else {
            this.firstNode = node;
        }
        this.lastNode = node;
    }

    @Override
    public void clear() {
        AbstractDOMNode curnode = this.firstNode;
        while (curnode != null) {
            AbstractDOMNode next = curnode.nextSibling;
            curnode.nextSibling = null;
            curnode.previousSibling = null;
            curnode.setParentNode(null);
            curnode = next;
        }
        this.firstNode = null;
        this.lastNode = null;
    }

    @Override
    public boolean contains(Node node) {
        AbstractDOMNode curnode = this.firstNode;
        while (curnode != null) {
            if (curnode == node) {
                return true;
            }
            curnode = curnode.nextSibling;
        }
        return false;
    }

    @Override
    public void insertBefore(AbstractDOMNode newChild, AbstractDOMNode refChild) {
        AbstractDOMNode prev = refChild.previousSibling;
        newChild.nextSibling = refChild;
        newChild.previousSibling = prev;
        if (prev != null) {
            prev.nextSibling = newChild;
        } else {
            this.firstNode = newChild;
        }
        refChild.previousSibling = newChild;
    }

    @Override
    public DOMNode item(int index) {
        int i = 0;
        AbstractDOMNode node = this.firstNode;
        while (node != null) {
            if (i == index) {
                return node;
            }
            ++i;
            node = node.nextSibling;
        }
        return null;
    }

    @Override
    public AbstractDOMNode getFirst() {
        return this.firstNode;
    }

    @Override
    public AbstractDOMNode getLast() {
        return this.lastNode;
    }

    @Override
    public int indexOf(Node node) {
        int index = 0;
        AbstractDOMNode curnode = this.firstNode;
        while (curnode != null) {
            if (curnode == node) {
                return index;
            }
            ++index;
            curnode = curnode.nextSibling;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.firstNode == null;
    }

    @Override
    public int getLength() {
        int count = 0;
        AbstractDOMNode node = this.firstNode;
        while (node != null) {
            ++count;
            node = node.nextSibling;
        }
        return count;
    }

    @Override
    public Iterator<DOMNode> iterator() {
        return new ChildIterator();
    }

    public Iterator<DOMNode> createDescendingIterator() {
        return new DescendingChildIterator();
    }

    public Iterator<DOMNode> createIterator(BitSet whatToShow) {
        return new BitSetFilteredChildIterator(whatToShow);
    }

    public Iterator<DOMNode> createIterator(int whatToShow, NodeFilter filter) {
        if (filter == null) {
            return new MaskFilteredChildIterator(whatToShow);
        }
        return new CustomFilteredChildIterator(whatToShow, filter);
    }

    public NodeListIterator createListIterator() {
        return new ChildListIterator();
    }

    @Override
    public Iterator<DOMElement> elementIterator() {
        return new ElementIterator();
    }

    @Override
    public Iterator<DOMElement> elementIterator(String name) throws DOMException {
        if (name == null || name.length() == 0) {
            throw new DOMException(5, "Invalid tag name.");
        }
        return new ElementNameIterator(name);
    }

    @Override
    public Iterator<DOMElement> elementIteratorNS(String namespaceURI, String localName) {
        if (localName == null || localName.length() == 0) {
            throw new DOMException(5, "Invalid localName.");
        }
        return new ElementNameIteratorNS(namespaceURI, localName);
    }

    @Override
    public Iterator<Attr> attributeIterator() {
        return new AttributeIterator();
    }

    private void removeChild(AbstractDOMNode removed) {
        removed.removeFromParent(this);
        this.postRemoveChild(removed);
    }

    @Override
    public void remove(AbstractDOMNode node) {
        AbstractDOMNode prev = node.previousSibling;
        AbstractDOMNode next = node.nextSibling;
        if (this.lastNode == node) {
            this.lastNode = prev;
        } else {
            next.previousSibling = prev;
        }
        if (this.firstNode == node) {
            this.firstNode = next;
        } else {
            prev.nextSibling = next;
        }
        node.previousSibling = null;
        node.nextSibling = null;
    }

    @Override
    public AbstractDOMNode replace(AbstractDOMNode newChild, AbstractDOMNode oldChild) {
        AbstractDOMNode prev = oldChild.previousSibling;
        AbstractDOMNode next = oldChild.nextSibling;
        if (this.lastNode == oldChild) {
            this.lastNode = newChild;
        } else {
            next.previousSibling = newChild;
        }
        if (this.firstNode == oldChild) {
            this.firstNode = newChild;
        } else {
            prev.nextSibling = newChild;
        }
        newChild.previousSibling = prev;
        newChild.nextSibling = next;
        oldChild.previousSibling = null;
        oldChild.nextSibling = null;
        return oldChild;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        AbstractDOMNode node = this.firstNode;
        while (node != null) {
            buf.append(node.toString());
            node = node.nextSibling;
        }
        return buf.toString();
    }

    abstract void preAddChild(Node var1);

    abstract void postAddChild(AbstractDOMNode var1);

    abstract void replaceChild(Node var1, Node var2);

    abstract void postRemoveChild(AbstractDOMNode var1);

    private boolean isSameNamespace(String namespaceURI, AbstractDOMNode node) {
        String otherNamespaceURI = node.getNamespaceURI();
        if (namespaceURI == null) {
            return otherNamespaceURI == null || node.isDefaultNamespace(otherNamespaceURI);
        }
        return namespaceURI.equals(otherNamespaceURI);
    }

    private class ChildIterator
    implements Iterator<DOMNode> {
        private AbstractDOMNode currentNode;
        private AbstractDOMNode last;

        ChildIterator() {
            this.currentNode = LinkedNodeList.this.firstNode;
            this.last = null;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public DOMNode next() {
            if (this.hasNext()) {
                this.last = this.currentNode;
                this.currentNode = this.currentNode.nextSibling;
                return this.last;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedNodeList.this.removeChild(this.last);
            this.last = null;
        }
    }

    private class DescendingChildIterator
    implements Iterator<DOMNode> {
        AbstractDOMNode currentNode;
        private AbstractDOMNode last;

        DescendingChildIterator() {
            this.currentNode = LinkedNodeList.this.lastNode;
            this.last = null;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public DOMNode next() {
            if (this.hasNext()) {
                this.last = this.currentNode;
                this.currentNode = this.currentNode.previousSibling;
                return this.last;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedNodeList.this.removeChild(this.last);
            this.last = null;
        }
    }

    private class BitSetFilteredChildIterator
    extends FilteredChildIterator<DOMNode> {
        private final BitSet whatToShow;

        BitSetFilteredChildIterator(BitSet whatToShow) {
            this.whatToShow = whatToShow;
        }

        @Override
        public DOMNode next() {
            AbstractDOMNode next = this.findNext();
            if (next != null) {
                this.currentNode = next;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        boolean isToShow(Node node) {
            return this.whatToShow.get(node.getNodeType());
        }
    }

    private class MaskFilteredChildIterator
    extends FilteredChildIterator<DOMNode> {
        final int whatToShow;

        MaskFilteredChildIterator(int whatToShow) {
            this.whatToShow = whatToShow;
        }

        @Override
        public DOMNode next() {
            AbstractDOMNode next = this.findNext();
            if (next != null) {
                this.currentNode = next;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        boolean isToShow(Node node) {
            int maskBit = NodeFilter.maskTable[node.getNodeType() - 1];
            return (this.whatToShow & maskBit) == maskBit;
        }
    }

    private class CustomFilteredChildIterator
    extends MaskFilteredChildIterator {
        private final NodeFilter nodeFilter;

        CustomFilteredChildIterator(int whatToShow, NodeFilter filter) {
            super(whatToShow);
            this.nodeFilter = filter;
        }

        @Override
        boolean isToShow(Node node) {
            return super.isToShow(node) && this.nodeFilter.acceptNode(node) == 1;
        }
    }

    private class ChildListIterator
    implements NodeListIterator {
        private AbstractDOMNode currentNode;
        private AbstractDOMNode last;
        private int currentIndex;

        ChildListIterator() {
            this.currentNode = LinkedNodeList.this.firstNode;
            this.last = null;
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public DOMNode next() {
            if (this.hasNext()) {
                this.last = this.currentNode;
                this.currentNode = this.currentNode.nextSibling;
                ++this.currentIndex;
                return this.last;
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            if (this.currentNode != null) {
                return this.currentNode.previousSibling != null;
            }
            return LinkedNodeList.this.lastNode != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public DOMNode previous() {
            if (this.currentNode != null) {
                AbstractDOMNode pre = this.currentNode.previousSibling;
                if (pre == null) throw new NoSuchElementException();
                this.currentNode = pre;
            } else {
                if (LinkedNodeList.this.lastNode == null) throw new NoSuchElementException();
                this.currentNode = LinkedNodeList.this.lastNode;
            }
            this.last = this.currentNode;
            --this.currentIndex;
            return this.last;
        }

        @Override
        public int nextIndex() {
            return this.currentIndex;
        }

        @Override
        public int previousIndex() {
            return this.currentIndex - 1;
        }

        @Override
        public void remove() {
            if (this.last != null) {
                if (this.currentNode != null) {
                    if (this.currentNode != this.last) {
                        int index = this.currentIndex - 1;
                        if (index < 0 || this.last != LinkedNodeList.this.item(index)) {
                            throw new IllegalStateException();
                        }
                        this.currentIndex = index;
                    } else {
                        this.currentNode = this.last.nextSibling;
                    }
                    LinkedNodeList.this.removeChild(this.last);
                } else {
                    int index = this.currentIndex - 1;
                    DOMNode curnode = LinkedNodeList.this.item(index);
                    if (curnode != this.last) {
                        throw new IllegalStateException();
                    }
                    LinkedNodeList.this.removeChild(this.last);
                    this.currentIndex = index;
                }
            } else {
                throw new IllegalStateException();
            }
            this.last = null;
        }

        @Override
        public void set(Node node) {
            if (this.last != null) {
                LinkedNodeList.this.replaceChild(node, this.last);
                if (this.currentNode == this.last) {
                    this.currentNode = (AbstractDOMNode)node;
                }
            } else {
                throw new IllegalStateException();
            }
            this.last = null;
        }

        @Override
        public void add(Node node) {
            AbstractDOMNode newNode = (AbstractDOMNode)node;
            LinkedNodeList.this.preAddChild(newNode);
            if (this.currentNode != null) {
                LinkedNodeList.this.insertBefore(newNode, this.currentNode);
            } else {
                LinkedNodeList.this.add(newNode);
            }
            ++this.currentIndex;
            LinkedNodeList.this.postAddChild(newNode);
            this.last = null;
        }
    }

    private class ElementIterator
    extends FilteredChildIterator<DOMElement> {
        ElementIterator() {
        }

        @Override
        boolean isToShow(Node node) {
            return node.getNodeType() == 1;
        }
    }

    private class ElementNameIterator
    extends FilteredChildIterator<DOMElement> {
        private final String tagname;

        ElementNameIterator(String name) {
            this.tagname = name;
        }

        @Override
        boolean isToShow(Node node) {
            return node.getNodeType() == 1 && this.tagname.equals(node.getNodeName());
        }
    }

    private class ElementNameIteratorNS
    extends FilteredChildIterator<DOMElement> {
        private final String namespaceURI;
        private final String localName;

        ElementNameIteratorNS(String namespaceURI, String localName) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
        }

        @Override
        boolean isToShow(Node node) {
            DOMElement element;
            return node.getNodeType() == 1 && this.localName.equals((element = (DOMElement)node).getLocalName()) && LinkedNodeList.this.isSameNamespace(this.namespaceURI, element);
        }
    }

    private class AttributeIterator
    extends FilteredChildIterator<Attr> {
        AttributeIterator() {
        }

        @Override
        boolean isToShow(Node node) {
            return node.getNodeType() == 2;
        }

        @Override
        void removeItem(AbstractDOMNode node) {
            AbstractDOMNode owner = node.parentNode();
            if (owner == null) {
                throw new IllegalStateException();
            }
            owner.getAttributes().removeNamedItemNS(node.getNamespaceURI(), node.getLocalName());
        }
    }

    private abstract class FilteredChildIterator<T extends Node>
    implements Iterator<T> {
        AbstractDOMNode currentNode = null;

        private FilteredChildIterator() {
        }

        abstract boolean isToShow(Node var1);

        @Override
        public boolean hasNext() {
            return this.findNext() != null;
        }

        AbstractDOMNode findNext() {
            AbstractDOMNode next = this.currentNode;
            next = next == null ? LinkedNodeList.this.firstNode : next.nextSibling;
            while (next != null && !this.isToShow(next)) {
                next = next.nextSibling;
            }
            return next;
        }

        @Override
        public T next() {
            AbstractDOMNode next = this.findNext();
            if (next != null) {
                this.currentNode = next;
                return (T)next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            AbstractDOMNode removed;
            if (this.currentNode != null && this.currentNode.parentNode() != null) {
                removed = this.currentNode;
                this.currentNode = this.currentNode.previousSibling;
                if (this.currentNode != null) {
                    DummyNode dummy = new DummyNode();
                    dummy.nextSibling = removed.nextSibling;
                    dummy.previousSibling = this.currentNode;
                    this.currentNode = dummy;
                }
            } else {
                throw new IllegalStateException();
            }
            this.removeItem(removed);
        }

        void removeItem(AbstractDOMNode node) {
            LinkedNodeList.this.removeChild(node);
        }
    }
}

