/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.DefaultDeclarationFormattingContext;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.css.CSSRule;

public class DefaultStyleFormattingContext
extends DefaultDeclarationFormattingContext
implements StyleFormattingContext {
    private static final long serialVersionUID = 1L;
    private static final String indentingUnit = "    ";
    private final StringBuilder indentString = new StringBuilder(48);
    private CSSRule parentContextRule = null;

    @Override
    public void deepenCurrentContext() {
        this.indentString.append(indentingUnit);
    }

    @Override
    public void endCurrentContext(CSSRule rule) {
        this.updateIndentString(rule.getParentRule());
    }

    @Override
    public void endPropertyDeclaration(SimpleWriter wri) throws IOException {
        wri.newLine();
    }

    @Override
    public void endInlinePropertyDeclaration(SimpleWriter wri) throws IOException {
        wri.write(' ');
    }

    @Override
    public void endRule(SimpleWriter wri, List<String> trailingComments) throws IOException {
        if (trailingComments != null) {
            int nc = trailingComments.size();
            for (int j = 0; j < nc; ++j) {
                wri.write((CharSequence)" /*");
                wri.write((CharSequence)trailingComments.get(j));
                wri.write((CharSequence)"*/");
            }
        }
        wri.newLine();
    }

    @Override
    public void endRuleList(SimpleWriter wri) throws IOException {
        this.writeFullIndent(wri);
    }

    @Override
    public void endStyleDeclaration(SimpleWriter wri) throws IOException {
        this.writeFullIndent(wri);
    }

    @Override
    public void setParentContext(CSSRule rule) {
        this.parentContextRule = rule;
    }

    @Override
    public void startRule(SimpleWriter wri, List<String> precedingComments) throws IOException {
        if (precedingComments != null) {
            int nc = precedingComments.size();
            for (int j = 0; j < nc; ++j) {
                this.writeComment(wri, precedingComments.get(j));
            }
        }
        this.writeFullIndent(wri);
    }

    @Override
    public void startStyleDeclaration(SimpleWriter wri) throws IOException {
    }

    @Override
    public void updateContext(CSSRule rule) {
        this.updateIndentString(rule);
    }

    private void updateIndentString(CSSRule rule) {
        this.indentString.setLength(0);
        while (rule != this.parentContextRule) {
            this.deepenCurrentContext();
            rule = rule.getParentRule();
        }
    }

    @Override
    public void writeComment(SimpleWriter wri, String comment) throws IOException {
        this.writeFullIndent(wri);
        wri.write((CharSequence)"/*");
        wri.write((CharSequence)comment);
        wri.write((CharSequence)"*/");
        wri.newLine();
    }

    @Override
    public void writeFullIndent(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.indentString);
    }

    @Override
    public void writeImportantPriority(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)" ! important");
    }

    @Override
    public void writeLeftCurlyBracket(SimpleWriter wri) throws IOException {
        wri.write(' ');
        wri.write('{');
        wri.newLine();
    }

    @Override
    public void writeLevelIndent(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)indentingUnit);
    }

    @Override
    public void writeRightCurlyBracket(SimpleWriter wri) throws IOException {
        wri.write('}');
    }

    @Override
    public void writeSemiColon(SimpleWriter wri) throws IOException {
        wri.write(';');
    }

    @Override
    public void writeURL(SimpleWriter wri, String href) throws IOException {
        AbstractCSSRule rule;
        AbstractCSSStyleSheetFactory sf;
        int quote = 39;
        if (this.parentContextRule != null && (sf = (rule = (AbstractCSSRule)this.parentContextRule).getParentStyleSheet().getStyleSheetFactory()).hasFactoryFlag((short)2)) {
            quote = 34;
        }
        wri.write((CharSequence)"url(");
        String quoted = ParseHelper.quote(href, (char)quote);
        wri.write((CharSequence)quoted);
        wri.write(')');
    }
}

