/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSPageRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.MarginRule;
import io.sf.carte.doc.style.css.om.MarginRuleList;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.CommentRemover;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.w3c.dom.DOMException;

public class PageRule
extends BaseCSSDeclarationRule
implements CSSPageRule {
    private static final long serialVersionUID = 1L;
    private PageSelectorList selectorList = null;
    private MarginRuleList marginRules = null;

    public PageRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)6, origin);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(30 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0 || this.getStyle().getLength() != 0 || this.marginRules != null) {
            StringBuilder buf = new StringBuilder(96);
            buf.append("@page");
            if (seltext.length() != 0) {
                buf.append(' ').append(seltext);
            }
            String styleText = this.getStyle().getMinifiedCssText();
            buf.append('{').append(styleText);
            if (this.marginRules != null) {
                if (styleText.length() != 0) {
                    buf.append(';');
                }
                for (MarginRule rule : this.marginRules) {
                    buf.append(rule.getMinifiedCssText());
                }
            }
            buf.append('}');
            return buf.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0 || this.getStyle().getLength() != 0 || this.marginRules != null) {
            context.startRule(wri, this.getPrecedingComments());
            wri.write((CharSequence)"@page");
            if (seltext.length() != 0) {
                wri.write(' ');
                wri.write((CharSequence)seltext);
            }
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            context.startStyleDeclaration(wri);
            this.getStyle().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endStyleDeclaration(wri);
            if (this.marginRules != null) {
                context.updateContext(this);
                for (MarginRule rule : this.marginRules) {
                    rule.writeCssText(wri, context);
                }
                context.endCurrentContext(this);
                context.endRuleList(wri);
            }
            context.writeRightCurlyBracket(wri);
            context.endRule(wri, this.getTrailingComments());
        }
    }

    public PageSelectorList getSelectorList() {
        return this.selectorList;
    }

    void setSelectorList(PageSelectorList selectorList) {
        this.selectorList = selectorList;
    }

    @Override
    public String getSelectorText() {
        return this.selectorList == null ? "" : this.selectorList.toString();
    }

    @Override
    public void setSelectorText(String selectorText) throws DOMException {
        CSSParser parser = new CSSParser();
        this.selectorList = parser.parsePageSelectorList(selectorText);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        char c5;
        cssText = cssText.trim();
        int len = cssText.length();
        int idx = cssText.indexOf(123);
        int atIdx = cssText.indexOf(64);
        if (len < 10 || atIdx == -1) {
            throw new DOMException(12, "Invalid @page rule: " + cssText);
        }
        String ncText = CommentRemover.removeComments(cssText).toString().trim();
        CharSequence atkeyword = ncText.subSequence(0, 11);
        if (!ParseHelper.startsWithIgnoreCase(atkeyword, "@page") || !Character.isWhitespace(c5 = atkeyword.charAt(5)) && c5 != '{') {
            throw new DOMException(13, "Not a @page rule: " + cssText);
        }
        if (idx == -1) {
            throw new DOMException(12, "Invalid @page rule: " + cssText);
        }
        String body = cssText.substring(atIdx + 5, len);
        PageRuleHandler handler = new PageRuleHandler();
        handler.setLexicalPropertyListener(this.getLexicalPropertyListener());
        CSSParser parser = (CSSParser)this.createSACParser();
        parser.setDocumentHandler(handler);
        try {
            parser.parsePageRuleBody(body);
        }
        catch (CSSParseException e) {
            DOMException ex = new DOMException(5, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    void addMarginRule(MarginRule marginRule) {
        if (this.marginRules == null) {
            this.marginRules = new MarginRuleList(8);
        }
        this.marginRules.add(marginRule);
    }

    public MarginRuleList getMarginRules() {
        return this.marginRules;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.marginRules, this.selectorList);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageRule other = (PageRule)obj;
        return Objects.equals(this.marginRules, other.marginRules) && Objects.equals(this.selectorList, other.selectorList);
    }

    @Override
    public PageRule clone(AbstractCSSStyleSheet parentSheet) {
        PageRule clon = new PageRule(parentSheet, this.getOrigin());
        clon.selectorList = this.selectorList;
        if (this.marginRules != null) {
            clon.marginRules = new MarginRuleList(this.marginRules.size());
            Iterator it = this.marginRules.iterator();
            while (it.hasNext()) {
                clon.marginRules.add(((MarginRule)it.next()).clone(parentSheet));
            }
        }
        String oldHrefContext = this.getParentStyleSheet().getHref();
        clon.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        return clon;
    }

    private class PageRuleHandler
    extends BaseCSSDeclarationRule.DeclarationRuleCSSHandler {
        private MarginRule currentMarginRule = null;

        private PageRuleHandler() {
        }

        @Override
        public void startPage(PageSelectorList pageSelectorList) {
            PageRule.this.selectorList = pageSelectorList;
        }

        @Override
        public void endPage(PageSelectorList pageSelectorList) {
        }

        @Override
        public void startMargin(String name) {
            this.currentMarginRule = new MarginRule(PageRule.this.getParentStyleSheet(), PageRule.this.getOrigin(), name);
            this.currentMarginRule.setParentRule(PageRule.this);
            this.setLexicalPropertyListener(this.currentMarginRule.getLexicalPropertyListener());
        }

        @Override
        public void endMargin() {
            PageRule.this.addMarginRule(this.currentMarginRule);
            this.currentMarginRule = null;
            this.setLexicalPropertyListener(PageRule.this.getLexicalPropertyListener());
        }

        @Override
        public void warning(CSSParseException exception) throws CSSParseException {
            if (PageRule.this.selectorList != null) {
                super.warning(exception);
            } else {
                AbstractCSSStyleSheet sheet = PageRule.this.getParentStyleSheet();
                if (sheet != null) {
                    sheet.getErrorHandler().ruleParseWarning(PageRule.this, exception);
                }
            }
        }

        @Override
        public void error(CSSParseException exception) throws CSSParseException {
            if (PageRule.this.selectorList != null) {
                super.error(exception);
            } else {
                AbstractCSSStyleSheet sheet = PageRule.this.getParentStyleSheet();
                if (sheet != null) {
                    sheet.getErrorHandler().ruleParseError(PageRule.this, exception);
                }
            }
        }
    }
}

