/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Locator;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSParentHandler;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.CounterStyleRule;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.FontFeatureValuesRule;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.ImportRule;
import io.sf.carte.doc.style.css.om.KeyframeRule;
import io.sf.carte.doc.style.css.om.KeyframesRule;
import io.sf.carte.doc.style.css.om.MarginRule;
import io.sf.carte.doc.style.css.om.MediaRule;
import io.sf.carte.doc.style.css.om.NamespaceRule;
import io.sf.carte.doc.style.css.om.PageRule;
import io.sf.carte.doc.style.css.om.PropertyRule;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.om.SupportsRule;
import io.sf.carte.doc.style.css.om.UnknownRule;
import io.sf.carte.doc.style.css.om.ViewportRule;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import java.util.LinkedList;
import org.w3c.dom.DOMException;

class SheetHandler
implements CSSParentHandler,
CSSErrorHandler,
Parser.NamespaceMap {
    private ParserControl parserctl = null;
    private final BaseCSSStyleSheet parentSheet;
    private AbstractCSSRule currentRule = null;
    private AbstractCSSRule lastRule = null;
    private final byte sheetOrigin;
    private final LinkedList<String> comments;
    private final boolean allCommentsPrecede;
    private short ignoreGroupingRules = 0;
    private boolean ignoreImports = false;
    private CSSParseException outOfRuleException = null;

    SheetHandler(BaseCSSStyleSheet sheet, byte origin, short commentsMode) {
        this.parentSheet = sheet;
        this.sheetOrigin = origin;
        this.comments = commentsMode != 0 ? new LinkedList() : null;
        this.allCommentsPrecede = commentsMode != 2;
    }

    @Override
    public void parseStart(ParserControl parserctl) {
        this.currentRule = null;
        this.parserctl = parserctl;
        this.ignoreGroupingRules = 0;
        this.ignoreImports = false;
        this.resetCommentStack();
    }

    @Override
    public void endOfStream() {
        this.resetCommentStack();
        this.parserctl = null;
    }

    @Override
    public void comment(String text, boolean precededByLF) {
        if (this.comments != null) {
            if (this.lastRule != null && !precededByLF && !this.allCommentsPrecede) {
                BaseCSSRule rule = (BaseCSSRule)this.lastRule;
                if (rule.getTrailingComments() == null) {
                    rule.setTrailingComments(new LinkedStringList());
                }
                rule.getTrailingComments().add(text);
            } else {
                this.comments.add(text);
            }
        }
    }

    @Override
    public void ignorableAtRule(String atRule) {
        int tentNameLen = atRule.length();
        if (tentNameLen > 21) {
            tentNameLen = 21;
        }
        this.newRule();
        UnknownRule rule = this.parentSheet.createUnknownRule();
        if (atRule.charAt(1) != '-') {
            this.parentSheet.getErrorHandler().unknownRule(atRule);
        }
        try {
            rule.setRuleCssText(atRule);
        }
        catch (DOMException e) {
            this.parentSheet.getErrorHandler().badAtRule(e, atRule);
            return;
        }
        this.setCommentsToRule(rule);
        if (this.currentRule != null) {
            this.addToCurrentRule(rule);
        } else {
            this.addLocalRule(rule);
            this.resetCurrentRule();
        }
        this.lastRule = rule;
    }

    private void newRule() {
        this.lastRule = null;
    }

    protected void addLocalRule(AbstractCSSRule rule) {
        this.parentSheet.addLocalRule(rule);
    }

    private void addToCurrentRule(AbstractCSSRule rule) {
        try {
            ((GroupingRule)this.currentRule).addRule(rule);
        }
        catch (ClassCastException e) {
            DOMException ex = new DOMException(12, "Found @-rule inside a non-grouping rule of type: " + this.currentRule.getType());
            this.parentSheet.getErrorHandler().badAtRule(ex, rule.getCssText());
            this.lastRule = null;
        }
    }

    @Override
    public void namespaceDeclaration(String prefix, String uri) {
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            this.parentSheet.setNamespace(prefix, uri);
            NamespaceRule rule = this.parentSheet.createNamespaceRule(prefix, uri);
            if (this.currentRule != null) {
                this.addToCurrentRule(rule);
            } else {
                this.addLocalRule(rule);
            }
            this.resetCurrentRule();
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void importStyle(String uri, MediaQueryList media, String defaultNamespaceURI) {
        if (this.ignoreImports) {
            SheetErrorHandler eh = this.parentSheet.getErrorHandler();
            eh.ignoredImport(uri);
            this.resetCommentStack();
            return;
        }
        if (this.parentSheet.match(this.parentSheet.getMedia(), media)) {
            if (!media.isNotAllMedia()) {
                if (this.currentRule == null) {
                    ImportRule imp = this.parentSheet.createImportRule(media, uri);
                    this.setCommentsToRule(imp);
                    this.addLocalRule(imp);
                }
            } else {
                this.parentSheet.getErrorHandler().badMediaList(media);
            }
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void startSupports(BooleanCondition condition) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            if (this.currentRule != null) {
                short ruleType = this.currentRule.getType();
                if (ruleType == 4 || ruleType == 12) {
                    SupportsRule rule = new SupportsRule((AbstractCSSStyleSheet)this.parentSheet, condition, this.sheetOrigin);
                    this.addToCurrentRule(rule);
                    this.currentRule = rule;
                    this.setCommentsToRule(this.currentRule);
                } else {
                    SheetErrorHandler eh = this.parentSheet.getErrorHandler();
                    if (eh != null) {
                        eh.sacMalfunction("Unexpected supports rule inside of: " + this.currentRule.getCssText());
                        this.ignoreGroupingRules = 1;
                    }
                }
            } else {
                this.currentRule = new SupportsRule((AbstractCSSStyleSheet)this.parentSheet, condition, this.sheetOrigin);
                this.setCommentsToRule(this.currentRule);
            }
        } else {
            this.ignoreGroupingRules = (short)(this.ignoreGroupingRules + 1);
        }
    }

    @Override
    public void endSupports(BooleanCondition condition) {
        this.endGroupingRule();
    }

    void endGroupingRule() {
        if (this.ignoreGroupingRules != 0) {
            this.ignoreGroupingRules = (short)(this.ignoreGroupingRules - 1);
            this.resetCommentStack();
        } else if (this.currentRule != null) {
            this.lastRule = this.currentRule;
            AbstractCSSRule pRule = this.currentRule.getParentRule();
            if (pRule == null) {
                this.addLocalRule(this.currentRule);
                this.resetCurrentRule();
            } else {
                this.resetCurrentRule();
                this.currentRule = pRule;
            }
        }
    }

    @Override
    public void startMedia(MediaQueryList media) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            if (this.currentRule != null) {
                short ruleType = this.currentRule.getType();
                if (ruleType == 4 || ruleType == 12) {
                    MediaRule rule = new MediaRule((AbstractCSSStyleSheet)this.parentSheet, media, this.sheetOrigin);
                    this.addToCurrentRule(rule);
                    this.currentRule = rule;
                    this.setCommentsToRule(this.currentRule);
                } else {
                    SheetErrorHandler eh = this.parentSheet.getErrorHandler();
                    if (eh != null) {
                        eh.sacMalfunction("Unexpected media rule inside of: " + this.currentRule.getCssText());
                        this.ignoreGroupingRules = 1;
                    }
                }
            } else {
                this.currentRule = new MediaRule((AbstractCSSStyleSheet)this.parentSheet, media, this.sheetOrigin);
                this.setCommentsToRule(this.currentRule);
            }
        } else {
            this.ignoreGroupingRules = (short)(this.ignoreGroupingRules + 1);
        }
    }

    @Override
    public void endMedia(MediaQueryList media) {
        this.endGroupingRule();
    }

    @Override
    public void startPage(PageSelectorList pageSelectorList) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            PageRule pageRule = this.parentSheet.createPageRule();
            pageRule.setParentRule(this.currentRule);
            pageRule.setSelectorList(pageSelectorList);
            this.currentRule = pageRule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endPage(PageSelectorList pageSelectorList) {
        this.endGenericRule();
    }

    @Override
    public void startMargin(String name) {
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            assert (this.currentRule != null && this.currentRule.getType() == 6);
            MarginRule marginRule = this.parentSheet.createMarginRule(name);
            marginRule.setParentRule(this.currentRule);
            this.currentRule = marginRule;
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endMargin() {
        if (this.ignoreGroupingRules == 0) {
            assert (this.currentRule != null && this.currentRule.getType() == 9);
            this.lastRule = this.currentRule;
            AbstractCSSRule pRule = this.currentRule.getParentRule();
            PageRule pageRule = (PageRule)pRule;
            pageRule.addMarginRule((MarginRule)this.currentRule);
            this.currentRule = pRule;
        }
        this.resetCommentStack();
    }

    @Override
    public void startFontFace() {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            FontFaceRule rule = new FontFaceRule(this.parentSheet, this.sheetOrigin);
            rule.setParentRule(this.currentRule);
            this.currentRule = rule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endFontFace() {
        this.endGenericRule();
    }

    private void endGenericRule() {
        if (this.ignoreGroupingRules == 0) {
            if (this.currentRule != null) {
                this.lastRule = this.currentRule;
                AbstractCSSRule pRule = this.currentRule.getParentRule();
                if (pRule == null) {
                    this.addLocalRule(this.currentRule);
                    this.resetCurrentRule();
                } else {
                    this.addCurrentRuleToRule(pRule);
                    this.resetCommentStack();
                    this.currentRule = pRule;
                }
            }
        } else {
            this.resetCommentStack();
        }
    }

    private void addCurrentRuleToRule(AbstractCSSRule rule) {
        try {
            ((GroupingRule)rule).addRule(this.currentRule);
        }
        catch (ClassCastException e) {
            DOMException ex = new DOMException(12, "Found @-rule inside a non-grouping rule of type: " + rule.getType());
            this.parentSheet.getErrorHandler().badAtRule(ex, this.currentRule.getCssText());
        }
    }

    @Override
    public void startCounterStyle(String name) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            CounterStyleRule rule = this.parentSheet.createCounterStyleRule(name);
            rule.setParentRule(this.currentRule);
            this.currentRule = rule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endCounterStyle() {
        this.endGenericRule();
    }

    @Override
    public void startKeyframes(String name) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            KeyframesRule rule = this.parentSheet.createKeyframesRule(name);
            rule.setParentRule(this.currentRule);
            this.currentRule = rule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endKeyframes() {
        this.endGenericRule();
    }

    @Override
    public void startKeyframe(LexicalUnit keyframeSelector) {
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            KeyframesRule kfs = (KeyframesRule)this.currentRule;
            KeyframeRule rule = new KeyframeRule(kfs);
            rule.setKeyText(KeyframesRule.keyframeSelector(keyframeSelector));
            kfs.getCssRules().add(rule);
            this.currentRule = rule;
            this.setCommentsToRule(this.currentRule);
        }
    }

    @Override
    public void endKeyframe() {
        if (this.ignoreGroupingRules == 0) {
            assert (this.currentRule != null && this.currentRule.getType() == 8);
            this.lastRule = this.currentRule;
            this.currentRule = this.currentRule.getParentRule();
        }
        this.resetCommentStack();
    }

    @Override
    public void startFontFeatures(String[] familyName) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            FontFeatureValuesRule rule = this.parentSheet.createFontFeatureValuesRule(familyName);
            rule.setParentRule(this.currentRule);
            this.currentRule = rule;
            this.setCommentsToRule(this.currentRule);
            CSSHandler ffhandler = rule.createFontFeatureValuesHandler(this, this.parserctl);
            ffhandler.startFontFeatures(familyName);
            this.parserctl.setDocumentHandler(ffhandler);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endFontFeatures() {
        throw new IllegalStateException();
    }

    @Override
    public void startFeatureMap(String mapName) {
        throw new IllegalStateException();
    }

    @Override
    public void endFeatureMap() {
        throw new IllegalStateException();
    }

    @Override
    public void endSubHandler(short handlerId) {
        this.parserctl.setDocumentHandler(this);
        this.endGenericRule();
    }

    @Override
    public void startProperty(String name) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            PropertyRule rule = this.parentSheet.createPropertyRule(name);
            rule.setParentRule(this.currentRule);
            this.currentRule = rule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endProperty(boolean discard) {
        if (discard) {
            this.discardGenericRule();
        } else {
            this.endGenericRule();
        }
    }

    private void discardGenericRule() {
        if (this.ignoreGroupingRules == 0 && this.currentRule != null) {
            this.currentRule = this.currentRule.getParentRule();
        }
        this.resetCommentStack();
    }

    @Override
    public void startViewport() {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            ViewportRule rule = this.parentSheet.createViewportRule();
            rule.setParentRule(this.currentRule);
            this.currentRule = rule;
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endViewport() {
        this.endGenericRule();
    }

    @Override
    public void startSelector(SelectorList selectors) {
        this.ignoreImports = true;
        this.newRule();
        if (this.ignoreGroupingRules == 0) {
            StyleRule styleRule = this.parentSheet.createStyleRule();
            if (this.currentRule != null) {
                styleRule.setParentRule(this.currentRule);
            }
            this.currentRule = styleRule;
            ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectors);
            this.setCommentsToRule(this.currentRule);
        } else {
            this.resetCommentStack();
        }
    }

    @Override
    public void endSelector(SelectorList selectors) {
        if (this.ignoreGroupingRules == 0) {
            assert (this.currentRule != null && this.currentRule.getType() == 1);
            this.lastRule = this.currentRule;
            BaseCSSRule pRule = (BaseCSSRule)this.currentRule.getParentRule();
            if (((StyleRule)this.currentRule).getStyle().getLength() == 0) {
                SheetErrorHandler eh = this.parentSheet.getErrorHandler();
                eh.emptyStyleRule(((StyleRule)this.currentRule).getSelectorText());
            } else if (pRule == null) {
                if (this.currentRule != null) {
                    this.addLocalRule(this.currentRule);
                }
            } else {
                ((GroupingRule)pRule).addRule(this.currentRule);
            }
            this.currentRule = pRule;
        }
        this.resetCommentStack();
    }

    @Override
    public void property(String name, LexicalUnit value, boolean important) {
        if (this.ignoreGroupingRules == 0) {
            if (this.currentRule != null) {
                try {
                    ((BaseCSSDeclarationRule)this.currentRule).getStyle().setProperty(name, value, important);
                }
                catch (RuntimeException e) {
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(value.toString());
                    ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().wrongValue(name, ex);
                    Locator locator = this.parserctl.createLocator();
                    CSSParseException pe = new CSSParseException("Invalid value for property " + name, locator, e);
                    this.error(pe);
                }
            } else {
                this.parentSheet.getErrorHandler().sacMalfunction("Unexpected property " + name + ": " + value.toString());
            }
        }
    }

    @Override
    public void lexicalProperty(String name, LexicalUnit lunit, boolean important) {
        if (this.ignoreGroupingRules == 0) {
            if (this.currentRule != null) {
                try {
                    ((BaseCSSDeclarationRule)this.currentRule).getStyle().setLexicalProperty(name, lunit, important);
                }
                catch (RuntimeException e) {
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(lunit.toString());
                    ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().wrongValue(name, ex);
                    Locator locator = this.parserctl.createLocator();
                    CSSParseException pe = new CSSParseException("Invalid value for property " + name, locator, e);
                    this.error(pe);
                }
            } else {
                this.parentSheet.getErrorHandler().sacMalfunction("Unexpected property " + name + ": " + lunit.toString());
            }
        }
    }

    private void resetCurrentRule() {
        this.currentRule = null;
        this.resetCommentStack();
    }

    private void setCommentsToRule(AbstractCSSRule rule) {
        if (this.comments != null && !this.comments.isEmpty()) {
            LinkedStringList ruleComments = new LinkedStringList();
            ruleComments.addAll(this.comments);
            rule.setPrecedingComments(ruleComments);
        }
        this.resetCommentStack();
    }

    private void resetCommentStack() {
        if (this.comments != null) {
            this.comments.clear();
        }
    }

    @Override
    public String getNamespaceURI(String nsPrefix) {
        return this.parentSheet.getNamespaceURI(nsPrefix);
    }

    public BaseCSSStyleSheet getStyleSheet() {
        return this.parentSheet;
    }

    @Override
    public void warning(CSSParseException exception) throws CSSParseException {
        if (this.currentRule instanceof BaseCSSDeclarationRule && ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
            int previousIndex = -1;
            AbstractCSSStyleDeclaration style = ((BaseCSSDeclarationRule)this.currentRule).getStyle();
            if (style != null) {
                previousIndex = style.getLength() - 1;
            }
            ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().sacWarning(exception, previousIndex);
        } else {
            this.parentSheet.getErrorHandler().handleSacWarning(exception);
        }
    }

    @Override
    public void error(CSSParseException exception) throws CSSParseException {
        if (this.currentRuleCanHandleError()) {
            int previousIndex = -1;
            AbstractCSSStyleDeclaration style = ((BaseCSSDeclarationRule)this.currentRule).getStyle();
            if (style != null) {
                previousIndex = style.getLength() - 1;
            }
            ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().sacError(exception, previousIndex);
            this.parentSheet.getErrorHandler().mapError(exception, this.currentRule);
        } else {
            this.nonRuleErrorHandling(exception);
        }
    }

    private boolean currentRuleCanHandleError() {
        return this.currentRule instanceof BaseCSSDeclarationRule && ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler() != null;
    }

    private void nonRuleErrorHandling(CSSParseException exception) {
        this.parentSheet.getErrorHandler().handleSacError(exception);
        if (this.outOfRuleException == null) {
            this.outOfRuleException = exception;
        }
    }

    CSSParseException getOutOfRuleException() {
        return this.outOfRuleException;
    }
}

