/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MathFunctionUnitImpl;
import java.util.Locale;
import org.w3c.dom.DOMException;

class DimensionalAnalyzer {
    private boolean attrPending;

    public boolean isAttrPending() {
        return this.attrPending;
    }

    public Dimension expressionDimension(LexicalUnitImpl lunit) throws DOMException {
        Dimension sum = null;
        Dimension dim = null;
        Ops operation = Ops.ADD;
        while (lunit != null) {
            LexicalUnit.LexicalType sacType = lunit.getLexicalUnitType();
            switch (sacType) {
                case DIMENSION: {
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = DimensionalAnalyzer.createDimension(lunit.getCssUnit());
                            break;
                        }
                        case 1: {
                            dim = dim.multiplyByUnit(lunit.getCssUnit());
                            break;
                        }
                        case 2: {
                            dim = dim.divideByUnit(lunit.getCssUnit());
                        }
                    }
                    break;
                }
                case IDENT: {
                    String cons = lunit.getStringValue().toLowerCase(Locale.ROOT);
                    if (!"pi".equals(cons) && !"e".equals(cons)) {
                        throw new DOMException(15, "Invalid identifier in expression: " + lunit.getCssText());
                    }
                }
                case REAL: {
                    if (operation != Ops.ADD) break;
                    dim = new Dimension();
                    dim.category = CSSValueSyntax.Category.number;
                    break;
                }
                case INTEGER: {
                    if (operation != Ops.ADD) break;
                    dim = new Dimension();
                    dim.category = CSSValueSyntax.Category.integer;
                    break;
                }
                case PERCENTAGE: {
                    this.attrPending = false;
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = DimensionalAnalyzer.createDimension((short)2);
                            break;
                        }
                        case 1: {
                            dim = dim.multiplyByUnit((short)2);
                            break;
                        }
                        case 2: {
                            dim = dim.divideByUnit((short)2);
                        }
                    }
                    break;
                }
                case CALC: 
                case SUB_EXPRESSION: {
                    Dimension expdim = this.expressionDimension(lunit.parameters);
                    if (expdim == null) {
                        return null;
                    }
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = expdim;
                            break;
                        }
                        case 1: {
                            dim = dim.multiply(expdim);
                            break;
                        }
                        case 2: {
                            dim = dim.divide(expdim);
                        }
                    }
                    break;
                }
                case VAR: {
                    return null;
                }
                case MATH_FUNCTION: {
                    Dimension funcdim = ((MathFunctionUnitImpl)lunit).dimension(this);
                    if (funcdim == null) {
                        return null;
                    }
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = funcdim;
                            break;
                        }
                        case 1: {
                            dim = dim.multiply(funcdim);
                            break;
                        }
                        case 2: {
                            dim = dim.divide(funcdim);
                        }
                    }
                    break;
                }
                case OPERATOR_PLUS: 
                case OPERATOR_MINUS: {
                    if (sum == null) {
                        sum = dim;
                    } else {
                        sum.sum(dim);
                    }
                    operation = Ops.ADD;
                    break;
                }
                case OPERATOR_MULTIPLY: {
                    operation = Ops.MULT;
                    break;
                }
                case OPERATOR_SLASH: {
                    operation = Ops.DIV;
                    break;
                }
                case ATTR: {
                    Dimension attrdim = this.attrDimension(lunit.parameters);
                    if (attrdim == null) {
                        return null;
                    }
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = attrdim;
                            break;
                        }
                        case 1: {
                            dim = dim.multiply(attrdim);
                            break;
                        }
                        case 2: {
                            dim = dim.divide(attrdim);
                        }
                    }
                    break;
                }
                default: {
                    throw new DOMException(15, "Invalid unit in expression: " + lunit.getCssText());
                }
            }
            lunit = lunit.nextLexicalUnit;
        }
        if (sum != null) {
            if (!sum.sum(dim)) {
                throw new DOMException(15, "Invalid attempt to sum " + sum + " and " + dim);
            }
        } else {
            sum = dim;
        }
        return sum;
    }

    private Dimension attrDimension(LexicalUnitImpl param) throws DOMException {
        LexicalUnitImpl lunit = param.nextLexicalUnit;
        if (lunit != null) {
            Dimension dimfb;
            Dimension dim = DimensionalAnalyzer.typeSpecDimension(lunit);
            if (dim == null || dim.category != CSSValueSyntax.Category.length && dim.category != CSSValueSyntax.Category.percentage || (lunit = lunit.nextLexicalUnit) == null || lunit.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA || (lunit = lunit.nextLexicalUnit) == null) {
                return dim;
            }
            try {
                dimfb = this.expressionDimension(lunit);
            }
            catch (DOMException e) {
                return dim;
            }
            if (dimfb != null && dim.category != dimfb.category) {
                this.attrPending = dim.sum(dimfb);
                dim.lengthProcessed = false;
                dim.percentageProcessed = false;
            }
            return dim;
        }
        throw new DOMException(15, "Invalid attr() in expression: " + param.getCssText());
    }

    private static Dimension typeSpecDimension(LexicalUnitImpl param) {
        switch (param.getLexicalUnitType()) {
            case TYPE_FUNCTION: {
                LexicalUnit typeParam = param.getParameters();
                if (typeParam == null) break;
                Dimension dim = new Dimension();
                dim.category = typeParam.getSyntax().getCategory();
                if (dim.category != CSSValueSyntax.Category.number && dim.category != CSSValueSyntax.Category.integer) {
                    dim.exponent = 1;
                }
                return dim;
            }
            case IDENT: {
                String s = param.getStringValue().toLowerCase(Locale.ROOT);
                return DimensionalAnalyzer.createDimension(UnitStringToId.unitFromString(s));
            }
            case OPERATOR_MOD: {
                Dimension dim = new Dimension();
                dim.category = CSSValueSyntax.Category.percentage;
                dim.exponent = 1;
                return dim;
            }
            case VAR: {
                return null;
            }
        }
        throw new DOMException(15, "Invalid attr() in expression: " + param.getCssText());
    }

    private static Dimension createDimension(short unit) throws DOMException {
        Dimension dim = new Dimension();
        if (unit == 0) {
            dim.category = CSSValueSyntax.Category.number;
            dim.exponent = 0;
            return dim;
        }
        dim.exponent = 1;
        if (CSSUnit.isLengthUnitType(unit)) {
            dim.category = CSSValueSyntax.Category.length;
            dim.lengthProcessed = true;
        } else if (unit == 2) {
            dim.category = CSSValueSyntax.Category.percentage;
            dim.percentageProcessed = true;
        } else if (CSSUnit.isAngleUnitType(unit)) {
            dim.category = CSSValueSyntax.Category.angle;
        } else if (CSSUnit.isTimeUnitType(unit)) {
            dim.category = CSSValueSyntax.Category.time;
        } else if (CSSUnit.isResolutionUnitType(unit)) {
            dim.category = CSSValueSyntax.Category.resolution;
        } else if (unit == 100 || unit == 101) {
            dim.category = CSSValueSyntax.Category.frequency;
        } else if (unit == 70) {
            dim.category = CSSValueSyntax.Category.flex;
        } else {
            throw new DOMException(15, "Invalid unit: " + unit);
        }
        return dim;
    }

    private static enum Ops {
        ADD,
        MULT,
        DIV;

    }
}

