/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.AngleFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MultiArgScalingFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.PowFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.RoundFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ScalingFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.SqrtFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.UnitlessFunctionUnitImpl;
import java.util.HashMap;
import java.util.Map;

class FunctionFactories {
    private static final Map<String, CSSParser.LexicalUnitFactory> factories = FunctionFactories.createFactoryMap();

    FunctionFactories() {
    }

    private static Map<String, CSSParser.LexicalUnitFactory> createFactoryMap() {
        HashMap<String, CSSParser.LexicalUnitFactory> factories = new HashMap<String, CSSParser.LexicalUnitFactory>(45);
        factories.put("calc", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.CALC);
            }
        });
        factories.put("attr", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.ATTR);
            }
        });
        factories.put("type", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.TYPE_FUNCTION);
            }
        });
        factories.put("var", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.VAR);
            }
        });
        factories.put("url", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.URI);
            }
        });
        factories.put("src", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.SRC);
            }
        });
        factories.put("element", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.ELEMENT_REFERENCE);
            }
        });
        factories.put("rect", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.RECT_FUNCTION);
            }
        });
        factories.put("counter", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.COUNTER_FUNCTION);
            }
        });
        factories.put("counters", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.COUNTERS_FUNCTION);
            }
        });
        factories.put("cubic-bezier", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.CUBIC_BEZIER_FUNCTION);
            }
        });
        factories.put("steps", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.STEPS_FUNCTION);
            }
        });
        CSSParser.LexicalUnitFactory rgb = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.RGBCOLOR);
            }
        };
        factories.put("rgb", rgb);
        factories.put("rgba", rgb);
        CSSParser.LexicalUnitFactory hsl = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.HSLCOLOR);
            }
        };
        factories.put("hsl", hsl);
        factories.put("hsla", hsl);
        factories.put("lab", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.LABCOLOR);
            }
        });
        factories.put("lch", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.LCHCOLOR);
            }
        });
        factories.put("oklab", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.OKLABCOLOR);
            }
        });
        factories.put("oklch", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.OKLCHCOLOR);
            }
        });
        factories.put("hwb", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.HWBCOLOR);
            }
        });
        factories.put("color", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.COLOR_FUNCTION);
            }
        });
        factories.put("color-mix", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.COLOR_MIX);
            }
        });
        factories.put("abs", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ScalingFunctionUnitImpl(0);
            }
        });
        factories.put("clamp", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(1);
            }
        });
        factories.put("max", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(2);
            }
        });
        factories.put("min", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(3);
            }
        });
        factories.put("round", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new RoundFunctionUnitImpl(4);
            }
        });
        factories.put("mod", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(5);
            }
        });
        factories.put("rem", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(6);
            }
        });
        factories.put("hypot", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(7);
            }
        });
        factories.put("hypot2", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(8);
            }
        });
        factories.put("log", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(9);
            }
        });
        factories.put("exp", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(10);
            }
        });
        factories.put("sqrt", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new SqrtFunctionUnitImpl(11);
            }
        });
        factories.put("pow", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new PowFunctionUnitImpl(12);
            }
        });
        factories.put("sign", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(13);
            }
        });
        factories.put("sin", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(14);
            }
        });
        factories.put("cos", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(15);
            }
        });
        factories.put("tan", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(16);
            }
        });
        factories.put("asin", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(17);
            }
        });
        factories.put("acos", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(18);
            }
        });
        factories.put("atan", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(19);
            }
        });
        factories.put("atan2", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(20);
            }
        });
        return factories;
    }

    public static CSSParser.LexicalUnitFactory getFactory(String lcFunctionName) {
        return factories.get(lcFunctionName);
    }
}

