/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.color.Illuminants;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.jclf.math.linear3.Matrices;
import org.w3c.dom.DOMException;

class ColorUtil {
    ColorUtil() {
    }

    static double hueRadians(CSSTypedValue primihue) {
        float h;
        short unit = primihue.getUnitType();
        if (unit == 0) {
            h = primihue.getFloatValue((short)0);
            h = NumberValue.floatValueConversion(h, (short)80, (short)81);
        } else {
            try {
                h = primihue.getFloatValue((short)81);
            }
            catch (DOMException e) {
                if (primihue.getPrimitiveType() == CSSValue.Type.IDENT) {
                    h = 0.0f;
                }
                throw e;
            }
        }
        double dh = h;
        double TWOPI = Math.PI * 2;
        if (Math.abs(dh) > Math.PI * 2) {
            dh = Math.IEEEremainder(dh, Math.PI * 2);
        }
        if (dh < 0.0) {
            dh += Math.PI * 2;
        }
        return dh;
    }

    static double hueDegrees(CSSTypedValue primihue) {
        float h;
        short unit = primihue.getUnitType();
        if (unit == 0) {
            h = primihue.getFloatValue((short)0);
        } else {
            try {
                h = primihue.getFloatValue((short)80);
            }
            catch (DOMException e) {
                if (primihue.getPrimitiveType() == CSSValue.Type.IDENT) {
                    h = 0.0f;
                }
                throw e;
            }
        }
        double dh = h;
        if (Math.abs(dh) > 360.0) {
            dh = Math.IEEEremainder(dh, 360.0);
        }
        if (dh < 0.0) {
            dh += 360.0;
        }
        return dh;
    }

    static double floatPercent(CSSTypedValue typed) {
        double pcnt;
        short unit = typed.getUnitType();
        if (unit == 2) {
            pcnt = typed.getFloatValue((short)2);
        } else if (unit == 0) {
            pcnt = typed.getFloatValue((short)0);
        } else if (typed.getPrimitiveType() == CSSValue.Type.IDENT) {
            pcnt = 0.0;
        } else {
            throw new DOMException(17, "Wrong component: " + typed.getCssText());
        }
        return pcnt;
    }

    static float fraction(CSSTypedValue typed) {
        float pcnt;
        short unit = typed.getUnitType();
        if (unit == 2) {
            pcnt = typed.getFloatValue((short)2);
        } else if (unit == 0) {
            pcnt = typed.getFloatValue((short)0);
        } else if (typed.getPrimitiveType() == CSSValue.Type.IDENT) {
            pcnt = 0.0f;
        } else {
            throw new DOMException(17, "Wrong component: " + typed.getCssText());
        }
        return pcnt * 0.01f;
    }

    static float floatNumber(CSSTypedValue typed) {
        float value;
        if (typed.getUnitType() == 0) {
            value = typed.getFloatValue((short)0);
        } else if (typed.getPrimitiveType() == CSSValue.Type.IDENT) {
            value = 0.0f;
        } else {
            throw new DOMException(17, "Wrong component: " + typed.getCssText());
        }
        return value;
    }

    static double[] srgbToHsl(double r, double g, double b) {
        double h;
        double max;
        boolean maxr = false;
        boolean maxg = false;
        if (g > r) {
            max = g;
            maxg = true;
        } else {
            max = r;
            maxr = true;
        }
        if (b > max) {
            max = b;
            maxr = false;
            maxg = false;
        }
        double min = Math.min(r, g);
        if (max == (min = Math.min(min, b))) {
            h = 0.0;
        } else if (maxr) {
            h = (g - b) / (max - min) * 60.0 + 360.0;
            if ((h = Math.IEEEremainder(h, 360.0)) < 0.0) {
                h += 360.0;
            }
        } else if (maxg) {
            h = (b - r) / (max - min) * 60.0 + 120.0;
            if (h < 0.0) {
                h += 360.0;
            }
        } else {
            h = (r - g) / (max - min) * 60.0 + 240.0;
            if (h < 0.0) {
                h += 360.0;
            }
        }
        double l = (max + min) * 0.5;
        double[] hsl = new double[3];
        hsl[1] = max != min ? (l <= 0.5 ? (double)Math.round((max - min) / l * 50000.0) * 0.001 : (double)Math.round((max - min) / (1.0 - l) * 50000.0) * 0.001) : 0.0;
        hsl[0] = (double)Math.round(h * 1000.0) * 0.001;
        if (hsl[0] >= 360.0) {
            hsl[0] = hsl[0] - 360.0;
        }
        hsl[2] = (double)Math.round(l * 100000.0) * 0.001;
        return hsl;
    }

    static double[] srgbToHwb(double[] rgb) {
        int i;
        double f;
        double w = Math.min(rgb[0], rgb[1]);
        w = Math.min(w, rgb[2]);
        double v = Math.max(rgb[0], rgb[1]);
        v = Math.max(v, rgb[2]);
        double[] hwb = new double[3];
        if (Math.abs(v - w) < 1.0E-5) {
            hwb[0] = 0.0;
            hwb[1] = w;
            hwb[2] = rgb[2];
            return hwb;
        }
        if (rgb[0] == w) {
            f = rgb[1] - rgb[2];
            i = 3;
        } else if (rgb[1] == w) {
            f = rgb[2] - rgb[0];
            i = 5;
        } else {
            f = rgb[0] - rgb[1];
            i = 1;
        }
        hwb[0] = ((double)i - f / (v - w)) * 60.0;
        hwb[1] = w * 100.0;
        hwb[2] = (1.0 - v) * 100.0;
        return hwb;
    }

    static void labToLCh(double[] lab, double[] lch) {
        lch[0] = lab[0];
        lch[1] = Math.sqrt(lab[1] * lab[1] + lab[2] * lab[2]);
        lch[2] = Math.atan2(lab[2], lab[1]) * 180.0 / Math.PI;
        if (lch[2] < 0.0) {
            lch[2] = lch[2] + 360.0;
        }
    }

    static void lchToLab(double[] lch, double[] lab) {
        double hue = lch[2] * Math.PI / 180.0;
        lab[0] = lch[0];
        lab[1] = lch[1] * Math.cos(hue);
        lab[2] = lch[1] * Math.sin(hue);
    }

    static void labToClampedRGB(double light, double a, double b, boolean clamp, ColorProfile profile, double[] rgb) {
        ColorUtil.labToRGB(light, a, b, profile, rgb);
        if (!ColorUtil.rangeRoundCheck(rgb) && clamp) {
            ColorUtil.clampRGB(light, a, b, profile, rgb);
        }
    }

    static double[] labToXYZd50(double light, double a, double b) {
        double yr;
        double zr;
        double fy = (light + 16.0) / 116.0;
        double fx = a / 500.0 + fy;
        double fz = fy - b / 200.0;
        double eps = 0.008856451679035631;
        double kappa = 903.2962962962963;
        double xr = fx * fx * fx;
        if (xr <= 0.008856451679035631) {
            xr = (116.0 * fx - 16.0) / 903.2962962962963;
        }
        if ((zr = fz * fz * fz) <= 0.008856451679035631) {
            zr = (116.0 * fz - 16.0) / 903.2962962962963;
        }
        if (light > 8.0) {
            yr = (light + 16.0) / 116.0;
            yr = yr * yr * yr;
        } else {
            yr = light / 903.2962962962963;
        }
        double xwhite = 0.96422;
        double zwhite = 0.82521;
        double x = xr * xwhite;
        double z = zr * zwhite;
        double[] d50xyz = new double[]{x, yr, z};
        return d50xyz;
    }

    private static void labToRGB(double light, double a, double b, ColorProfile profile, double[] rgb) {
        double[] xyz = ColorUtil.labToXYZd50(light, a, b);
        if (profile.getIlluminant() == Illuminant.D65) {
            xyz = ColorUtil.d50xyzToD65(xyz);
        }
        profile.xyzToRgb(xyz, rgb);
    }

    static void oklabToRGB(double light, double a, double b, boolean clamp, ColorProfile profile, double[] rgb) {
        double[] xyz = ColorUtil.oklabToXyzD65(light, a, b);
        if (profile.getIlluminant() != Illuminant.D65) {
            xyz = ColorUtil.d65xyzToD50(xyz);
        }
        profile.xyzToRgb(xyz, rgb);
        if (!ColorUtil.rangeRoundCheck(rgb) && clamp) {
            ColorUtil.okClampRGB(light, a, b, profile, rgb);
        }
    }

    static void oklabToLab(double light, double a, double b, double[] lab) {
        double[] xyz65 = ColorUtil.oklabToXyzD65(light, a, b);
        double[] xyz = ColorUtil.d65xyzToD50(xyz65);
        ColorUtil.xyzD50ToLab(xyz, lab);
    }

    static double[] oklabToXyzD65(double light, double a, double b) {
        double l_p = light + 0.3963377774 * a + 0.2158037573 * b;
        double m_p = light - 0.1055613458 * a - 0.0638541728 * b;
        double s_p = light - 0.0894841775 * a - 1.291485548 * b;
        double xr = l_p * l_p * l_p;
        double yr = m_p * m_p * m_p;
        double zr = s_p * s_p * s_p;
        double[][] m1inv = new double[][]{{1.2270138511035211, -0.5577999806518222, 0.28125614896646783}, {-0.04058017842328059, 1.11225686961683, -0.07167667866560119}, {-0.0763812845057069, -0.4214819784180127, 1.586163220440795}};
        double[] xyz65 = new double[3];
        Matrices.multiplyByVector3((double[][])m1inv, (double)xr, (double)yr, (double)zr, (double[])xyz65);
        return xyz65;
    }

    static void xyzD65ToOkLab(double[] xyz, double[] oklab) {
        double[][] m1 = new double[][]{{0.8189330101, 0.3618667424, -0.1288597137}, {0.0329845436, 0.9293118715, 0.0361456387}, {0.0482003018, 0.2643662691, 0.633851707}};
        double[] lms = new double[3];
        Matrices.multiplyByVector3((double[][])m1, (double[])xyz, (double[])lms);
        double onethird = 0.3333333333333333;
        lms[0] = Math.signum(lms[0]) * Math.pow(Math.abs(lms[0]), 0.3333333333333333);
        lms[1] = Math.signum(lms[1]) * Math.pow(Math.abs(lms[1]), 0.3333333333333333);
        lms[2] = Math.signum(lms[2]) * Math.pow(Math.abs(lms[2]), 0.3333333333333333);
        double[][] m2 = new double[][]{{0.2104542553, 0.793617785, -0.0040720468}, {1.9779984951, -2.428592205, 0.4505937099}, {0.0259040371, 0.7827717662, -0.808675766}};
        Matrices.multiplyByVector3((double[][])m2, (double[])lms, (double[])oklab);
    }

    static boolean rangeRoundCheck(double[] rgb) {
        boolean inRange = true;
        for (int i = 0; i < rgb.length; ++i) {
            double comp = rgb[i];
            if (comp < 0.0) {
                if (comp > -1.0E-4) {
                    rgb[i] = 0.0;
                    continue;
                }
                inRange = false;
                continue;
            }
            if (!(comp > 1.0)) continue;
            if (comp < 1.0001) {
                rgb[i] = 1.0;
                continue;
            }
            inRange = false;
        }
        return inRange;
    }

    static void clampRGB(double light, double a, double b, ColorProfile profile, double[] rgb) {
        double[] labClamped;
        double[] rgbClamped;
        double h = Math.atan2(b, a);
        double sinh = Math.sin(h);
        double cosh = Math.cos(h);
        double current_a = a;
        double current_b = b;
        if (Math.sqrt(a * a + b * b) > 400.0) {
            double upper_c = 400.0;
            current_a = 400.0 * cosh;
            current_b = 400.0 * sinh;
            ColorUtil.labToRGB(light, current_a, current_b, profile, rgb);
        }
        if (ColorUtil.isInGamut(light, current_a, current_b, rgb, profile, rgbClamped = new double[3], labClamped = new double[3])) {
            System.arraycopy(rgbClamped, 0, rgb, 0, rgb.length);
            return;
        }
        double c = Math.sqrt(current_a * current_a + current_b * current_b) - labClamped[0];
        current_a = c * cosh;
        current_b = c * sinh;
        ColorUtil.labToRGB(light, current_a, current_b, profile, rgb);
        double eps = 0.025;
        double factor = 0.97;
        while (true) {
            ColorUtil.rangeClamp(rgb, rgbClamped);
            ColorUtil.rgbToLab(rgbClamped[0], rgbClamped[1], rgbClamped[2], profile, labClamped);
            c = Math.sqrt(current_a * current_a + current_b * current_b);
            double dE = ColorUtil.deltaE2000ChromaReduction(light, c, current_a, current_b, labClamped);
            if (dE < 2.0) {
                if (factor < 1.0) {
                    if (eps < 9.0E-5) {
                        System.arraycopy(rgbClamped, 0, rgb, 0, rgb.length);
                        return;
                    }
                    factor = 1.0 + (eps *= 0.15);
                }
            } else if (factor > 1.0) {
                factor = 1.0 - (eps *= 0.15);
            }
            current_a = (c *= factor) * cosh;
            current_b = c * sinh;
            ColorUtil.labToRGB(light, current_a, current_b, profile, rgb);
        }
    }

    private static void okClampRGB(double light, double a, double b, ColorProfile profile, double[] rgb) {
        double[] labClamped;
        double[] rgbClamped;
        ColorUtil.oklabToLab(light, a, b, rgb);
        light = rgb[0];
        double current_a = rgb[1];
        double current_b = rgb[2];
        double h = Math.atan2(current_b, current_a);
        double sinh = Math.sin(h);
        double cosh = Math.cos(h);
        if (Math.sqrt(current_a * current_a + current_b * current_b) > 400.0) {
            double upper_c = 400.0;
            current_a = 400.0 * cosh;
            current_b = 400.0 * sinh;
            ColorUtil.oklabToRGB(light, current_a, current_b, false, profile, rgb);
        }
        if (ColorUtil.isInGamut(light, current_a, current_b, rgb, profile, rgbClamped = new double[3], labClamped = new double[3])) {
            System.arraycopy(rgbClamped, 0, rgb, 0, rgb.length);
            return;
        }
        double c = Math.sqrt(current_a * current_a + current_b * current_b) - labClamped[0];
        current_a = c * cosh;
        current_b = c * sinh;
        ColorUtil.oklabToRGB(light, current_a, current_b, false, profile, rgb);
        float eps = 0.025f;
        float factor = 0.97f;
        while (true) {
            ColorUtil.rangeClamp(rgb, rgbClamped);
            ColorUtil.rgbToLab(rgbClamped[0], rgbClamped[1], rgbClamped[2], profile, labClamped);
            c = Math.sqrt(current_a * current_a + current_b * current_b);
            double dE = ColorUtil.deltaE2000ChromaReduction(light, c, current_a, current_b, labClamped);
            if (dE < 2.0) {
                if (factor < 1.0f) {
                    if ((double)eps < 9.0E-5) {
                        System.arraycopy(rgbClamped, 0, rgb, 0, rgb.length);
                        return;
                    }
                    factor = 1.0f + (eps *= 0.15f);
                }
            } else if (factor > 1.0f) {
                factor = 1.0f - (eps *= 0.15f);
            }
            current_a = (c *= (double)factor) * cosh;
            current_b = c * sinh;
            ColorUtil.labToRGB(light, current_a, current_b, profile, rgb);
        }
    }

    private static void rangeClamp(double[] rgb, double[] rgbClamped) {
        for (int i = 0; i < rgb.length; ++i) {
            double comp = rgb[i];
            rgbClamped[i] = comp > 1.0 ? 1.0 : (comp < 0.0 ? 0.0 : rgb[i]);
        }
    }

    private static boolean isInGamut(double light, double current_a, double current_b, double[] rgb, ColorProfile profile, double[] rgbClamped, double[] labClamped) {
        ColorUtil.rangeClamp(rgb, rgbClamped);
        ColorUtil.rgbToLab(rgbClamped[0], rgbClamped[1], rgbClamped[2], profile, labClamped);
        double c = Math.sqrt(current_a * current_a + current_b * current_b);
        double dE = ColorUtil.deltaE2000ChromaReduction(light, c, current_a, current_b, labClamped);
        return dE < 2.0;
    }

    static double[] d65xyzToD50(double[] xyz) {
        double[] xyzadj = new double[]{1.0478112436606313 * xyz[0] + 0.022886602481693052 * xyz[1] - 0.05012697596852886 * xyz[2], 0.029542398290574905 * xyz[0] + 0.9904844034904394 * xyz[1] - 0.017049095628961564 * xyz[2], -0.009234489723309473 * xyz[0] + 0.015043616793498756 * xyz[1] + 0.7521316354746059 * xyz[2]};
        return xyzadj;
    }

    static double[] d50xyzToD65(double[] xyzD50) {
        double[] xyzD65 = new double[]{0.955576615033105 * xyzD50[0] + -0.02303934471607876 * xyzD50[1] + 0.06316363224980126 * xyzD50[2], -0.028289544243554895 * xyzD50[0] + 1.0099416173711144 * xyzD50[1] + 0.021007654996190325 * xyzD50[2], 0.012298165717207273 * xyzD50[0] + -0.020483025232449423 * xyzD50[1] + 1.329909826449757 * xyzD50[2]};
        return xyzD65;
    }

    static void d65xyzToSRGB(double[] xyzD65, double[] rgb) {
        double r = 3.24096994190452 * xyzD65[0] - 1.53738317757 * xyzD65[1] - 0.498610760293 * xyzD65[2];
        double g = -0.96924363628088 * xyzD65[0] + 1.8759675015077 * xyzD65[1] + 0.04155505740718 * xyzD65[2];
        double b = 0.055630079697 * xyzD65[0] - 0.20397695888898 * xyzD65[1] + 1.05697151424288 * xyzD65[2];
        rgb[0] = ColorUtil.sRGBCompanding(r);
        rgb[1] = ColorUtil.sRGBCompanding(g);
        rgb[2] = ColorUtil.sRGBCompanding(b);
    }

    static double sRGBCompanding(double linearComponent) {
        double abs = Math.abs(linearComponent);
        double nlComp = abs <= 0.0031308 ? 12.92 * linearComponent : 1.055 * Math.signum(linearComponent) * Math.pow(abs, 0.4166666666666667) - 0.055;
        return nlComp;
    }

    static double[] srgbToXYZd65(double r, double g, double b) {
        r = RGBColor.inverseSRGBCompanding(r);
        g = RGBColor.inverseSRGBCompanding(g);
        b = RGBColor.inverseSRGBCompanding(b);
        return ColorUtil.linearSRGBToXYZd65(r, g, b);
    }

    static void rgbToLab(double r, double g, double b, ColorProfile profile, double[] lab) {
        r = profile.linearComponent(r);
        g = profile.linearComponent(g);
        b = profile.linearComponent(b);
        double[] xyz = new double[3];
        profile.linearRgbToXYZ(r, g, b, xyz);
        if (profile.getIlluminant() != Illuminant.D50) {
            xyz = ColorUtil.d65xyzToD50(xyz);
        }
        ColorUtil.xyzD50ToLab(xyz, lab);
    }

    static double[] linearSRGBToXYZd65(double r, double g, double b) {
        double[] xyzD65 = new double[]{0.41239079926595934 * r + 0.357584339383878 * g + 0.1804807884018343 * b, 0.21263900587151027 * r + 0.715168678767756 * g + 0.07219231536073371 * b, 0.01933081871559182 * r + 0.11919477979462598 * g + 0.9505321522496607 * b};
        return xyzD65;
    }

    static void xyzD50ToLab(double[] xyz, double[] lab) {
        double xwhite = Illuminants.whiteD50[0];
        double zwhite = Illuminants.whiteD50[2];
        xyz[0] = xyz[0] / xwhite;
        xyz[2] = xyz[2] / zwhite;
        double fx = ColorUtil.fxyz(xyz[0]);
        double fy = ColorUtil.fxyz(xyz[1]);
        double fz = ColorUtil.fxyz(xyz[2]);
        lab[0] = 116.0 * fy - 16.0;
        lab[1] = 500.0 * (fx - fy);
        lab[2] = 200.0 * (fy - fz);
    }

    private static double fxyz(double xyz) {
        double eps = 0.008856451679035631;
        double kappa = 903.2962962962963;
        double f = xyz > 0.008856451679035631 ? Math.pow(xyz, 0.3333333333333333) : (903.2962962962963 * xyz + 16.0) / 116.0;
        return f;
    }

    static float deltaE2000LCh(float l1, float c1, double h1, float l2, float c2, double h2) {
        double dL = l2 - l1;
        double lav = (double)(l1 + l2) * 0.5;
        double c_av = (double)(c1 + c2) * 0.5;
        double a1 = (double)c1 * Math.cos(h1);
        double a2 = (double)c2 * Math.cos(h2);
        double b1 = (double)c1 * Math.sin(h1);
        double b2 = (double)c2 * Math.sin(h2);
        return ColorUtil.deltaE2000(dL, lav, c_av, a1, b1, a2, b2);
    }

    static float deltaE2000Lab(float l1, float a1, float b1, float l2, float a2, float b2) {
        double dL = l2 - l1;
        double lav = (double)(l1 + l2) * 0.5;
        double c1 = Math.sqrt(a1 * a1 + b1 * b1);
        double c2 = Math.sqrt(a2 * a2 + b2 * b2);
        double c_av = (c1 + c2) * 0.5;
        return ColorUtil.deltaE2000(dL, lav, c_av, a1, b1, a2, b2);
    }

    private static float deltaE2000(double dL, double lav, double c_av, double a1, double b1, double a2, double b2) {
        double h2prime;
        double cav_pow7 = Math.pow(c_av, 7.0);
        double gplus1 = 1.0 + 0.5 * (1.0 - Math.sqrt(cav_pow7 / (cav_pow7 + 6.103515625E9)));
        double a1prime = a1 * gplus1;
        double a2prime = a2 * gplus1;
        double c1prime = Math.sqrt(a1prime * a1prime + b1 * b1);
        double c2prime = Math.sqrt(a2prime * a2prime + b2 * b2);
        double deltaCprime = c2prime - c1prime;
        double cprime_av = (c1prime + c2prime) * 0.5;
        double TWOPI = Math.PI * 2;
        double h1prime = Math.atan2(b1, a1prime);
        if (h1prime < 0.0) {
            h1prime += Math.PI * 2;
        }
        if ((h2prime = Math.atan2(b2, a2prime)) < 0.0) {
            h2prime += Math.PI * 2;
        }
        double hprime_av = 0.0;
        double dhprime = h2prime - h1prime;
        if (Math.abs(h1prime - h2prime) > Math.PI) {
            dhprime = h2prime <= h1prime ? (dhprime += Math.PI * 2) : (dhprime -= Math.PI * 2);
            hprime_av = Math.PI;
        }
        double dHprime = 2.0 * Math.sqrt(c1prime * c2prime) * Math.sin(dhprime * 0.5);
        double t = 1.0 - 0.17 * Math.cos((hprime_av += (h1prime + h2prime) * 0.5) - 0.5235988) + 0.24 * Math.cos(hprime_av + hprime_av) + 0.32 * Math.cos(3.0 * hprime_av + 0.1047198) - 0.2 * Math.cos(4.0 * hprime_av - 1.099557);
        double lav_minus50_sq = lav - 50.0;
        lav_minus50_sq *= lav_minus50_sq;
        double sL = 1.0 + 0.015 * lav_minus50_sq / Math.sqrt(lav_minus50_sq + 20.0);
        double sC = 1.0 + 0.045 * cprime_av;
        double sH = 1.0 + 0.015 * cprime_av * t;
        double cprime_av_pow7 = Math.pow(cprime_av, 7.0);
        double exp_arg = (hprime_av - 4.799655443) / 0.436332313;
        double rt = -2.0 * Math.sqrt(cprime_av_pow7 / (cprime_av_pow7 + 6.103515625E9)) * Math.sin(1.04719755 * Math.exp(-exp_arg * exp_arg));
        double l_comp = dL / sL;
        double c_comp = deltaCprime / sC;
        double h_comp = dHprime / sH;
        double hue_rotation = rt * c_comp * h_comp;
        double dE00 = Math.sqrt(l_comp * l_comp + c_comp * c_comp + h_comp * h_comp + hue_rotation);
        return (float)dE00;
    }

    private static double deltaE2000ChromaReduction(double lav, double c1, double a1, double b1, double[] labClamped) {
        double h2prime;
        double c2 = Math.sqrt(labClamped[1] * labClamped[1] + labClamped[2] * labClamped[2]);
        double c_av = (c1 + c2) * 0.5;
        double cav_pow7 = Math.pow(c_av, 7.0);
        double gplus1 = 1.0 + 0.5 * (1.0 - Math.sqrt(cav_pow7 / (cav_pow7 + 6.103515625E9)));
        double a1prime = a1 * gplus1;
        double a2prime = labClamped[1] * gplus1;
        double c1prime = Math.sqrt(a1prime * a1prime + b1 * b1);
        double c2prime = Math.sqrt(a2prime * a2prime + labClamped[2] * labClamped[2]);
        double deltaCprime = c2prime - c1prime;
        double cprime_av = (c1prime + c2prime) * 0.5;
        double TWOPI = Math.PI * 2;
        double h1prime = Math.atan2(b1, a1prime);
        if (h1prime < 0.0) {
            h1prime += Math.PI * 2;
        }
        if ((h2prime = Math.atan2(labClamped[2], a2prime)) < 0.0) {
            h2prime += Math.PI * 2;
        }
        double hprime_av = 0.0;
        double dhprime = h2prime - h1prime;
        if (Math.abs(h1prime - h2prime) > Math.PI) {
            dhprime = h2prime <= h1prime ? (dhprime += Math.PI * 2) : (dhprime -= Math.PI * 2);
            hprime_av = Math.PI;
        }
        double dHprime = 2.0 * Math.sqrt(c1prime * c2prime) * Math.sin(dhprime * 0.5);
        double t = 1.0 - 0.17 * Math.cos((hprime_av += (h1prime + h2prime) * 0.5) - 0.5235988) + 0.24 * Math.cos(hprime_av + hprime_av) + 0.32 * Math.cos(3.0 * hprime_av + 0.1047198) - 0.2 * Math.cos(4.0 * hprime_av - 1.099557);
        double sC = 1.0 + 0.045 * cprime_av;
        double sH = 1.0 + 0.015 * cprime_av * t;
        double cprime_av_pow7 = Math.pow(cprime_av, 7.0);
        double exp_arg = (hprime_av - 4.799655443) / 0.436332313;
        double c_comp = deltaCprime / sC;
        double h_comp = dHprime / sH;
        double rt = -2.0 * Math.sqrt(cprime_av_pow7 / (cprime_av_pow7 + 6.103515625E9)) * Math.sin(1.04719755 * Math.exp(-exp_arg * exp_arg));
        double hue_rotation = rt * c_comp * h_comp;
        double dE00 = Math.sqrt(c_comp * c_comp + h_comp * h_comp + hue_rotation);
        double dE00minus2 = dE00 - 2.0;
        double sqrtArg = dE00minus2 * dE00minus2 - h_comp * h_comp - hue_rotation;
        labClamped[0] = sqrtArg > 0.0 ? sC * Math.sqrt(sqrtArg) : 0.0;
        return dE00;
    }

    static double deltaEokLab(double[] ok1, double[] ok2) {
        double dL = ok2[0] - ok1[0];
        double da = ok2[1] - ok1[1];
        double db = ok2[2] - ok1[2];
        return Math.sqrt(dL * dL + da * da + db * db);
    }
}

