/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.color.Illuminants;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LCHColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ChromaticAdaption;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.OKLCHColorValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import io.sf.jclf.math.linear3.Matrices;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.DOMException;

class LCHColorImpl
extends BaseColor
implements LCHColor {
    private static final long serialVersionUID = 2L;
    private final BaseColor.Space colorSpace;
    private final String strSpace;
    private PrimitiveValue lightness = null;
    private PrimitiveValue chroma = null;
    private PrimitiveValue hue = null;

    LCHColorImpl(BaseColor.Space colorSpace, String strSpace) {
        this.colorSpace = colorSpace;
        this.strSpace = strSpace;
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LCH;
    }

    @Override
    public String getColorSpace() {
        return this.strSpace;
    }

    @Override
    BaseColor.Space getSpace() {
        return this.colorSpace;
    }

    @Override
    void set(BaseColor color) {
        super.set(color);
        LCHColorImpl setfrom = (LCHColorImpl)color;
        this.setLightness(setfrom.getLightness());
        this.setChroma(setfrom.getChroma());
        this.setHue(setfrom.getHue());
    }

    @Override
    public PrimitiveValue item(int index) {
        switch (index) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getLightness();
            }
            case 2: {
                return this.getChroma();
            }
            case 3: {
                return this.getHue();
            }
        }
        return null;
    }

    @Override
    void setComponent(int index, PrimitiveValue component) {
        switch (index) {
            case 0: {
                this.setAlpha(component);
                break;
            }
            case 1: {
                this.setLightness(component);
                break;
            }
            case 2: {
                this.setChroma(component);
                break;
            }
            case 3: {
                this.setHue(component);
            }
        }
    }

    @Override
    public PrimitiveValue getLightness() {
        return this.lightness;
    }

    public void setLightness(PrimitiveValue lightness) {
        boolean specified;
        int maxDigits;
        float factor;
        if (BaseColor.Space.OK_LCh.equals((Object)this.colorSpace)) {
            factor = 0.01f;
            maxDigits = 6;
            specified = false;
        } else {
            factor = 1.0f;
            maxDigits = 4;
            specified = true;
        }
        this.lightness = LCHColorImpl.normalizePcntToNumber(lightness, factor, maxDigits, specified);
    }

    @Override
    public PrimitiveValue getChroma() {
        return this.chroma;
    }

    public void setChroma(PrimitiveValue chroma) {
        int maxDigits;
        float factor;
        if (BaseColor.Space.OK_LCh.equals((Object)this.colorSpace)) {
            factor = 0.004f;
            maxDigits = 5;
        } else {
            factor = 1.5f;
            maxDigits = 4;
        }
        this.chroma = LCHColorImpl.normalizePcntToNumber(chroma, factor, maxDigits, false);
    }

    @Override
    public PrimitiveValue getHue() {
        return this.hue;
    }

    public void setHue(PrimitiveValue hue) {
        this.hue = LCHColorImpl.enforceHueComponent(hue);
    }

    @Override
    boolean hasConvertibleComponents() {
        return LCHColorImpl.isConvertibleComponent(this.getChroma()) && LCHColorImpl.isConvertibleComponent(this.getHue()) && LCHColorImpl.isConvertibleComponent(this.getLightness());
    }

    @Override
    void setColorComponents(double[] lch) {
        NumberValue l = NumberValue.createCSSNumberValue((short)0, (float)lch[0]);
        l.setSubproperty(true);
        l.setAbsolutizedUnit();
        if (this.getSpace() == BaseColor.Space.OK_LCh) {
            l.setMaximumFractionDigits(6);
        } else {
            l.setMaximumFractionDigits(4);
        }
        this.setLightness(l);
        NumberValue c = NumberValue.createCSSNumberValue((short)0, (float)lch[1]);
        c.setSubproperty(true);
        c.setAbsolutizedUnit();
        if (this.getSpace() == BaseColor.Space.OK_LCh) {
            c.setMaximumFractionDigits(5);
        } else {
            c.setMaximumFractionDigits(4);
        }
        this.setChroma(c);
        float fhue = (float)lch[2];
        if (fhue < 0.0f) {
            fhue += 360.0f;
        }
        NumberValue h = NumberValue.createCSSNumberValue((short)80, fhue);
        h.setSubproperty(true);
        h.setAbsolutizedUnit();
        h.setMaximumFractionDigits(4);
        this.setHue(h);
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] lch = new double[]{ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness())), ColorUtil.floatNumber((CSSTypedValue)((Object)this.getChroma())), ColorUtil.hueDegrees((CSSTypedValue)((Object)this.getHue()))};
        return lch;
    }

    @Override
    double[] toSRGB(boolean clamp) {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float c = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getChroma()));
        double h = ColorUtil.hueRadians((CSSTypedValue)((Object)this.getHue()));
        double a = (double)c * Math.cos(h);
        double b = (double)c * Math.sin(h);
        float light = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness()));
        double[] rgb = new double[3];
        SRGBColorProfile profile = new SRGBColorProfile();
        if (this.colorSpace == BaseColor.Space.OK_LCh) {
            ColorUtil.oklabToRGB(light, a, b, clamp, profile, rgb);
        } else {
            ColorUtil.labToClampedRGB(light, a, b, clamp, profile, rgb);
        }
        return rgb;
    }

    @Override
    public double[] toXYZ(Illuminant white) {
        double[] xyz;
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        CSSTypedValue primihue = (CSSTypedValue)((Object)this.getHue());
        float c = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getChroma()));
        double h = ColorUtil.hueRadians(primihue);
        float a = (float)((double)c * Math.cos(h));
        float b = (float)((double)c * Math.sin(h));
        float light = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness()));
        if (this.colorSpace == BaseColor.Space.OK_LCh) {
            xyz = ColorUtil.oklabToXyzD65(light, a, b);
            if (white == Illuminant.D50) {
                xyz = ColorUtil.d65xyzToD50(xyz);
            }
        } else {
            xyz = ColorUtil.labToXYZd50(light, a, b);
            if (white == Illuminant.D65) {
                xyz = ColorUtil.d50xyzToD65(xyz);
            }
        }
        return xyz;
    }

    @Override
    public double[] toXYZ(double[] white) {
        double[] xyz;
        double[] lab = this.toLab();
        if (this.colorSpace == BaseColor.Space.OK_LCh) {
            xyz = ColorUtil.oklabToXyzD65(lab[0], lab[1], lab[2]);
            if (!Arrays.equals(Illuminants.whiteD65, white)) {
                double[][] cam = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD65, white, cam);
                double[] result = new double[3];
                Matrices.multiplyByVector3((double[][])cam, (double[])xyz, (double[])result);
                xyz = result;
            }
        } else {
            xyz = ColorUtil.labToXYZd50(lab[0], lab[1], lab[2]);
            if (!Arrays.equals(Illuminants.whiteD50, white)) {
                double[][] cam = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD50, white, cam);
                double[] result = new double[3];
                Matrices.multiplyByVector3((double[][])cam, (double[])xyz, (double[])result);
                xyz = result;
            }
        }
        return xyz;
    }

    private double[] toLab() {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        CSSTypedValue primihue = (CSSTypedValue)((Object)this.getHue());
        float c = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getChroma()));
        double h = ColorUtil.hueRadians(primihue);
        double[] lab = new double[3];
        lab[1] = (float)((double)c * Math.cos(h));
        lab[2] = (float)((double)c * Math.sin(h));
        lab[0] = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness()));
        return lab;
    }

    @Override
    public String toString() {
        BufferSimpleWriter wri = new BufferSimpleWriter();
        try {
            this.writeCssText((SimpleWriter)wri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wri.toString();
    }

    void writeCssText(SimpleWriter wri) throws IOException {
        if (this.colorSpace == BaseColor.Space.OK_LCh) {
            wri.write((CharSequence)"oklch(");
        } else {
            wri.write((CharSequence)"lch(");
        }
        this.lightness.writeCssText(wri);
        wri.write(' ');
        this.chroma.writeCssText(wri);
        wri.write(' ');
        this.writeHue(wri, this.hue);
        if (this.isNonOpaque()) {
            wri.write((CharSequence)" / ");
            this.appendAlphaChannel(wri);
        }
        wri.write(')');
    }

    @Override
    public String toMinifiedString() {
        StringBuilder buf = new StringBuilder(20);
        if (this.colorSpace == BaseColor.Space.OK_LCh) {
            buf.append("oklch(");
        } else {
            buf.append("lch(");
        }
        buf.append(this.lightness.getMinifiedCssText("color"));
        buf.append(' ').append(this.chroma.getMinifiedCssText("color")).append(' ');
        this.appendMinifiedHue(buf, this.hue);
        if (this.isNonOpaque()) {
            buf.append('/');
            this.appendAlphaChannelMinified(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = Objects.hash(new Object[]{this.getSpace()});
        result = 31 * result + (this.lightness == null ? 0 : this.lightness.hashCode());
        result = 31 * result + (this.chroma == null ? 0 : this.chroma.hashCode());
        result = 31 * result + (this.hue == null ? 0 : this.hue.hashCode());
        result = 31 * result + this.alpha.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LCHColorImpl other = (LCHColorImpl)obj;
        if (this.colorSpace != other.colorSpace) {
            return false;
        }
        if (this.lightness == null ? other.lightness != null : !this.lightness.equals(other.lightness)) {
            return false;
        }
        if (this.chroma == null ? other.chroma != null : !this.chroma.equals(other.chroma)) {
            return false;
        }
        if (this.hue == null ? other.hue != null : !this.hue.equals(other.hue)) {
            return false;
        }
        return this.alpha.equals(other.alpha);
    }

    @Override
    public ColorValue packInValue() {
        if (BaseColor.Space.OK_LCh.equals((Object)this.colorSpace)) {
            return new OKLCHColorValue(this);
        }
        return new LCHColorValue(this);
    }

    @Override
    public LCHColorImpl clone() {
        LCHColorImpl clon = new LCHColorImpl(this.colorSpace, this.strSpace);
        clon.alpha = this.alpha.clone();
        if (this.lightness != null) {
            clon.lightness = this.lightness.clone();
        }
        if (this.chroma != null) {
            clon.chroma = this.chroma.clone();
        }
        if (this.hue != null) {
            clon.hue = this.hue.clone();
        }
        return clon;
    }
}

