/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.w3c.dom.DOMException;

public class URIValueWrapper
extends URIValue
implements WrappedValue {
    private static final long serialVersionUID = 1L;
    private final String parentSheetHref;

    public URIValueWrapper(URIValue wrapped, String oldHrefContext, String parentSheetHref) {
        super(wrapped);
        this.parentSheetHref = parentSheetHref;
        if (oldHrefContext != parentSheetHref) {
            this.setStringValue(this.getStringValue(super.getStringValue(), oldHrefContext));
        }
    }

    @Override
    public String getParentSheetHref() {
        return this.parentSheetHref;
    }

    @Override
    public String getCssText() {
        String sv = this.getStringValue();
        if (sv == null) {
            return "";
        }
        BufferSimpleWriter sw = new BufferSimpleWriter(sv.length() + 6);
        try {
            this.writeCssText((SimpleWriter)sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        String sv = this.getStringValue();
        if (sv != null) {
            wri.write((CharSequence)"url(");
            sv = ParseHelper.quote(sv, this.quote);
            wri.write((CharSequence)sv);
            wri.write(')');
        }
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        URI baseUri;
        URI uri;
        int lastSlash;
        String sv = this.getStringValue();
        if (sv == null) {
            return "";
        }
        if (this.parentSheetHref == null || (lastSlash = this.parentSheetHref.lastIndexOf(47)) == -1) {
            return super.getMinifiedCssText();
        }
        String base = this.parentSheetHref.substring(0, lastSlash + 1);
        try {
            uri = new URI(sv);
            baseUri = new URI(base);
        }
        catch (URISyntaxException e) {
            return super.getCssText();
        }
        baseUri = baseUri.normalize();
        String reluri = baseUri.relativize(uri).toASCIIString();
        if (!LexicalValue.urlCanBeUnquoted(sv)) {
            reluri = ParseHelper.quote(reluri, this.quote);
        }
        return "url(" + reluri + ')';
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.error();
    }

    @Override
    public String getStringValue() {
        return this.getStringValue(super.getStringValue(), this.parentSheetHref);
    }

    private String getStringValue(String relValue, String contextHref) {
        if (relValue != null) {
            try {
                URI uri = new URI(relValue);
                if (!uri.isAbsolute() && contextHref != null) {
                    URI base = new URI(contextHref);
                    uri = base.resolve(uri);
                }
                relValue = uri.normalize().toASCIIString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return relValue;
    }

    @Override
    public void setStringValue(CSSValue.Type stringType, String stringValue) throws DOMException {
        this.error();
    }

    private void error() throws DOMException {
        throw new DOMException(7, "This property is read-only computed value. Must modify at the original style sheet.");
    }

    @Override
    public URL getURLValue() {
        URL url = null;
        String sv = super.getStringValue();
        if (sv != null) {
            try {
                URI uri = new URI(sv);
                if (!uri.isAbsolute()) {
                    if (this.parentSheetHref != null) {
                        URI base = new URI(this.parentSheetHref);
                        uri = base.resolve(uri);
                    } else {
                        return null;
                    }
                }
                url = uri.toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    @Override
    public URIValue clone() {
        return new URIValueWrapper(super.clone(), this.parentSheetHref, this.parentSheetHref);
    }
}

