/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.cache.internal.VersionSpecificCacheCleanupAction;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.time.TimestampSuppliers;

@ServiceScope(value={Scope.BuildSession.class})
public class ProjectCacheDir
implements Stoppable {
    private static final int MAX_UNUSED_DAYS_FOR_RELEASES_AND_SNAPSHOTS = 7;
    private final File dir;
    private final BuildOperationRunner buildOperationRunner;
    private final Deleter deleter;

    public ProjectCacheDir(File dir, BuildOperationRunner buildOperationRunner, Deleter deleter) {
        this.dir = dir;
        this.buildOperationRunner = buildOperationRunner;
        this.deleter = deleter;
    }

    public File getDir() {
        return this.dir;
    }

    public void stop() {
        final VersionSpecificCacheCleanupAction cleanupAction = new VersionSpecificCacheCleanupAction(this.dir, TimestampSuppliers.daysAgo((int)7), this.deleter, CleanupFrequency.DAILY);
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                cleanupAction.execute((CleanupProgressMonitor)new DefaultCleanupProgressMonitor(context));
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)cleanupAction.getDisplayName());
            }
        });
    }
}

