/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.EqualityPolicy;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.HashCommon;

final class LinkedCustomHashMap<K, V> {
    private Entry<K, V>[] entries;
    private Entry<K, V> top;
    private Entry<K, V> back;
    private transient int mask;
    private transient int n;
    private final RemoveCallback<K, V> removeEldestEntry;
    private transient int maxFill;
    private int size;
    private final EqualityPolicy<? super K> hashingStrategy;

    @TestOnly
    LinkedCustomHashMap() {
        this(EqualityPolicy.CANONICAL, (map, eldest, key, value2) -> false);
    }

    LinkedCustomHashMap(@NotNull EqualityPolicy<? super K> hashingStrategy, @NotNull RemoveCallback<K, V> removeEldestEntry) {
        if (hashingStrategy == null) {
            LinkedCustomHashMap.$$$reportNull$$$0(1);
        }
        if (removeEldestEntry == null) {
            LinkedCustomHashMap.$$$reportNull$$$0(2);
        }
        this.hashingStrategy = hashingStrategy;
        this.removeEldestEntry = removeEldestEntry;
        this.init();
    }

    private void init() {
        this.n = HashCommon.arraySize(16, 0.6f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, 0.6f);
        this.entries = new Entry[this.n + 1];
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.back = null;
        this.top = null;
        this.init();
    }

    public V get(K key) {
        Entry<K, V>[] entries = this.entries;
        int hash = this.hashKey(key);
        int index = hash & this.mask;
        Entry e2 = entries[index];
        while (e2 != null) {
            Object entryKey;
            if (e2.keyHash == hash && ((entryKey = e2.key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
                this.moveToTop(e2);
                return (V)e2.value;
            }
            e2 = e2.hashNext;
        }
        return null;
    }

    private int hashKey(K key) {
        return key == null ? 0 : HashCommon.mix(this.hashingStrategy.getHashCode(key));
    }

    public V put(K key, @NotNull V value2) {
        if (value2 == null) {
            LinkedCustomHashMap.$$$reportNull$$$0(3);
        }
        Entry<K, V>[] table = this.entries;
        int hash = this.hashKey(key);
        int index = hash & this.mask;
        Entry<K, V> e2 = table[index];
        while (e2 != null) {
            Object entryKey;
            if (((Entry)e2).keyHash == hash && ((entryKey = ((Entry)e2).key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
                this.moveToTop(e2);
                return e2.setValue(value2);
            }
            e2 = ((Entry)e2).hashNext;
        }
        e2 = new Entry<K, V>(key, value2, hash);
        ((Entry)e2).hashNext = (Entry)table[index];
        table[index] = e2;
        Entry<K, V> top = this.top;
        ((Entry)e2).next = (Entry)top;
        if (top != null) {
            ((Entry)top).previous = (Entry)e2;
        } else {
            this.back = e2;
        }
        this.top = e2;
        ++this.size;
        if (this.removeEldestEntry.check(this.size, this.back, ((Entry)this.back).key, ((Entry)this.back).value)) {
            V value1 = this.remove(((Entry)this.back).key);
            assert (value1 != null) : "LinkedHashMap.Entry was not removed. Possibly mutable key: " + Entry.access$200(this.back);
        } else if (this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, 0.6f));
        }
        return null;
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public V remove(K key) {
        Object entryKey;
        Entry<K, V>[] entries = this.entries;
        int hash = this.hashKey(key);
        int index = hash & this.mask;
        Entry e2 = entries[index];
        if (e2 == null) {
            return null;
        }
        if (e2.keyHash == hash && ((entryKey = e2.key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
            entries[index] = e2.hashNext;
        } else {
            Entry last;
            do {
                last = e2;
                if ((e2 = e2.hashNext) != null) continue;
                return null;
            } while (e2.keyHash != hash || (entryKey = e2.key) != key && !this.hashingStrategy.isEqual(entryKey, key));
            last.hashNext = e2.hashNext;
        }
        this.unlink(e2);
        --this.size;
        return (V)e2.value;
    }

    @NotNull
    public Set<K> keySet() {
        return new KeySet();
    }

    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private void moveToTop(Entry<K, V> e2) {
        Entry<K, V> top = this.top;
        if (top == e2) {
            return;
        }
        Entry prev = ((Entry)e2).previous;
        Entry next = ((Entry)e2).next;
        prev.next = next;
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
        ((Entry)top).previous = (Entry)e2;
        ((Entry)e2).next = (Entry)top;
        ((Entry)e2).previous = null;
        this.top = e2;
    }

    private void unlink(Entry<K, V> e2) {
        Entry prev = ((Entry)e2).previous;
        Entry next = ((Entry)e2).next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
        ((Entry)e2).previous = null;
        ((Entry)e2).next = null;
    }

    private void rehash(int newN) {
        this.mask = newN - 1;
        this.n = newN;
        this.maxFill = HashCommon.maxFill(this.n, 0.6f);
        Entry[] entries = new Entry[newN];
        Entry e2 = this.back;
        while (e2 != null) {
            int hash = e2.keyHash & this.mask;
            e2.hashNext = entries[hash];
            entries[hash] = e2;
            e2 = e2.previous;
        }
        this.entries = entries;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeEldestEntry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/LinkedCustomHashMap";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final int keyHash;
        private V value;
        private Entry<K, V> next;
        private Entry<K, V> previous;
        private Entry<K, V> hashNext;

        Entry(K key, V value2, int hash) {
            this.key = key;
            this.keyHash = hash;
            this.value = value2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value2) {
            V result2 = this.value;
            this.value = value2;
            return result2;
        }
    }

    @FunctionalInterface
    static interface RemoveCallback<K, V> {
        public boolean check(int var1, Map.Entry<K, V> var2, K var3, V var4);
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            return new LinkedHashIterator(){

                @Override
                public K next() {
                    return this.nextEntry().key;
                }
            };
        }

        @Override
        public int size() {
            return LinkedCustomHashMap.this.size;
        }

        @Override
        public boolean contains(Object o2) {
            return LinkedCustomHashMap.this.containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            return LinkedCustomHashMap.this.remove(o2) != null;
        }

        @Override
        public void clear() {
            LinkedCustomHashMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedHashIterator(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextEntry();
                }
            };
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object value2 = LinkedCustomHashMap.this.get(e2.getKey());
            return value2 != null && value2.equals(e2.getValue());
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return LinkedCustomHashMap.this.remove(e2.getKey()) != null;
        }

        @Override
        public int size() {
            return LinkedCustomHashMap.this.size;
        }

        @Override
        public void clear() {
            LinkedCustomHashMap.this.clear();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        private Entry<K, V> e;
        private Entry<K, V> last;

        private LinkedHashIterator() {
            this.e = LinkedCustomHashMap.this.back;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedCustomHashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<K, V> nextEntry() {
            this.last = this.e;
            Entry result2 = this.last;
            this.e = result2.previous;
            return result2;
        }
    }
}

