/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompileOptions;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.file.Deleter;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;
import org.jspecify.annotations.Nullable;

public class CleaningJavaCompiler<T extends JavaCompileSpec>
implements Compiler<T> {
    private final Compiler<T> compiler;
    private final TaskOutputsInternal taskOutputs;
    private final Deleter deleter;

    public CleaningJavaCompiler(Compiler<T> compiler, TaskOutputsInternal taskOutputs, Deleter deleter) {
        this.compiler = compiler;
        this.taskOutputs = taskOutputs;
        this.deleter = deleter;
    }

    public WorkResult execute(T spec) {
        ImmutableSet.Builder outputDirs = ImmutableSet.builderWithExpectedSize((int)3);
        MinimalJavaCompileOptions compileOptions = spec.getCompileOptions();
        this.addDirectoryIfNotNull((ImmutableSet.Builder<File>)outputDirs, spec.getDestinationDir());
        this.addDirectoryIfNotNull((ImmutableSet.Builder<File>)outputDirs, compileOptions.getAnnotationProcessorGeneratedSourcesDirectory());
        this.addDirectoryIfNotNull((ImmutableSet.Builder<File>)outputDirs, compileOptions.getHeaderOutputDirectory());
        boolean cleanedOutputs = StaleOutputCleaner.cleanOutputs((Deleter)this.deleter, (Iterable)this.taskOutputs.getPreviousOutputFiles(), (ImmutableSet)outputDirs.build());
        Compiler<T> compiler = this.getCompiler();
        return compiler.execute(spec).or(WorkResults.didWork((boolean)cleanedOutputs));
    }

    private void addDirectoryIfNotNull(ImmutableSet.Builder<File> outputDirs, @Nullable File dir) {
        if (dir != null) {
            outputDirs.add((Object)dir);
        }
    }

    public Compiler<T> getCompiler() {
        return this.compiler;
    }
}

