/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ZoomAction
extends MapMode
implements SelectionManager.SelectionEnded {
    private final transient SelectionManager selectionManager;

    public ZoomAction(MapFrame mapFrame) {
        super(I18n.tr("Zoom mode", new Object[0]), "zoom", I18n.tr("Zoom and move map", new Object[0]), Shortcut.registerShortcut("mapmode:zoom", I18n.tr("Mode: {0}", I18n.tr("Zoom mode", new Object[0])), 65535, 5000), ImageProvider.getCursor("normal", "zoom"));
        this.selectionManager = new SelectionManager(this, true, mapFrame.mapView);
    }

    @Override
    public void selectionEnded(Rectangle r, MouseEvent e) {
        if (r.width >= 3 && r.height >= 3 && MainApplication.isDisplayingMapView()) {
            MapView mv = MainApplication.getMap().mapView;
            double factor = r.x == e.getPoint().x || r.y == e.getPoint().y ? (double)mv.getWidth() / r.getWidth() : r.getWidth() / (double)mv.getWidth();
            mv.zoomToFactor(mv.getEastNorth(r.x + r.width / 2, r.y + r.height / 2), factor);
        }
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.selectionManager.register(MainApplication.getMap().mapView, false);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.selectionManager.unregister(MainApplication.getMap().mapView);
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Zoom by dragging or Ctrl+. or Ctrl+,; move with Ctrl+up, left, down, right; move zoom with right button", new Object[0]);
    }
}

