/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.oid4vci.Oid4vcProtocolMapperModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.model.ClaimDisplay;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Claim {
    @JsonIgnore
    private String name;
    @JsonProperty(value="path")
    private List<String> path;
    @JsonProperty(value="mandatory")
    private Boolean mandatory;
    @JsonProperty(value="display")
    private List<ClaimDisplay> display;

    public static Optional<Claim> parse(KeycloakSession keycloakSession, String credentialFormat, Oid4vcProtocolMapperModel protocolMapper) {
        try {
            Claim claim = new Claim();
            ProtocolMapper protocolMapperImpl = (ProtocolMapper)keycloakSession.getProvider(ProtocolMapper.class, protocolMapper.getProtocolMapper());
            if (!(protocolMapperImpl instanceof OID4VCMapper)) {
                return Optional.empty();
            }
            OID4VCMapper mapper = (OID4VCMapper)protocolMapperImpl;
            mapper.setMapperModel((ProtocolMapperModel)protocolMapper, credentialFormat);
            if (!mapper.includeInMetadata()) {
                return Optional.empty();
            }
            claim.setName(String.join((CharSequence)".", mapper.getMetadataAttributePath()));
            claim.setPath(mapper.getMetadataAttributePath());
            claim.setMandatory(protocolMapper.isMandatory());
            String displayString = protocolMapper.getDisplay();
            if (StringUtil.isNotBlank((String)displayString)) {
                TypeReference<List<ClaimDisplay>> typeReference = new TypeReference<List<ClaimDisplay>>(){};
                List claimDisplayList = (List)JsonSerialization.mapper.readValue(displayString, (TypeReference)typeReference);
                claim.setDisplay(claimDisplayList);
            }
            return Optional.of(claim);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Claim setName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getPath() {
        return this.path;
    }

    public Claim setPath(List<String> path) {
        this.path = path;
        return this;
    }

    public boolean isMandatory() {
        return Optional.ofNullable(this.mandatory).orElse(false);
    }

    public Claim setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public List<ClaimDisplay> getDisplay() {
        return this.display;
    }

    public Claim setDisplay(List<ClaimDisplay> display) {
        this.display = display;
        return this;
    }
}

