/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.Incubating;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.metamodel.spi.ImplicitDiscriminatorStrategy;
import org.hibernate.type.AnyType;
import org.hibernate.type.MappingContext;
import org.hibernate.type.MetaType;
import org.hibernate.type.Type;

public class Any
extends SimpleValue {
    private final MetaValue metaMapping;
    private final SimpleValue keyMapping;
    private BasicValue discriminatorDescriptor;
    private BasicValue keyDescriptor;
    private Map<Object, String> metaValueToEntityNameMap;
    private ImplicitDiscriminatorStrategy implicitValueStrategy;
    private boolean lazy = true;
    private AnyType resolvedType;

    public Any(MetadataBuildingContext buildingContext, Table table) {
        this(buildingContext, table, false);
    }

    public Any(MetadataBuildingContext buildingContext, Table table, boolean annotations) {
        super(buildingContext, table);
        if (!annotations) {
            this.metaMapping = new MetaValue(this::applySelectableToSuper, buildingContext, table);
            this.metaMapping.setTypeName("string");
            this.keyMapping = new KeyValue(this::applySelectableToSuper, buildingContext, table);
        } else {
            this.metaMapping = null;
            this.keyMapping = null;
        }
    }

    public Any(Any original) {
        super(original);
        this.metaMapping = original.metaMapping == null ? null : original.metaMapping.copy();
        this.keyMapping = original.keyMapping == null ? null : (SimpleValue)original.keyMapping.copy();
        this.discriminatorDescriptor = original.discriminatorDescriptor == null ? null : original.discriminatorDescriptor.copy();
        this.keyDescriptor = original.keyDescriptor == null ? null : original.keyDescriptor.copy();
        this.metaValueToEntityNameMap = original.metaValueToEntityNameMap == null ? null : new HashMap<Object, String>(original.metaValueToEntityNameMap);
        this.implicitValueStrategy = original.implicitValueStrategy;
        this.lazy = original.lazy;
    }

    @Override
    public Any copy() {
        return new Any(this);
    }

    public void addSelectable(Selectable selectable) {
        if (selectable != null) {
            if (selectable instanceof Column) {
                Column column = (Column)selectable;
                super.justAddColumn(column);
            } else if (selectable instanceof Formula) {
                Formula formula = (Formula)selectable;
                super.justAddFormula(formula);
            }
        }
    }

    private void applySelectableToSuper(Selectable selectable) {
        if (selectable instanceof Column) {
            Column column = (Column)selectable;
            super.justAddColumn(column);
        } else if (selectable instanceof Formula) {
            Formula formula = (Formula)selectable;
            super.justAddFormula(formula);
        }
    }

    public BasicValue getDiscriminatorDescriptor() {
        return this.discriminatorDescriptor;
    }

    public BasicValue getKeyDescriptor() {
        return this.keyDescriptor;
    }

    public MetaValue getMetaMapping() {
        return this.metaMapping;
    }

    public SimpleValue getKeyMapping() {
        return this.keyMapping;
    }

    public String getIdentifierType() {
        return this.keyMapping.getTypeName();
    }

    public void setIdentifierType(String identifierType) {
        this.keyMapping.setTypeName(identifierType);
    }

    @Override
    public AnyType getType() throws MappingException {
        if (this.resolvedType == null) {
            Type discriminatorType = this.discriminatorDescriptor != null ? this.discriminatorDescriptor.getType() : this.metaMapping.getType();
            Type identifierType = this.keyDescriptor != null ? this.keyDescriptor.getType() : this.keyMapping.getType();
            MetaType metaType = new MetaType(discriminatorType, this.implicitValueStrategy, this.metaValueToEntityNameMap);
            this.resolvedType = new AnyType(this.getTypeConfiguration(), metaType, identifierType, this.isLazy());
        }
        return this.resolvedType;
    }

    @Override
    public void addColumn(Column column) {
        this.applySelectableLocally(column);
    }

    @Override
    public void addColumn(Column column, boolean isInsertable, boolean isUpdatable) {
        this.applySelectableLocally(column);
    }

    @Override
    public void addFormula(Formula formula) {
        this.applySelectableLocally(formula);
    }

    private void applySelectableLocally(Selectable selectable) {
        if (this.discriminatorDescriptor == null && this.getColumnSpan() == 0) {
            if (selectable instanceof Column) {
                Column column = (Column)selectable;
                this.metaMapping.addColumn(column);
            } else if (selectable instanceof Formula) {
                Formula formula = (Formula)selectable;
                this.metaMapping.addFormula(formula);
            }
        } else if (selectable instanceof Column) {
            Column column = (Column)selectable;
            this.keyMapping.addColumn(column);
        } else if (selectable instanceof Formula) {
            Formula formula = (Formula)selectable;
            this.keyMapping.addFormula(formula);
        }
    }

    public String getMetaType() {
        return this.metaMapping.typeName;
    }

    public void setMetaType(String type) {
        this.metaMapping.setTypeName(type);
    }

    public Map<Object, String> getMetaValues() {
        return this.metaValueToEntityNameMap;
    }

    public void setMetaValues(Map<Object, String> metaValueToEntityNameMap) {
        this.metaValueToEntityNameMap = metaValueToEntityNameMap;
    }

    @Incubating
    public void setImplicitDiscriminatorValueStrategy(ImplicitDiscriminatorStrategy implicitValueStrategy) {
        this.implicitValueStrategy = implicitValueStrategy;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) {
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isSame(SimpleValue other) {
        Any any;
        return other instanceof Any && this.isSame(any = (Any)other);
    }

    public boolean isSame(Any other) {
        return super.isSame(other) && Objects.equals(this.getTypeNameOrNull(this.keyMapping), this.getTypeNameOrNull(other.keyMapping)) && Objects.equals(this.getTypeNameOrNull(this.metaMapping), this.getTypeNameOrNull(other.metaMapping)) && Objects.equals(this.metaValueToEntityNameMap, other.metaValueToEntityNameMap) && this.lazy == other.lazy;
    }

    private String getTypeNameOrNull(SimpleValue simpleValue) {
        return simpleValue != null ? simpleValue.getTypeName() : null;
    }

    @Override
    public boolean isValid(MappingContext mappingContext) throws MappingException {
        if (this.discriminatorDescriptor != null) {
            return this.discriminatorDescriptor.isValid(mappingContext) && this.keyDescriptor.isValid(mappingContext);
        }
        return this.metaMapping.isValid(mappingContext) && this.keyMapping.isValid(mappingContext);
    }

    private static String columnName(Column column, MetadataBuildingContext buildingContext) {
        JdbcServices jdbcServices = buildingContext.getBootstrapContext().getServiceRegistry().requireService(JdbcServices.class);
        return column.getQuotedName(jdbcServices.getDialect());
    }

    public void setDiscriminator(BasicValue discriminatorDescriptor) {
        this.discriminatorDescriptor = discriminatorDescriptor;
        Selectable selectable = discriminatorDescriptor.getColumn();
        if (selectable instanceof Column) {
            Column column = (Column)selectable;
            this.justAddColumn(column, discriminatorDescriptor.isColumnInsertable(0), discriminatorDescriptor.isColumnUpdateable(0));
        } else {
            this.justAddFormula((Formula)discriminatorDescriptor.getColumn());
        }
    }

    public void setDiscriminatorValueMappings(Map<Object, Class<?>> discriminatorValueMappings) {
        this.metaValueToEntityNameMap = new HashMap<Object, String>();
        discriminatorValueMappings.forEach((value, entity) -> this.metaValueToEntityNameMap.put(value, entity.getName()));
    }

    public void setKey(BasicValue keyDescriptor) {
        this.keyDescriptor = keyDescriptor;
        Selectable selectable = keyDescriptor.getColumn();
        if (selectable instanceof Column) {
            Column column = (Column)selectable;
            this.justAddColumn(column, keyDescriptor.isColumnInsertable(0), keyDescriptor.isColumnUpdateable(0));
        } else {
            this.justAddFormula((Formula)keyDescriptor.getColumn());
        }
    }

    public static class MetaValue
    extends SimpleValue {
        private String typeName;
        private String columnName;
        private final Consumer<Selectable> selectableConsumer;

        public MetaValue(Consumer<Selectable> selectableConsumer, MetadataBuildingContext buildingContext) {
            super(buildingContext);
            this.selectableConsumer = selectableConsumer;
        }

        public MetaValue(Consumer<Selectable> selectableConsumer, MetadataBuildingContext buildingContext, Table table) {
            super(buildingContext, table);
            this.selectableConsumer = selectableConsumer;
        }

        private MetaValue(MetaValue original) {
            super(original);
            this.typeName = original.typeName;
            this.columnName = original.columnName;
            this.selectableConsumer = original.selectableConsumer;
        }

        @Override
        public MetaValue copy() {
            return new MetaValue(this);
        }

        @Override
        public Type getType() throws MappingException {
            return this.getMetadata().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(this.typeName);
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public void addColumn(Column column) {
            if (this.columnName != null) {
                throw new MappingException("ANY discriminator already contained column");
            }
            super.addColumn(column);
            this.columnName = Any.columnName(column, this.getBuildingContext());
            this.selectableConsumer.accept(column);
            column.setValue(this);
        }

        @Override
        public void addColumn(Column column, boolean isInsertable, boolean isUpdatable) {
            if (this.columnName != null) {
                throw new MappingException("ANY discriminator already contained column");
            }
            super.addColumn(column, isInsertable, isUpdatable);
            this.columnName = Any.columnName(column, this.getBuildingContext());
            this.selectableConsumer.accept(column);
            column.setValue(this);
        }

        @Override
        public void addFormula(Formula formula) {
            if (this.columnName != null) {
                throw new MappingException("ANY discriminator already contained column");
            }
            super.addFormula(formula);
            this.columnName = formula.getFormula();
            this.selectableConsumer.accept(formula);
        }

        @Override
        public boolean isValid(MappingContext mappingContext) {
            return this.columnName != null && this.getType().getColumnSpan(mappingContext) == 1;
        }
    }

    public static class KeyValue
    extends SimpleValue {
        private String typeName;
        private final Consumer<Selectable> selectableConsumer;

        public KeyValue(Consumer<Selectable> selectableConsumer, MetadataBuildingContext buildingContext) {
            super(buildingContext);
            this.selectableConsumer = selectableConsumer;
        }

        public KeyValue(Consumer<Selectable> selectableConsumer, MetadataBuildingContext buildingContext, Table table) {
            super(buildingContext, table);
            this.selectableConsumer = selectableConsumer;
        }

        private KeyValue(KeyValue original) {
            super(original);
            this.typeName = original.typeName;
            this.selectableConsumer = original.selectableConsumer;
        }

        @Override
        public KeyValue copy() {
            return new KeyValue(this);
        }

        @Override
        public Type getType() throws MappingException {
            return this.getMetadata().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(this.typeName);
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public void addColumn(Column column) {
            super.addColumn(column);
            this.selectableConsumer.accept(column);
        }

        @Override
        public void addColumn(Column column, boolean isInsertable, boolean isUpdatable) {
            super.addColumn(column, isInsertable, isUpdatable);
            this.selectableConsumer.accept(column);
        }

        @Override
        public void addFormula(Formula formula) {
            super.addFormula(formula);
            this.selectableConsumer.accept(formula);
        }
    }
}

