/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.jbang;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.ResolvedArtifactDependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JBangDevModeLauncherImpl
implements Closeable {
    private final CuratedApplication curatedApp;
    private final Closeable runningApp;

    public static Closeable main(String ... args) {
        JBangDevModeLauncherImpl jBangDevModeLauncherImpl;
        System.clearProperty("quarkus.dev");
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        URL url = JBangDevModeLauncherImpl.class.getClassLoader().getResource("jbang-dev.dat");
        String jarFilePath = url.getPath().substring(5, url.getPath().indexOf("!"));
        DataInputStream contextStream = new DataInputStream(JBangDevModeLauncherImpl.class.getClassLoader().getResourceAsStream("jbang-dev.dat"));
        try {
            String pomContents = contextStream.readUTF();
            Path sourceFile = Paths.get(contextStream.readUTF(), new String[0]);
            int depCount = contextStream.readInt();
            HashMap<String, Path> deps = new HashMap<String, Path>();
            for (int i = 0; i < depCount; ++i) {
                String name = contextStream.readUTF();
                Path path = Paths.get(contextStream.readUTF(), new String[0]);
                deps.put(name, path);
            }
            Path projectRoot = Files.createTempDirectory("quarkus-jbang", new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(projectRoot.resolve("pom.xml"), new OpenOption[0]);){
                out.write(pomContents.getBytes(StandardCharsets.UTF_8));
            }
            Path targetClasses = projectRoot.resolve("target/classes");
            Files.createDirectories(targetClasses, new FileAttribute[0]);
            try (ZipFile fz = new ZipFile(new File(jarFilePath));){
                Enumeration<? extends ZipEntry> entries = fz.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    Path path = targetClasses.resolve(entry.getName()).normalize();
                    if (!path.startsWith(targetClasses)) {
                        throw new IOException("Bad ZIP entry: " + String.valueOf(path));
                    }
                    if (entry.isDirectory()) {
                        Files.createDirectories(path, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.copy(fz.getInputStream(entry), path, new CopyOption[0]);
                    Files.setLastModifiedTime(path, entry.getLastModifiedTime());
                }
            }
            Path srcDir = projectRoot.resolve("src/main/java");
            Files.createDirectories(srcDir, new FileAttribute[0]);
            Path source = Files.createSymbolicLink(srcDir.resolve(sourceFile.getFileName().toString()), sourceFile, new FileAttribute[0]);
            LocalProject currentProject = LocalProject.loadWorkspace((Path)projectRoot);
            ResolvedDependency appArtifact = ((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords((ArtifactCoords)currentProject.getAppArtifact("jar"))).setResolvedPath(targetClasses).setWorkspaceModule(currentProject.toWorkspaceModule()).build();
            Properties configurationProperties = JBangDevModeLauncherImpl.getConfigurationProperties(source);
            QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setBaseClassLoader(JBangDevModeLauncherImpl.class.getClassLoader()).setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.DEV).setTargetDirectory(targetClasses).setAppArtifact(appArtifact).setManagingProject(ArtifactCoords.pom((String)"io.quarkus", (String)"quarkus-bom", (String)JBangDevModeLauncherImpl.getQuarkusVersion())).setForcedDependencies(deps.entrySet().stream().map(s -> {
                ArtifactDependency artifact;
                String[] parts = ((String)s.getKey()).split(":");
                if (parts.length == 3) {
                    artifact = new ArtifactDependency(parts[0], parts[1], null, "jar", parts[2]);
                } else if (parts.length == 4) {
                    artifact = new ArtifactDependency(parts[0], parts[1], null, parts[2], parts[3]);
                } else if (parts.length == 5) {
                    artifact = new ArtifactDependency(parts[0], parts[1], parts[3], parts[2], parts[4]);
                } else {
                    throw new RuntimeException("Invalid artifact " + String.valueOf(s));
                }
                return artifact;
            }).collect(Collectors.toList())).setApplicationRoot(targetClasses).setProjectRoot(projectRoot).setBuildSystemProperties(configurationProperties).setRuntimeProperties(configurationProperties);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("app-project", currentProject);
            context.put("args", args);
            context.put("app-classes", targetClasses);
            BootstrapMavenContext mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setCurrentProject(currentProject));
            MavenArtifactResolver mvnResolver = new MavenArtifactResolver(mvnCtx);
            builder.setMavenArtifactResolver(mvnResolver);
            ((ResolvedArtifactDependency)currentProject.getAppArtifact("jar")).setResolvedPaths((PathCollection)PathList.of((Path[])new Path[]{targetClasses}));
            CuratedApplication curatedApp = builder.build().bootstrap();
            Object appInstance = curatedApp.runInAugmentClassLoader("io.quarkus.deployment.dev.IDEDevModeMain", context);
            jBangDevModeLauncherImpl = new JBangDevModeLauncherImpl(curatedApp, appInstance == null ? null : (appInstance instanceof Closeable ? (Closeable)appInstance : null));
        }
        catch (Throwable throwable) {
            try {
                try {
                    contextStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        contextStream.close();
        return jBangDevModeLauncherImpl;
    }

    private JBangDevModeLauncherImpl(CuratedApplication curatedApp, Closeable runningApp) {
        this.curatedApp = curatedApp;
        this.runningApp = runningApp;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.runningApp != null) {
                this.runningApp.close();
            }
        }
        finally {
            if (this.curatedApp != null) {
                this.curatedApp.close();
            }
        }
    }

    private static String getQuarkusVersion() {
        String string;
        block9: {
            InputStream in = JBangDevModeLauncherImpl.class.getClassLoader().getResourceAsStream("quarkus-version.txt");
            try {
                int r;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[10];
                while ((r = in.read(buf)) > 0) {
                    out.write(buf, 0, r);
                }
                string = new String(out.toByteArray(), StandardCharsets.UTF_8);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return string;
    }

    private static Properties getConfigurationProperties(Path source) throws IOException {
        Properties properties = new Properties();
        for (String line : Files.readAllLines(source)) {
            if (!line.startsWith("//Q:CONFIG")) continue;
            String conf = line.substring(10).trim();
            int equals = conf.indexOf("=");
            if (equals == -1) {
                throw new RuntimeException("invalid config  " + line);
            }
            properties.setProperty(conf.substring(0, equals), conf.substring(equals + 1));
        }
        return properties;
    }
}

