/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.msadlds;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.msadlds.MSADLDSUserAccountControlStorageMapper;

public class MSADLDSUserAccountControlStorageMapperFactory
extends AbstractLDAPStorageMapperFactory {
    public static final String PROVIDER_ID = "msad-lds-user-account-control-mapper";
    protected static final List<ProviderConfigProperty> configProperties = MSADLDSUserAccountControlStorageMapperFactory.getConfigProps(null);

    private static List<ProviderConfigProperty> getConfigProps(ComponentModel parentModel) {
        UserStorageProviderModel parent;
        UserStorageProviderModel userStorageProviderModel = parent = parentModel != null ? new UserStorageProviderModel(parentModel) : new UserStorageProviderModel();
        if (parent.isImportEnabled()) {
            ProviderConfigurationBuilder config = ProviderConfigurationBuilder.create().property().name("always.read.enabled.value.from.ldap").label("Always Read Enabled Value From LDAP").helpText("If on, the user enabled/disabled state will always be read from MSAD LDS by checking the msDS-UserAccountDisabled attribute").type("boolean").defaultValue((Object)"false").add();
            return config.build();
        }
        return new ArrayList<ProviderConfigProperty>();
    }

    @Override
    public String getHelpText() {
        return "Mapper specific to MSAD LDS. It's able to integrate the MSAD LDS user account state into Keycloak account state (account enabled, password is expired etc). It's using msDS-UserAccountDisabled and pwdLastSet MSAD attributes for that. For example if pwdLastSet is 0, the Keycloak user is required to update password, if msDS-UserAccountDisabled is 'TRUE' the Keycloak user is disabled as well etc. Mapper is also able to handle exception code from LDAP user authentication.";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public List<ProviderConfigProperty> getConfigProperties(RealmModel realm, ComponentModel parent) {
        return MSADLDSUserAccountControlStorageMapperFactory.getConfigProps(parent);
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new MSADLDSUserAccountControlStorageMapper(mapperModel, federationProvider);
    }
}

