/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.metrics;

import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricReusableDataMarshaler;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpMetricExporter
implements MetricExporter {
    private final HttpExporterBuilder<Marshaler> builder;
    private final HttpExporter<Marshaler> delegate;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;
    private final DefaultAggregationSelector defaultAggregationSelector;
    private final MetricReusableDataMarshaler marshaler;

    OtlpHttpMetricExporter(HttpExporterBuilder<Marshaler> builder, HttpExporter<Marshaler> delegate, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
        this.marshaler = new MetricReusableDataMarshaler(memoryMode, (arg_0, arg_1) -> delegate.export(arg_0, arg_1));
    }

    public static OtlpHttpMetricExporter getDefault() {
        return OtlpHttpMetricExporter.builder().build();
    }

    public static OtlpHttpMetricExporterBuilder builder() {
        return new OtlpHttpMetricExporterBuilder();
    }

    public OtlpHttpMetricExporterBuilder toBuilder() {
        return new OtlpHttpMetricExporterBuilder((HttpExporterBuilder<Marshaler>)this.builder.copy(), this.marshaler.getMemoryMode());
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    public MemoryMode getMemoryMode() {
        return this.marshaler.getMemoryMode();
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        return this.marshaler.export(metrics);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpHttpMetricExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("aggregationTemporalitySelector=" + AggregationTemporalitySelector.asString((AggregationTemporalitySelector)this.aggregationTemporalitySelector));
        joiner.add("defaultAggregationSelector=" + DefaultAggregationSelector.asString((DefaultAggregationSelector)this.defaultAggregationSelector));
        joiner.add("memoryMode=" + this.marshaler.getMemoryMode());
        return joiner.toString();
    }
}

