/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.community.dialect.TiDBDialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.sql.ast.MySQLSqlAstTranslator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcOperationQueryInsertImpl;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;

public class TiDBSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private final TiDBDialect dialect;

    public TiDBSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement, TiDBDialect dialect) {
        super(sessionFactory, statement);
        this.dialect = dialect;
    }

    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql('(');
            this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
            this.appendSql(" div ");
            this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
            this.appendSql(')');
        } else {
            super.visitBinaryArithmeticExpression(arithmeticExpression);
        }
    }

    protected void visitInsertSource(InsertSelectStatement statement) {
        if (statement.getSourceSelectStatement() != null) {
            if (statement.getConflictClause() != null) {
                List targetColumnReferences = statement.getTargetColumns();
                ArrayList<String> columnNames = new ArrayList<String>(targetColumnReferences.size());
                for (ColumnReference targetColumnReference : targetColumnReferences) {
                    columnNames.add(targetColumnReference.getColumnExpression());
                }
                this.appendSql("select * from ");
                this.emulateQueryPartTableReferenceColumnAliasing(new QueryPartTableReference(new SelectStatement(statement.getSourceSelectStatement()), "excluded", columnNames, false, this.getSessionFactory()));
            } else {
                statement.getSourceSelectStatement().accept((SqlAstWalker)this);
            }
        } else {
            this.visitValuesList(statement.getValuesList());
        }
    }

    public void visitColumnReference(ColumnReference columnReference) {
        Statement currentStatement;
        if ("excluded".equals(columnReference.getQualifier()) && (currentStatement = (Statement)this.getStatementStack().getCurrent()) instanceof InsertSelectStatement && ((InsertSelectStatement)currentStatement).getSourceSelectStatement() == null) {
            this.appendSql("values(");
            columnReference.appendReadExpression((SqlAppender)this, null);
            this.append(')');
        } else {
            super.visitColumnReference(columnReference);
        }
    }

    protected void renderDeleteClause(DeleteStatement statement) {
        this.appendSql("delete");
        Stack clauseStack = this.getClauseStack();
        try {
            clauseStack.push((Object)Clause.DELETE);
            this.renderTableReferenceIdentificationVariable((TableReference)statement.getTargetTable());
            if (statement.getFromClause().getRoots().isEmpty()) {
                this.appendSql(" from ");
                this.renderDmlTargetTableExpression(statement.getTargetTable());
            } else {
                this.visitFromClause(statement.getFromClause());
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    protected void renderUpdateClause(UpdateStatement updateStatement) {
        if (updateStatement.getFromClause().getRoots().isEmpty()) {
            super.renderUpdateClause(updateStatement);
        } else {
            this.appendSql("update ");
            this.renderFromClauseSpaces(updateStatement.getFromClause());
        }
    }

    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
        }
    }

    protected JdbcOperationQueryInsert translateInsert(InsertSelectStatement sqlAst) {
        this.visitInsertStatement(sqlAst);
        return new JdbcOperationQueryInsertImpl(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), this.getUniqueConstraintNameThatMayFail(sqlAst));
    }

    protected void visitConflictClause(ConflictClause conflictClause) {
        this.visitOnDuplicateKeyConflictClause(conflictClause);
    }

    protected String determineColumnReferenceQualifier(ColumnReference columnReference) {
        String dmlAlias;
        MutationStatement currentDmlStatement;
        DmlTargetColumnQualifierSupport qualifierSupport = this.getDialect().getDmlTargetColumnQualifierSupport();
        if (this.getClauseStack().getCurrent() != Clause.SET || !((currentDmlStatement = this.getCurrentDmlStatement()) instanceof InsertSelectStatement) || (dmlAlias = currentDmlStatement.getTargetTable().getIdentificationVariable()) == null || !dmlAlias.equals(columnReference.getQualifier())) {
            return columnReference.getQualifier();
        }
        if (qualifierSupport != DmlTargetColumnQualifierSupport.NONE || !this.getQueryPartStack().isEmpty()) {
            return this.getCurrentDmlStatement().getTargetTable().getTableExpression();
        }
        return null;
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept((SqlAstWalker)this);
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.dialect.supportsWindowFunctions() && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    protected void renderDerivedTableReferenceIdentificationVariable(DerivedTableReference tableReference) {
        this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderCombinedLimitClause(queryPart);
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonDistinctOperator(lhs, operator, rhs);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0'");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(" with ");
            this.appendSql(summarization.getKind().sqlText());
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitLikePredicate(LikePredicate likePredicate) {
        if (likePredicate.isCaseSensitive()) {
            likePredicate.getMatchExpression().accept((SqlAstWalker)this);
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" like ");
            this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.dialect.isNoBackslashEscapesEnabled());
        } else {
            this.appendSql(this.dialect.getLowercaseFunction());
            this.appendSql('(');
            likePredicate.getMatchExpression().accept((SqlAstWalker)this);
            this.appendSql(')');
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" like ");
            this.appendSql(this.dialect.getLowercaseFunction());
            this.appendSql('(');
            this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.dialect.isNoBackslashEscapesEnabled());
            this.appendSql(')');
        }
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept((SqlAstWalker)this);
        }
    }

    public TiDBDialect getDialect() {
        return this.dialect;
    }

    public void visitCastTarget(CastTarget castTarget) {
        String sqlType = MySQLSqlAstTranslator.getSqlType((CastTarget)castTarget, (SessionFactoryImplementor)this.getSessionFactory());
        if (sqlType != null) {
            this.appendSql(sqlType);
        } else {
            super.visitCastTarget(castTarget);
        }
    }

    protected void renderStringContainsExactlyPredicate(Expression haystack, Expression needle) {
        haystack.accept((SqlAstWalker)this);
        this.appendSql(" like concat('%',replace(replace(replace(");
        needle.accept((SqlAstWalker)this);
        this.appendSql(",'~','~~'),'?','~?'),'%','~%'),'%') escape '~'");
    }
}

