/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.builders.SerializedMultiEmitter;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.LongConsumer;

abstract class BaseMultiEmitter<T>
implements MultiEmitter<T>,
Flow.Subscription,
ContextSupport {
    protected final AtomicLong requested = new AtomicLong();
    protected final MultiSubscriber<? super T> downstream;
    private final AtomicBoolean disposed = new AtomicBoolean();
    private volatile Runnable onTermination;
    private volatile Runnable onCancellation;
    private volatile LongConsumer onRequest;
    private static final AtomicReferenceFieldUpdater<BaseMultiEmitter, Runnable> ON_TERMINATION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BaseMultiEmitter.class, Runnable.class, "onTermination");
    private static final AtomicReferenceFieldUpdater<BaseMultiEmitter, Runnable> ON_CANCELLATION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BaseMultiEmitter.class, Runnable.class, "onCancellation");
    private static final Runnable CLEARED = () -> {};

    BaseMultiEmitter(MultiSubscriber<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public Context context() {
        if (this.downstream instanceof ContextSupport) {
            return ((ContextSupport)((Object)this.downstream)).context();
        }
        return Context.empty();
    }

    @Override
    public long requested() {
        return this.requested.get();
    }

    @Override
    public void complete() {
        this.completion();
    }

    protected void completion() {
        if (this.isCancelled()) {
            return;
        }
        try {
            this.downstream.onCompletion();
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.onTermination == CLEARED;
    }

    protected void cleanup() {
        this.disposed.set(true);
        Runnable action = ON_TERMINATION_UPDATER.getAndSet(this, CLEARED);
        if (action != null && action != CLEARED) {
            action.run();
        }
    }

    @Override
    public final void fail(Throwable failure) {
        this.failed(failure);
    }

    protected void failed(Throwable e) {
        if (e == null) {
            e = new NullPointerException("onError called with null.");
        }
        if (this.isCancelled()) {
            return;
        }
        try {
            this.downstream.onFailure(e);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public final void cancel() {
        if (this.disposed.compareAndSet(false, true)) {
            this.cleanup();
            this.onUnsubscribed();
            Runnable callback = ON_CANCELLATION_UPDATER.getAndSet(this, CLEARED);
            if (callback != null && callback != CLEARED) {
                callback.run();
            }
        }
    }

    void onUnsubscribed() {
    }

    @Override
    public final void request(long n) {
        if (n > 0L) {
            if (this.disposed.get()) {
                return;
            }
            Subscriptions.add(this.requested, n);
            this.onRequested();
            LongConsumer callback = this.onRequest;
            if (callback != null) {
                callback.accept(n);
            }
        } else {
            this.cancel();
            this.downstream.onError(Subscriptions.getInvalidRequestException());
        }
    }

    void onRequested() {
    }

    @Override
    public MultiEmitter<T> onTermination(Runnable onTermination) {
        ParameterValidation.nonNull(onTermination, "onTermination");
        if (!this.disposed.get()) {
            this.onTermination = onTermination;
            if (this.disposed.get()) {
                onTermination.run();
            }
        } else {
            onTermination.run();
        }
        return this;
    }

    public MultiEmitter<T> serialize() {
        return new SerializedMultiEmitter(this);
    }

    @Override
    public MultiEmitter<T> onRequest(LongConsumer consumer) {
        ParameterValidation.nonNull(consumer, "consumer");
        if (!this.disposed.get()) {
            this.onRequest = consumer;
        }
        return this;
    }

    @Override
    public MultiEmitter<T> onCancellation(Runnable onCancellation) {
        ParameterValidation.nonNull(onCancellation, "onCancellation");
        if (!this.disposed.get()) {
            this.onCancellation = onCancellation;
        }
        return this;
    }
}

