/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.customized;

import io.quarkus.arc.ArcContainer;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.customized.JsonFormatterCustomizationCheck;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.type.descriptor.java.spi.JsonJavaType;
import org.hibernate.type.descriptor.java.spi.XmlJavaType;
import org.jboss.logging.Logger;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BuiltinFormatMapperBehaviour {
    IGNORE{

        @Override
        protected void action(String puName, String type, List<String> causes) {
        }
    }
    ,
    WARN{

        @Override
        protected void action(String puName, String type, List<String> causes) {
            LOGGER.warn((Object)BuiltinFormatMapperBehaviour.message(puName, type, causes));
        }
    }
    ,
    FAIL{

        @Override
        protected void action(String puName, String type, List<String> causes) {
            throw new IllegalStateException(BuiltinFormatMapperBehaviour.message(puName, type, causes));
        }
    };

    private static final Logger LOGGER;
    private static final String TYPE_JSON = "JSON";
    private static final String TYPE_XML = "XML";

    private static String message(String puName, String type, List<String> causes) {
        return String.format(Locale.ROOT, "Persistence unit [%1$s] uses Quarkus' main formatting facilities for %2$s columns in the database. \nAs these facilities are primarily meant for REST endpoints, and they might have been customized for such use, this may lead to undesired behavior, up to and including data loss. \nTo address this:\n\t- If the application does not customize the %2$s serialization/deserialization, set \"quarkus.hibernate-orm.mapping.format.global=ignore\". This will be the default in future versions of Quarkus. \n\t- Otherwise, define a custom `FormatMapper` bean annotated with " + (TYPE_JSON.equals(type) ? "@JsonFormat" : "@XmlFormat") + " and @PersistenceUnitExtension" + (PersistenceUnitUtil.isDefaultPersistenceUnit(puName) ? "" : "(\"%1$s\")") + " to address your database serialization/deserialization needs.\nThe reasons why the check was triggered are: \n\t-" + String.join((CharSequence)"\n\t-", causes) + "\nSee the migration guide for more details and how to proceed.", puName, type);
    }

    public static boolean hasJsonProperties(MetadataImplementor metadata) {
        AtomicBoolean hasJsonProperties = new AtomicBoolean(false);
        metadata.getTypeConfiguration().getJavaTypeRegistry().forEachDescriptor(javaType -> {
            if (javaType instanceof JsonJavaType) {
                hasJsonProperties.set(true);
            }
        });
        if (hasJsonProperties.get()) {
            return true;
        }
        return metadata.getTypeConfiguration().getJdbcTypeRegistry().hasRegisteredDescriptor(3018);
    }

    public static boolean hasXmlProperties(MetadataImplementor metadata) {
        AtomicBoolean hasXmlProperties = new AtomicBoolean(false);
        metadata.getTypeConfiguration().getJavaTypeRegistry().forEachDescriptor(javaType -> {
            if (javaType instanceof XmlJavaType) {
                hasXmlProperties.set(true);
            }
        });
        if (hasXmlProperties.get()) {
            return true;
        }
        return metadata.getTypeConfiguration().getJdbcTypeRegistry().hasRegisteredDescriptor(3019);
    }

    public void jsonApply(MetadataImplementor metadata, String puName, ArcContainer container, JsonFormatterCustomizationCheck check) {
        List<String> causes;
        if (BuiltinFormatMapperBehaviour.hasJsonProperties(metadata) && !(causes = check.apply(container)).isEmpty()) {
            this.action(puName, TYPE_JSON, causes);
        }
    }

    public void xmlApply(MetadataImplementor metadata, String puName) {
        if (BuiltinFormatMapperBehaviour.hasXmlProperties(metadata)) {
            this.action(puName, TYPE_XML, List.of("The XML format mapper uses the legacy format. It is not compatible with the new default one."));
        }
    }

    protected abstract void action(String var1, String var2, List<String> var3);

    static {
        LOGGER = Logger.getLogger(BuiltinFormatMapperBehaviour.class);
    }
}

