/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.spi;

import jakarta.ws.rs.container.ResourceInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jboss.resteasy.reactive.server.util.MethodId;

public class ResteasyReactiveResourceInfo
implements ResourceInfo {
    private final String name;
    private final Class<?> declaringClass;
    private final Class[] parameterTypes;
    public final boolean isNonBlocking;
    private final String actualDeclaringClassName;
    private volatile Method method;
    private volatile Annotation[] annotations;
    private volatile Type returnType;
    private volatile String methodId;

    public ResteasyReactiveResourceInfo(String name, Class<?> declaringClass, Class[] parameterTypes, boolean isNonBlocking, String actualDeclaringClassName) {
        this.name = name;
        this.declaringClass = declaringClass;
        this.parameterTypes = parameterTypes;
        this.isNonBlocking = isNonBlocking;
        this.actualDeclaringClassName = actualDeclaringClassName;
    }

    public String getName() {
        return this.name;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod() {
        if (this.method == null) {
            ResteasyReactiveResourceInfo resteasyReactiveResourceInfo = this;
            synchronized (resteasyReactiveResourceInfo) {
                if (this.method == null) {
                    try {
                        Method declaredMethod = this.declaringClass.getMethod(this.name, this.parameterTypes);
                        this.annotations = declaredMethod.getAnnotations();
                        this.returnType = declaredMethod.getGenericReturnType();
                        this.method = declaredMethod;
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.method;
    }

    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.getMethod();
        }
        return this.annotations;
    }

    public Type getGenericReturnType() {
        if (this.returnType == null) {
            this.getMethod();
        }
        return this.returnType;
    }

    public Method getResourceMethod() {
        return this.getMethod();
    }

    public Class<?> getResourceClass() {
        return this.declaringClass;
    }

    public Annotation[] getParameterAnnotations(int index) {
        return this.getMethod().getParameterAnnotations()[index];
    }

    public String getMethodId() {
        if (this.methodId == null) {
            this.methodId = MethodId.get(this.name, this.declaringClass, this.parameterTypes);
        }
        return this.methodId;
    }

    @Deprecated
    public String getActualDeclaringClassName() {
        return this.actualDeclaringClassName;
    }
}

