/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonValueFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class MariaDBJsonValueFunction
extends JsonValueFunction {
    public MariaDBJsonValueFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonValueFunction.JsonValueArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonValueErrorBehavior.NULL) {
            throw new QueryException("Can't emulate on error clause on MariaDB");
        }
        if (arguments.emptyBehavior() != null && arguments.emptyBehavior() != JsonValueEmptyBehavior.NULL) {
            throw new QueryException("Can't emulate on empty clause on MariaDB");
        }
        if (arguments.returningType() != null) {
            if (arguments.returningType().getJdbcMapping().getJdbcType().isBoolean()) {
                sqlAppender.append("case ");
            } else {
                sqlAppender.append("cast(");
            }
        }
        sqlAppender.appendSql("json_unquote(nullif(json_extract(");
        arguments.jsonDocument().accept(walker);
        sqlAppender.appendSql(",");
        JsonPathPassingClause passingClause = arguments.passingClause();
        if (passingClause == null) {
            arguments.jsonPath().accept(walker);
        } else {
            JsonPathHelper.appendJsonPathConcatPassingClause(sqlAppender, arguments.jsonPath(), passingClause, walker);
        }
        sqlAppender.appendSql("),'null'))");
        if (arguments.returningType() != null) {
            if (arguments.returningType().getJdbcMapping().getJdbcType().isBoolean()) {
                sqlAppender.append(" when 'true' then true when 'false' then false end ");
            } else {
                sqlAppender.appendSql(" as ");
                arguments.returningType().accept(walker);
                sqlAppender.appendSql(')');
            }
        }
    }
}

